/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.IronPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.MacPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.MayaSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyPySdkFlavor;
import com.jetbrains.python.sdk.flavors.PyRemoteSdkFlavor;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonSdkFlavor {
    private static final Pattern VERSION_RE = Pattern.compile("(Python \\S+).*");
    private static final Logger LOG = Logger.getInstance(PythonSdkFlavor.class);

    public static Collection<String> appendSystemPythonPath(@NotNull Collection<String> pythonPath) {
        if (pythonPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pythonPath", "com/jetbrains/python/sdk/flavors/PythonSdkFlavor", "appendSystemPythonPath"));
        }
        return PythonSdkFlavor.appendSystemEnvPaths(pythonPath, "PYTHONPATH");
    }

    protected static Collection<String> appendSystemEnvPaths(@NotNull Collection<String> pythonPath, String envname) {
        if (pythonPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pythonPath", "com/jetbrains/python/sdk/flavors/PythonSdkFlavor", "appendSystemEnvPaths"));
        }
        String syspath = System.getenv(envname);
        if (syspath != null) {
            pythonPath.addAll(Lists.newArrayList((Object[])syspath.split(File.pathSeparator)));
        }
        return pythonPath;
    }

    public static void initPythonPath(@NotNull Map<String, String> envs, boolean passParentEnvs, @NotNull Collection<String> pythonPathList) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/jetbrains/python/sdk/flavors/PythonSdkFlavor", "initPythonPath"));
        }
        if (pythonPathList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pythonPathList", "com/jetbrains/python/sdk/flavors/PythonSdkFlavor", "initPythonPath"));
        }
        if (passParentEnvs && !envs.containsKey("PYTHONPATH")) {
            pythonPathList = PythonSdkFlavor.appendSystemPythonPath(pythonPathList);
        }
        PythonEnvUtil.addToPythonPath(envs, pythonPathList);
    }

    public Collection<String> suggestHomePaths() {
        return Collections.emptyList();
    }

    public static List<PythonSdkFlavor> getApplicableFlavors() {
        return PythonSdkFlavor.getApplicableFlavors(true);
    }

    public static List<PythonSdkFlavor> getApplicableFlavors(boolean addPlatformIndependent) {
        ArrayList<PythonSdkFlavor> result = new ArrayList<PythonSdkFlavor>();
        if (SystemInfo.isWindows) {
            result.add(WinPythonSdkFlavor.INSTANCE);
        } else if (SystemInfo.isMac) {
            result.add(MacPythonSdkFlavor.INSTANCE);
        } else if (SystemInfo.isUnix) {
            result.add(UnixPythonSdkFlavor.INSTANCE);
        }
        if (addPlatformIndependent) {
            result.addAll(PythonSdkFlavor.getPlatformIndependentFlavors());
        }
        return result;
    }

    public static List<PythonSdkFlavor> getPlatformIndependentFlavors() {
        ArrayList result = Lists.newArrayList();
        result.add(JythonSdkFlavor.INSTANCE);
        result.add(IronPythonSdkFlavor.INSTANCE);
        result.add(PyPySdkFlavor.INSTANCE);
        result.add(VirtualEnvSdkFlavor.INSTANCE);
        result.add(PyRemoteSdkFlavor.INSTANCE);
        result.add(MayaSdkFlavor.INSTANCE);
        return result;
    }

    @Nullable
    public static PythonSdkFlavor getFlavor(Sdk sdk) {
        PythonSdkFlavor flavor;
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof PythonSdkAdditionalData && (flavor = ((PythonSdkAdditionalData)data).getFlavor()) != null) {
            return flavor;
        }
        return PythonSdkFlavor.getFlavor(sdk.getHomePath());
    }

    @Nullable
    public static PythonSdkFlavor getFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getApplicableFlavors()) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    @Nullable
    public static PythonSdkFlavor getPlatformIndependentFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getPlatformIndependentFlavors()) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    public boolean isValidSdkHome(String path) {
        File file = new File(path);
        return file.isFile() && this.isValidSdkPath(file);
    }

    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/sdk/flavors/PythonSdkFlavor", "isValidSdkPath"));
        }
        return FileUtil.getNameWithoutExtension((File)file).toLowerCase().startsWith("python");
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        if (sdkHome == null) {
            return null;
        }
        String runDirectory = new File(sdkHome).getParent();
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(runDirectory, new String[]{sdkHome, this.getVersionOption()}, 10000);
        return this.getVersionStringFromOutput(processOutput);
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull ProcessOutput processOutput) {
        if (processOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutput", "com/jetbrains/python/sdk/flavors/PythonSdkFlavor", "getVersionStringFromOutput"));
        }
        if (processOutput.getExitCode() != 0) {
            String errors = processOutput.getStderr();
            if (StringUtil.isEmpty((String)errors)) {
                errors = processOutput.getStdout();
            }
            LOG.warn("Couldn't get interpreter version: process exited with code " + processOutput.getExitCode() + "\n" + errors);
            return null;
        }
        String result = this.getVersionStringFromOutput(processOutput.getStderr());
        if (result != null) {
            return result;
        }
        return this.getVersionStringFromOutput(processOutput.getStdout());
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/jetbrains/python/sdk/flavors/PythonSdkFlavor", "getVersionStringFromOutput"));
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE);
    }

    public String getVersionOption() {
        return "-V";
    }

    public Collection<String> getExtraDebugOptions() {
        return Collections.emptyList();
    }

    public void initPythonPath(GeneralCommandLine cmd, Collection<String> path) {
        this.initPythonPath(path, cmd.getEnvironment());
    }

    public static void addToEnv(String key, String value, Map<String, String> envs) {
        PythonEnvUtil.addPathToEnv(envs, key, value);
    }

    public void addPredefinedEnvironmentVariables(Map<String, String> envs) {
        Charset defaultCharset = EncodingManager.getInstance().getDefaultCharset();
        if (defaultCharset != null) {
            String encoding = defaultCharset.name();
            PythonEnvUtil.setPythonIOEncoding(envs, encoding);
        }
    }

    @NotNull
    public abstract String getName();

    public LanguageLevel getLanguageLevel(Sdk sdk) {
        String version = sdk.getVersionString();
        String prefix = this.getName() + " ";
        if (version != null && version.startsWith(prefix)) {
            return LanguageLevel.fromPythonVersion(version.substring(prefix.length()));
        }
        return LanguageLevel.getDefault();
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    public void initPythonPath(Collection<String> path, Map<String, String> env) {
        path = PythonSdkFlavor.appendSystemPythonPath(path);
        PythonSdkFlavor.addToEnv("PYTHONPATH", StringUtil.join(path, (String)File.pathSeparator), env);
    }

    public VirtualFile getSdkPath(VirtualFile path) {
        return path;
    }
}

