/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteFile;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import icons.PythonIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class PyRemoteSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] NAMES = new String[]{"python", "jython", "pypy", "python.exe", "jython.bat", "pypy.exe"};
    public static PyRemoteSdkFlavor INSTANCE = new PyRemoteSdkFlavor();

    private PyRemoteSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths() {
        return Lists.newArrayList();
    }

    @Override
    public boolean isValidSdkHome(String path) {
        return StringUtil.isNotEmpty((String)path) && PyRemoteSdkFlavor.checkName(NAMES, PyRemoteSdkFlavor.getExecutableName(path)) && (path.startsWith("ssh:") || path.startsWith("vagrant:"));
    }

    private static boolean checkName(String[] names, @Nullable String name) {
        if (name == null) {
            return false;
        }
        for (String n : names) {
            if (!name.startsWith(n)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getExecutableName(String path) {
        return RemoteFile.createRemoteFile(path).getName();
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.RemoteInterpreter;
    }
}

