/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPySdkFlavor
extends PythonSdkFlavor {
    public static PyPySdkFlavor INSTANCE = new PyPySdkFlavor();
    private static final Pattern VERSION_RE = Pattern.compile("\\[(PyPy \\S+).*\\]");
    private static final Pattern PYTHON_VERSION_RE = Pattern.compile("(Python \\S+).*");
    private static final Pattern VERSION_STRING_RE = Pattern.compile("PyPy (\\S+)( \\[Python (\\S+)\\])?");

    private PyPySdkFlavor() {
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/sdk/flavors/PyPySdkFlavor", "isValidSdkPath"));
        }
        return FileUtil.getNameWithoutExtension((File)file).toLowerCase().startsWith("pypy");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/jetbrains/python/sdk/flavors/PyPySdkFlavor", "getVersionStringFromOutput"));
        }
        List<String> lines = Arrays.asList(StringUtil.splitByLines((String)output));
        String version = PatternUtil.getFirstMatch(lines, (Pattern)VERSION_RE);
        String pythonVersion = PatternUtil.getFirstMatch(lines, (Pattern)PYTHON_VERSION_RE);
        if (version != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(version);
            if (pythonVersion != null) {
                builder.append(" [");
                builder.append(pythonVersion);
                builder.append("]");
            }
            return builder.toString();
        }
        return null;
    }

    @Override
    public String getVersionOption() {
        return "--version";
    }

    @Override
    @NotNull
    public String getName() {
        if ("PyPy" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/flavors/PyPySdkFlavor", "getName"));
        }
        return "PyPy";
    }

    @Override
    public LanguageLevel getLanguageLevel(Sdk sdk) {
        Matcher matcher;
        String versionString = sdk.getVersionString();
        if (versionString != null && (matcher = VERSION_STRING_RE.matcher(versionString)).matches()) {
            String version = matcher.group(1);
            String pythonVersion = matcher.group(3);
            if (pythonVersion != null) {
                return LanguageLevel.fromPythonVersion(pythonVersion);
            }
            if (version != null) {
                return LanguageLevel.fromPythonVersion(PyPySdkFlavor.getPythonVersion(version));
            }
        }
        return LanguageLevel.getDefault();
    }

    private static String getPythonVersion(@NotNull String pypyVersion) {
        if (pypyVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pypyVersion", "com/jetbrains/python/sdk/flavors/PyPySdkFlavor", "getPythonVersion"));
        }
        String DEFAULT = "2.4";
        String LATEST = "2.7";
        List vs = StringUtil.split((String)pypyVersion, (String)".");
        try {
            if (vs.size() >= 2) {
                int major = Integer.parseInt((String)vs.get(0));
                int minor = Integer.parseInt((String)vs.get(1));
                if (major > 1) {
                    return "2.7";
                }
                if (major == 1) {
                    if (minor >= 5) {
                        return "2.7";
                    }
                    if (minor >= 4) {
                        return "2.5";
                    }
                }
            }
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        return "2.4";
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Pypy;
    }
}

