/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MayaSdkFlavor
extends PythonSdkFlavor {
    public static MayaSdkFlavor INSTANCE = new MayaSdkFlavor();

    private MayaSdkFlavor() {
    }

    @Override
    public boolean isValidSdkHome(String path) {
        File file = new File(path);
        return file.isFile() && this.isValidSdkPath(file) || MayaSdkFlavor.isMayaFolder(file);
    }

    private static boolean isMayaFolder(File file) {
        return file.isDirectory() && file.getName().equals("Maya.app");
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/sdk/flavors/MayaSdkFlavor", "isValidSdkPath"));
        }
        String name = FileUtil.getNameWithoutExtension((File)file).toLowerCase();
        return name.startsWith("mayapy");
    }

    @Override
    public String getVersionOption() {
        return "--version";
    }

    @Override
    @NotNull
    public String getName() {
        if ("MayaPy" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/flavors/MayaSdkFlavor", "getName"));
        }
        return "MayaPy";
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    @Override
    public VirtualFile getSdkPath(VirtualFile path) {
        if (MayaSdkFlavor.isMayaFolder(new File(path.getPath()))) {
            return path.findFileByRelativePath("Contents/bin/mayapy");
        }
        return path;
    }
}

