/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JythonSdkFlavor
extends PythonSdkFlavor {
    private static final Pattern VERSION_RE = Pattern.compile("(Jython \\S+)( on .*)?");
    private static final String JYTHONPATH = "JYTHONPATH";
    private static final String PYTHON_PATH_PREFIX = "-Dpython.path=";
    public static JythonSdkFlavor INSTANCE = new JythonSdkFlavor();

    private JythonSdkFlavor() {
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/sdk/flavors/JythonSdkFlavor", "isValidSdkPath"));
        }
        return FileUtil.getNameWithoutExtension((File)file).toLowerCase().startsWith("jython");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/jetbrains/python/sdk/flavors/JythonSdkFlavor", "getVersionStringFromOutput"));
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE);
    }

    @Override
    public String getVersionOption() {
        return "--version";
    }

    @Override
    public void initPythonPath(GeneralCommandLine cmd, Collection<String> path) {
        this.initPythonPath(path, cmd.getEnvironment());
        ParamsGroup paramGroup = cmd.getParametersList().getParamsGroup("Exe Options");
        assert (paramGroup != null);
        for (String param : paramGroup.getParameters()) {
            if (!param.startsWith(PYTHON_PATH_PREFIX)) continue;
            return;
        }
        paramGroup.addParameter(JythonSdkFlavor.getPythonPathCmdLineArgument(path));
    }

    @Override
    public void initPythonPath(Collection<String> path, Map<String, String> env) {
        path = JythonSdkFlavor.appendSystemEnvPaths(path, JYTHONPATH);
        String jythonPath = StringUtil.join(path, (String)File.pathSeparator);
        JythonSdkFlavor.addToEnv(JYTHONPATH, jythonPath, env);
    }

    @Override
    @NotNull
    public String getName() {
        if ("Jython" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/flavors/JythonSdkFlavor", "getName"));
        }
        return "Jython";
    }

    public static String getPythonPathCmdLineArgument(Collection<String> path) {
        return PYTHON_PATH_PREFIX + StringUtil.join(JythonSdkFlavor.appendSystemEnvPaths(path, JYTHONPATH), (String)File.pathSeparator);
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Jython;
    }
}

