/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IronPythonSdkFlavor
extends PythonSdkFlavor {
    public static final Pattern VERSION_RE = Pattern.compile("\\w+ ([0-9\\.]+).*");
    public static IronPythonSdkFlavor INSTANCE = new IronPythonSdkFlavor();

    private IronPythonSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths() {
        File[] dirs;
        TreeSet<String> result = new TreeSet<String>();
        String root = System.getenv("ProgramFiles(x86)");
        if (root == null) {
            root = System.getenv("ProgramFiles");
        }
        if (root != null && (dirs = new File(root).listFiles()) != null) {
            for (File dir : dirs) {
                File ipy;
                if (!dir.getName().startsWith("IronPython") || !(ipy = new File(dir, "ipy.exe")).exists()) continue;
                result.add(ipy.getPath());
            }
        }
        WinPythonSdkFlavor.findInPath(result, "ipy.exe");
        WinPythonSdkFlavor.findInPath(result, "ipy64.exe");
        return result;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor", "isValidSdkPath"));
        }
        String name = file.getName();
        return name.equals("ipy.exe") || name.equals("ipy64.exe");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor", "getVersionStringFromOutput"));
        }
        String match = PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE);
        return match != null ? this.getName() + " " + match : null;
    }

    @Override
    public String getVersionOption() {
        return "-V";
    }

    @Override
    public Collection<String> getExtraDebugOptions() {
        return Collections.singletonList("-X:Frames");
    }

    @Override
    public void initPythonPath(GeneralCommandLine cmd, Collection<String> path) {
        this.initPythonPath(path, cmd.getEnvironment());
    }

    @Override
    public void initPythonPath(Collection<String> path, Map<String, String> env) {
        IronPythonSdkFlavor.addToEnv("IRONPYTHONPATH", StringUtil.join(path, (String)File.pathSeparator), env);
    }

    @Override
    @NotNull
    public String getName() {
        if ("IronPython" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor", "getName"));
        }
        return "IronPython";
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Dotnet;
    }
}

