/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkUpdater
implements StartupActivity {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.sdk.PythonSdkUpdater");
    private final Set<String> myAlreadyUpdated = new HashSet<String>();

    public static PythonSdkUpdater getInstance() {
        StartupActivity[] extensions;
        for (StartupActivity extension : extensions = (StartupActivity[])Extensions.getExtensions((ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY)) {
            if (!(extension instanceof PythonSdkUpdater)) continue;
            return (PythonSdkUpdater)extension;
        }
        throw new UnsupportedOperationException("could not find self");
    }

    public void markAlreadyUpdated(String path) {
        this.myAlreadyUpdated.add(path);
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/sdk/PythonSdkUpdater", "runActivity"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        this.updateActiveSdks(project, 7000);
    }

    public void updateActiveSdks(@NotNull Project project, int delay) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/sdk/PythonSdkUpdater", "updateActiveSdks"));
        }
        HashSet<Sdk> sdksToUpdate = new HashSet<Sdk>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            SdkTypeId sdkType;
            Sdk sdk = PythonSdkType.findPythonSdk(module);
            if (sdk == null || !((sdkType = sdk.getSdkType()) instanceof PythonSdkType) || this.myAlreadyUpdated.contains(sdk.getHomePath())) continue;
            sdksToUpdate.add(sdk);
        }
        if (!sdksToUpdate.isEmpty()) {
            this.updateSdks(project, delay, sdksToUpdate);
        }
    }

    private void updateSdks(final Project project, final int delay, final Set<Sdk> sdksToUpdate) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (delay > 0) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PyBundle.message("sdk.gen.updating.skels", new Object[0]), false){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/sdk/PythonSdkUpdater$1$1$1", "run"));
                                }
                                for (final Sdk sdk : sdksToUpdate) {
                                    block5: {
                                        try {
                                            LOG.info("Performing background update of skeletons for SDK " + sdk.getHomePath());
                                            PythonSdkUpdater.updateSdk(project, null, sdk, PythonSdkType.findSkeletonsPath(sdk));
                                        }
                                        catch (InvalidSdkException e) {
                                            if (PythonSdkType.isVagrant(sdk)) {
                                                PythonSdkType.notifyRemoteSdkSkeletonsFail(e, new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        PythonSdkUpdater.this.updateSdks(project, delay, Sets.newHashSet((Object[])new Sdk[]{sdk}));
                                                    }
                                                });
                                            }
                                            if (PythonSdkType.isInvalid(sdk)) break block5;
                                            LOG.error((Throwable)e);
                                        }
                                    }
                                    PythonSdkUpdater.this.myAlreadyUpdated.add(sdk.getHomePath());
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public static void updateSdk(@Nullable Project project, @Nullable Component ownerComponent, final @NotNull Sdk sdk, String skeletonsPath) throws InvalidSdkException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkUpdater", "updateSdk"));
        }
        PySkeletonRefresher.refreshSkeletonsOfSdk(project, ownerComponent, skeletonsPath, sdk);
        if (!PySdkUtil.isRemote(sdk)) {
            PythonSdkUpdater.updateSysPath(sdk);
        } else {
            PyRemoteSdkAdditionalDataBase remoteSdkData = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            assert (remoteSdkData != null);
            final ArrayList paths = Lists.newArrayList();
            for (PathMappingSettings.PathMapping mapping : remoteSdkData.getPathMappings().getPathMappings()) {
                paths.add(mapping.getLocalRoot());
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    PythonSdkUpdater.updateSdkPath(sdk, paths);
                }
            });
        }
    }

    private static void updateSysPath(final @NotNull Sdk sdk) throws InvalidSdkException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkUpdater", "updateSysPath"));
        }
        long start_time = System.currentTimeMillis();
        final List<String> sysPath = PythonSdkType.getSysPath(sdk.getHomePath());
        VirtualFile file = PyUserSkeletonsUtil.getUserSkeletonsDirectory();
        if (file != null) {
            sysPath.add(file.getPath());
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                PythonSdkUpdater.updateSdkPath(sdk, sysPath);
            }
        });
        LOG.info("Updating sys.path took " + (System.currentTimeMillis() - start_time) + " ms");
    }

    private static void updateSdkPath(@NotNull Sdk sdk, @NotNull List<String> sysPath) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkUpdater", "updateSdkPath"));
        }
        if (sysPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sysPath", "com/jetbrains/python/sdk/PythonSdkUpdater", "updateSdkPath"));
        }
        final SdkModificator modificator = sdk.getSdkModificator();
        boolean changed = PythonSdkUpdater.addNewSysPathEntries(sdk, modificator, sysPath);
        changed = PythonSdkUpdater.removeSourceRoots(sdk, modificator) || changed;
        boolean bl = changed = PythonSdkUpdater.removeDuplicateClassRoots(sdk, modificator) || changed;
        if (changed) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    modificator.commitChanges();
                }
            });
        }
    }

    private static boolean addNewSysPathEntries(@NotNull Sdk sdk, @NotNull SdkModificator modificator, @NotNull List<String> sysPath) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkUpdater", "addNewSysPathEntries"));
        }
        if (modificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modificator", "com/jetbrains/python/sdk/PythonSdkUpdater", "addNewSysPathEntries"));
        }
        if (sysPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sysPath", "com/jetbrains/python/sdk/PythonSdkUpdater", "addNewSysPathEntries"));
        }
        List<VirtualFile> oldRoots = Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        PythonSdkAdditionalData additionalData = sdk.getSdkAdditionalData() instanceof PythonSdkAdditionalData ? (PythonSdkAdditionalData)sdk.getSdkAdditionalData() : null;
        ArrayList<String> newRoots = new ArrayList<String>();
        for (String root : sysPath) {
            if (!new File(root).exists() || FileUtilRt.extensionEquals((String)root, (String)"egg-info") || additionalData != null && PythonSdkUpdater.wasOldRoot(root, additionalData.getExcludedPathFiles()) || PythonSdkUpdater.wasOldRoot(root, oldRoots)) continue;
            newRoots.add(root);
        }
        if (!newRoots.isEmpty()) {
            for (String root : newRoots) {
                PythonSdkType.addSdkRoot(modificator, root);
            }
            return true;
        }
        return false;
    }

    private static boolean removeDuplicateClassRoots(@NotNull Sdk sdk, @NotNull SdkModificator modificator) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkUpdater", "removeDuplicateClassRoots"));
        }
        if (modificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modificator", "com/jetbrains/python/sdk/PythonSdkUpdater", "removeDuplicateClassRoots"));
        }
        List<VirtualFile> sourceRoots = Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        LinkedHashSet<VirtualFile> uniqueRoots = new LinkedHashSet<VirtualFile>(sourceRoots);
        if (uniqueRoots.size() != sourceRoots.size()) {
            modificator.removeRoots(OrderRootType.CLASSES);
            for (VirtualFile root : uniqueRoots) {
                modificator.addRoot(root, OrderRootType.CLASSES);
            }
            return true;
        }
        return false;
    }

    private static boolean removeSourceRoots(@NotNull Sdk sdk, @NotNull SdkModificator modificator) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkUpdater", "removeSourceRoots"));
        }
        if (modificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modificator", "com/jetbrains/python/sdk/PythonSdkUpdater", "removeSourceRoots"));
        }
        VirtualFile[] sourceRoots = sdk.getRootProvider().getFiles(OrderRootType.SOURCES);
        if (sourceRoots.length > 0) {
            modificator.removeRoots(OrderRootType.SOURCES);
            return true;
        }
        return false;
    }

    private static boolean wasOldRoot(@NotNull String root, @NotNull Collection<VirtualFile> oldRoots) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/python/sdk/PythonSdkUpdater", "wasOldRoot"));
        }
        if (oldRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoots", "com/jetbrains/python/sdk/PythonSdkUpdater", "wasOldRoot"));
        }
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
        if (file != null) {
            VirtualFile rootFile = PythonSdkType.getSdkRootVirtualFile(file);
            return oldRoots.contains(rootFile);
        }
        return false;
    }
}

