/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkType
extends SdkType {
    public static final String REMOTE_SOURCES_DIR_NAME = "remote_sources";
    private static final Logger LOG = Logger.getInstance((String)("#" + PythonSdkType.class.getName()));
    private static final String[] WINDOWS_EXECUTABLE_SUFFIXES = new String[]{"cmd", "exe", "bat", "com"};
    static final int MINUTE = 60000;
    @NonNls
    public static final String SKELETONS_TOPIC = "Skeletons";
    private static final String[] DIRS_WITH_BINARY = new String[]{"", "bin", "Scripts"};
    private static final String[] UNIX_BINARY_NAMES = new String[]{"jython", "pypy", "python"};
    private static final String[] WIN_BINARY_NAMES = new String[]{"jython.bat", "ipy.exe", "pypy.exe", "python.exe"};
    private static final Key<WeakReference<Component>> SDK_CREATOR_COMPONENT_KEY = Key.create((String)"#com.jetbrains.python.sdk.creatorComponent");
    public static final String SKELETON_DIR_NAME = "python_stubs";
    public static final OrderRootType BUILTIN_ROOT_TYPE = OrderRootType.CLASSES;
    private static final Pattern PYTHON_NN_RE = Pattern.compile("python\\d\\.\\d.*");

    public static PythonSdkType getInstance() {
        return (PythonSdkType)SdkType.findInstance(PythonSdkType.class);
    }

    public PythonSdkType() {
        super("Python SDK");
    }

    protected PythonSdkType(@NonNls String name) {
        super(name);
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.python" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonSdkType", "getHelpTopic"));
        }
        return "reference.project.structure.sdk.python";
    }

    public Icon getIconForAddAction() {
        return PythonFileType.INSTANCE.getIcon();
    }

    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkType", "getBuiltinsFileName"));
        }
        LanguageLevel level = PythonSdkType.getLanguageLevelForSdk(sdk);
        String string = level.isOlderThan(LanguageLevel.PYTHON30) ? "__builtin__.py" : "builtins.py";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonSdkType", "getBuiltinsFileName"));
        }
        return string;
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        String pythonFromPath = PythonSdkType.findPythonInPath();
        if (pythonFromPath != null) {
            return pythonFromPath;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getApplicableFlavors()) {
            TreeSet<String> candidates = PythonSdkType.createVersionSet();
            candidates.addAll(flavor.suggestHomePaths());
            if (candidates.isEmpty()) continue;
            String[] candidateArray = ArrayUtil.toStringArray(candidates);
            return candidateArray[candidateArray.length - 1];
        }
        return null;
    }

    @Nullable
    private static String findPythonInPath() {
        String defaultCommand = SystemInfo.isWindows ? "python.exe" : "python";
        String path = System.getenv("PATH");
        for (String root : path.split(File.pathSeparator)) {
            File file = new File(root, defaultCommand);
            if (!file.exists()) continue;
            try {
                return file.getCanonicalPath();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public Collection<String> suggestHomePaths() {
        ArrayList<String> candidates = new ArrayList<String>();
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getApplicableFlavors()) {
            candidates.addAll(flavor.suggestHomePaths());
        }
        return candidates;
    }

    private static TreeSet<String> createVersionSet() {
        return new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return PythonSdkType.findDigits(o1).compareTo(PythonSdkType.findDigits(o2));
            }
        });
    }

    private static String findDigits(String s) {
        int pos = StringUtil.findFirst((CharSequence)s, (CharFilter)new CharFilter(){

            public boolean accept(char ch) {
                return Character.isDigit(ch);
            }
        });
        if (pos >= 0) {
            return s.substring(pos);
        }
        return s;
    }

    public static boolean hasValidSdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!(sdk.getSdkType() instanceof PythonSdkType)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidSdkHome(@Nullable String path) {
        return PythonSdkFlavor.getFlavor(path) != null;
    }

    public static boolean isInvalid(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkType", "isInvalid"));
        }
        if (PythonSdkType.isRemote(sdk)) {
            return false;
        }
        VirtualFile interpreter = sdk.getHomeDirectory();
        return interpreter == null || !interpreter.exists();
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return PySdkUtil.isRemote(sdk);
    }

    public static boolean isVagrant(@Nullable Sdk sdk) {
        if (sdk != null && sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            return data.getRemoteConnectionType() == CredentialsType.VAGRANT;
        }
        return false;
    }

    public static boolean isRemote(@Nullable String sdkPath) {
        return PythonSdkType.isRemote(PythonSdkType.findSdkByPath(sdkPath));
    }

    public FileChooserDescriptor getHomeChooserDescriptor() {
        final boolean is_windows = SystemInfo.isWindows;
        return new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                if (files.length != 0 && !PythonSdkType.this.isValidSdkHome(files[0].getPath())) {
                    throw new Exception(PyBundle.message("sdk.error.invalid.interpreter.name.$0", files[0].getName()));
                }
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && is_windows) {
                    String path = file.getPath();
                    boolean looks_executable = false;
                    for (String ext : WINDOWS_EXECUTABLE_SUFFIXES) {
                        if (!path.endsWith(ext)) continue;
                        looks_executable = true;
                        break;
                    }
                    return looks_executable && super.isFileVisible(file, showHiddenFiles);
                }
                return super.isFileVisible(file, showHiddenFiles);
            }
        }.withTitle(PyBundle.message("sdk.select.path", new Object[0])).withShowHiddenFiles(SystemInfo.isUnix);
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(SdkModel sdkModel, final JComponent parentComponent, final Consumer<Sdk> sdkCreatedCallback) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point point = pointerInfo.getLocation();
        PythonSdkDetailsStep.show(project, sdkModel.getSdks(), null, parentComponent, point, new NullableConsumer<Sdk>(){

            public void consume(@Nullable Sdk sdk) {
                if (sdk != null) {
                    sdk.putUserData(SDK_CREATOR_COMPONENT_KEY, new WeakReference<JComponent>(parentComponent));
                    sdkCreatedCallback.consume((Object)sdk);
                }
            }
        });
    }

    public static boolean isVirtualEnv(Sdk sdk) {
        String path = sdk.getHomePath();
        return path != null && PythonSdkType.getVirtualEnvRoot(path) != null;
    }

    @Nullable
    public Sdk getVirtualEnvBaseSdk(Sdk sdk) {
        if (PythonSdkType.isVirtualEnv(sdk)) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
            String version = this.getVersionString(sdk);
            if (flavor != null && version != null) {
                for (Sdk baseSdk : PythonSdkType.getAllSdks()) {
                    PythonSdkFlavor baseFlavor = PythonSdkFlavor.getFlavor(baseSdk);
                    if (PythonSdkType.isVirtualEnv(baseSdk) || !flavor.equals(baseFlavor) || !version.equals(this.getVersionString(baseSdk))) continue;
                    return baseSdk;
                }
            }
        }
        return null;
    }

    @Nullable
    public static File getVirtualEnvRoot(@NotNull String binaryPath) {
        String rootPath;
        if (binaryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPath", "com/jetbrains/python/sdk/PythonSdkType", "getVirtualEnvRoot"));
        }
        File bin = new File(binaryPath).getParentFile();
        if (bin != null && (rootPath = bin.getParent()) != null) {
            File activate;
            File root = new File(rootPath);
            File activateThis = new File(bin, "activate_this.py");
            if (activateThis.exists() && (activate = PythonSdkType.findExecutableFile(bin, "activate")) != null) {
                return root;
            }
            String pyVenvCfg = "pyvenv.cfg";
            if (new File(root, "pyvenv.cfg").exists() || new File(bin, "pyvenv.cfg").exists()) {
                return root;
            }
        }
        return null;
    }

    @Nullable
    public static File findExecutableFile(File parent, String name) {
        File file;
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            for (String suffix : WINDOWS_EXECUTABLE_SUFFIXES) {
                File file2 = new File(parent, name + "." + suffix);
                if (!file2.exists()) continue;
                return file2;
            }
        } else if (SystemInfo.isUnix && (file = new File(parent, name)).exists()) {
            return file;
        }
        return null;
    }

    public static void patchCommandLineForVirtualenv(GeneralCommandLine commandLine, String sdkHome, boolean passParentEnvironment) {
        File virtualEnvRoot = PythonSdkType.getVirtualEnvRoot(sdkHome);
        if (virtualEnvRoot != null) {
            String PATH = "PATH";
            File bin = new File(virtualEnvRoot, "bin");
            if (!bin.exists()) {
                bin = new File(virtualEnvRoot, "Scripts");
            }
            String virtualenvBin = bin.getPath();
            Map env = commandLine.getEnvironment();
            String pathValue = env.containsKey("PATH") ? PythonEnvUtil.appendToPathEnvVar((String)env.get("PATH"), virtualenvBin) : (passParentEnvironment ? PythonEnvUtil.appendToPathEnvVar(System.getenv("PATH"), virtualenvBin) : virtualenvBin);
            env.put("PATH", pathValue);
        }
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String name = this.getVersionString(sdkHome);
        return PythonSdkType.suggestSdkNameFromVersion(sdkHome, name);
    }

    public static String suggestSdkNameFromVersion(String sdkHome, String version) {
        File virtualEnvRoot;
        sdkHome = FileUtil.toSystemDependentName((String)sdkHome);
        String shortHomeName = FileUtil.getLocationRelativeToUserHome((String)sdkHome);
        version = version != null ? ((virtualEnvRoot = PythonSdkType.getVirtualEnvRoot(sdkHome)) != null ? version + " virtualenv at " + FileUtil.getLocationRelativeToUserHome((String)virtualEnvRoot.getAbsolutePath()) : version + " (" + shortHomeName + ")") : "Unknown at " + shortHomeName;
        return version;
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "com/jetbrains/python/sdk/PythonSdkType", "saveAdditionalData"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "com/jetbrains/python/sdk/PythonSdkType", "saveAdditionalData"));
        }
        if (additionalData instanceof PythonSdkAdditionalData) {
            ((PythonSdkAdditionalData)additionalData).save(additional);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, Element additional) {
        PythonRemoteInterpreterManager manager;
        if (currentSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSdk", "com/jetbrains/python/sdk/PythonSdkType", "loadAdditionalData"));
        }
        if (RemoteSdkCredentialsHolder.isRemoteSdk(currentSdk.getHomePath()) && (manager = PythonRemoteInterpreterManager.getInstance()) != null) {
            return manager.loadRemoteSdkData(currentSdk, additional);
        }
        return PythonSdkAdditionalData.load(currentSdk, additional);
    }

    @Nullable
    public static String findSkeletonsPath(Sdk sdk) {
        String[] urls;
        for (String url : urls = sdk.getRootProvider().getUrls(BUILTIN_ROOT_TYPE)) {
            if (!PythonSdkType.isSkeletonsPath(url)) continue;
            return VfsUtilCore.urlToPath((String)url);
        }
        return null;
    }

    public static boolean isSkeletonsPath(String path) {
        return path.contains(SKELETON_DIR_NAME);
    }

    @NonNls
    public String getPresentableName() {
        return "Python SDK";
    }

    public String sdkPath(VirtualFile homePath) {
        VirtualFile sdkPath;
        String path = super.sdkPath(homePath);
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(path);
        if (flavor != null && (sdkPath = flavor.getSdkPath(homePath)) != null) {
            return FileUtil.toSystemDependentName((String)sdkPath.getPath());
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkType", "setupSdkPaths"));
        }
        WeakReference ownerComponentRef = (WeakReference)sdk.getUserData(SDK_CREATOR_COMPONENT_KEY);
        Component ownerComponent = (Component)SoftReference.dereference((Reference)ownerComponentRef);
        Project project = ownerComponent != null ? (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(ownerComponent)) : (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        PythonSdkType.setupSdkPaths(sdk, project, ownerComponent);
    }

    public boolean setupSdkPaths(Sdk sdk, SdkModel sdkModel) {
        return true;
    }

    public static void setupSdkPaths(Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) {
        SdkModificator sdkModificator = sdk.getSdkModificator();
        boolean success = PythonSdkType.setupSdkPaths(project, ownerComponent, sdk, sdkModificator);
        if (success) {
            sdkModificator.commitChanges();
        } else {
            Messages.showErrorDialog((Project)project, (String)PyBundle.message("MSG.cant.setup.sdk.$0", FileUtil.toSystemDependentName((String)sdk.getSdkModificator().getHomePath())), (String)PyBundle.message("MSG.title.bad.sdk", new Object[0]));
        }
    }

    public static boolean setupSdkPaths(final @Nullable Project project, final @Nullable Component ownerComponent, final @NotNull Sdk sdk, final @NotNull SdkModificator sdkModificator) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkType", "setupSdkPaths"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/jetbrains/python/sdk/PythonSdkType", "setupSdkPaths"));
        }
        if (PythonSdkType.isRemote(sdk) && project == null && ownerComponent == null) {
            LOG.error("For refreshing skeletons of remote SDK, either project or owner component must be specified");
        }
        final ProgressManager progressManager = ProgressManager.getInstance();
        final Ref sdkPathsUpdatedRef = new Ref((Object)false);
        Task.Modal setupTask = new Task.Modal(project, "Setting up library files for " + sdk.getName(), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/sdk/PythonSdkType$5", "run"));
                }
                sdkModificator.removeAllRoots();
                try {
                    PythonSdkType.updateSdkRootsFromSysPath(sdk, sdkModificator, indicator);
                    PythonSdkType.updateUserAddedPaths(sdk, sdkModificator, indicator);
                    PythonSdkUpdater.getInstance().markAlreadyUpdated(sdk.getHomePath());
                    sdkPathsUpdatedRef.set((Object)true);
                }
                catch (InvalidSdkException invalidSdkException) {
                    // empty catch block
                }
            }
        };
        progressManager.run((Task)setupTask);
        Boolean sdkPathsUpdated = (Boolean)sdkPathsUpdatedRef.get();
        Application application = ApplicationManager.getApplication();
        if (sdkPathsUpdated.booleanValue() && !application.isUnitTestMode()) {
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressManager.run((Task)new Task.Backgroundable(project, PyBundle.message("sdk.gen.updating.skels", new Object[0]), false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            block4: {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/sdk/PythonSdkType$6$1", "run"));
                                }
                                try {
                                    String skeletonsPath = PythonSdkType.getSkeletonsPath(PathManager.getSystemPath(), sdk.getHomePath());
                                    PythonSdkUpdater.updateSdk(project, ownerComponent, sdk, skeletonsPath);
                                }
                                catch (InvalidSdkException e) {
                                    if (PythonSdkType.isVagrant(sdk)) {
                                        PythonSdkType.notifyRemoteSdkSkeletonsFail(e, new Runnable(){

                                            @Override
                                            public void run() {
                                                PythonSdkType.setupSdkPaths(project, ownerComponent, sdk, sdkModificator);
                                            }
                                        });
                                    }
                                    if (PythonSdkType.isInvalid(sdk)) break block4;
                                    LOG.error((Throwable)e);
                                }
                            }
                        }
                    });
                }
            });
        }
        return sdkPathsUpdated;
    }

    public static void notifyRemoteSdkSkeletonsFail(final InvalidSdkException e, final @Nullable Runnable restartAction) {
        NotificationListener notificationListener = e.getCause() instanceof VagrantNotStartedException ? new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/python/sdk/PythonSdkType$7", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/sdk/PythonSdkType$7", "hyperlinkUpdate"));
                }
                PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
                if (manager != null) {
                    try {
                        manager.runVagrant(((VagrantNotStartedException)e.getCause()).getVagrantFolder());
                    }
                    catch (ExecutionException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (restartAction != null) {
                    restartAction.run();
                }
            }
        } : null;
        Notifications.Bus.notify((Notification)new Notification(SKELETONS_TOPIC, "Couldn't refresh skeletons for remote interpreter", e.getMessage() + "\n<a href=\"#\">Launch vagrant and refresh skeletons</a>", NotificationType.WARNING, notificationListener));
    }

    public static void updateSdkRootsFromSysPath(Sdk sdk, SdkModificator sdkModificator, ProgressIndicator indicator) throws InvalidSdkException {
        List<String> paths;
        Application application = ApplicationManager.getApplication();
        boolean not_in_unit_test_mode = application != null && !application.isUnitTestMode();
        String sdkHome = sdkModificator.getHomePath();
        assert (sdkHome != null);
        String sep = File.separator;
        if (indicator != null) {
            indicator.setText("Adding library roots");
        }
        if (!PySdkUtil.isRemote(sdk) && (paths = PythonSdkType.getSysPath(sdkHome)).size() > 0) {
            for (String path : paths) {
                if (!path.contains(sep)) continue;
                if (indicator != null) {
                    indicator.setText2(path);
                }
                PythonSdkType.addSdkRoot(sdkModificator, path);
            }
        }
        PyUserSkeletonsUtil.addUserSkeletonsRoot(sdkModificator);
        PythonSdkType.addSkeletonsRoot(sdkModificator, sdkHome);
        if (not_in_unit_test_mode) {
            File lib_root;
            File venv_root = PythonSdkType.getVirtualEnvRoot(sdkHome);
            if (venv_root != null && venv_root.isDirectory() && (lib_root = new File(venv_root, "lib")).isDirectory()) {
                String[] inside;
                for (String s : inside = lib_root.list()) {
                    File py_lib_root;
                    String[] flag_files;
                    if (!PYTHON_NN_RE.matcher(s).matches() || (flag_files = (py_lib_root = new File(lib_root, s)).list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String s) {
                            return "no-global-site-packages.txt".equals(s);
                        }
                    })) == null) continue;
                    return;
                }
            }
            PythonSdkType.addHardcodedPaths(sdkModificator);
        }
    }

    public static void updateUserAddedPaths(Sdk sdk, SdkModificator sdkModificator, ProgressIndicator indicator) throws InvalidSdkException {
        SdkAdditionalData data;
        if (indicator != null) {
            indicator.setText("Adding user-added roots");
        }
        if ((data = sdk.getSdkAdditionalData()) instanceof PythonSdkAdditionalData) {
            for (VirtualFile file : ((PythonSdkAdditionalData)data).getAddedPathFiles()) {
                PythonSdkType.addSdkRoot(sdkModificator, file);
            }
        }
    }

    private static void addSkeletonsRoot(@NotNull SdkModificator sdkModificator, String sdkHome) {
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/jetbrains/python/sdk/PythonSdkType", "addSkeletonsRoot"));
        }
        String skeletonsPath = PythonSdkType.getSkeletonsPath(PathManager.getSystemPath(), sdkHome);
        new File(skeletonsPath).mkdirs();
        VirtualFile builtins_root = LocalFileSystem.getInstance().refreshAndFindFileByPath(skeletonsPath);
        assert (builtins_root != null) : "Cannot find skeletons path " + skeletonsPath + " in VFS";
        sdkModificator.addRoot(builtins_root, BUILTIN_ROOT_TYPE);
    }

    protected static void addHardcodedPaths(SdkModificator sdkModificator) {
        VirtualFile file;
        if (SystemInfo.isLinux && (file = LocalFileSystem.getInstance().findFileByPath("/usr/lib/python-django")) != null) {
            sdkModificator.addRoot(file, OrderRootType.CLASSES);
        }
    }

    public static void addSdkRoot(SdkModificator sdkModificator, String path) {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (file != null) {
            PythonSdkType.addSdkRoot(sdkModificator, file);
        } else {
            LOG.info("Bogus sys.path entry " + path);
        }
    }

    private static void addSdkRoot(@NotNull SdkModificator sdkModificator, @NotNull VirtualFile child) {
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/jetbrains/python/sdk/PythonSdkType", "addSdkRoot"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/python/sdk/PythonSdkType", "addSdkRoot"));
        }
        sdkModificator.addRoot(PythonSdkType.getSdkRootVirtualFile(child), OrderRootType.CLASSES);
    }

    @NotNull
    public static VirtualFile getSdkRootVirtualFile(@NotNull VirtualFile path) {
        VirtualFile jar;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/python/sdk/PythonSdkType", "getSdkRootVirtualFile"));
        }
        String suffix = path.getExtension();
        if (suffix != null) {
            suffix = suffix.toLowerCase();
        }
        if (!path.isDirectory() && ("zip".equals(suffix) || "egg".equals(suffix)) && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(path)) != null) {
            VirtualFile virtualFile = jar;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonSdkType", "getSdkRootVirtualFile"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = path;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonSdkType", "getSdkRootVirtualFile"));
        }
        return virtualFile;
    }

    public static String getSkeletonsPath(String basePath, String sdkHome) {
        String sep = File.separator;
        return PythonSdkType.getSkeletonsRootPath(basePath) + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + sep;
    }

    public static String getSkeletonsRootPath(String basePath) {
        return basePath + File.separator + SKELETON_DIR_NAME;
    }

    @NotNull
    public static List<String> getSysPath(String bin_path) throws InvalidSdkException {
        String working_dir = new File(bin_path).getParent();
        Application application = ApplicationManager.getApplication();
        if (application != null && !application.isUnitTestMode()) {
            List<String> list = PythonSdkType.getSysPathsFromScript(bin_path);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonSdkType", "getSysPath"));
            }
            return list;
        }
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add(working_dir);
        ArrayList<String> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonSdkType", "getSysPath"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getSysPathsFromScript(@NotNull String binaryPath) throws InvalidSdkException {
        if (binaryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPath", "com/jetbrains/python/sdk/PythonSdkType", "getSysPathsFromScript"));
        }
        String scriptFile = PythonHelpersLocator.getHelperPath("syspath.py");
        ProcessOutput run_result = PySdkUtil.getProcessOutput(new File(scriptFile).getParent(), new String[]{binaryPath, scriptFile}, PythonSdkType.getVirtualEnvExtraEnv(binaryPath), 60000);
        if (!run_result.checkSuccess(LOG)) {
            throw new InvalidSdkException(String.format("Failed to determine Python's sys.path value:\nSTDOUT: %s\nSTDERR: %s", run_result.getStdout(), run_result.getStderr()));
        }
        List list = run_result.getStdoutLines();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonSdkType", "getSysPathsFromScript"));
        }
        return list;
    }

    @Nullable
    public static Map<String, String> getVirtualEnvExtraEnv(@NotNull String binaryPath) {
        if (binaryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPath", "com/jetbrains/python/sdk/PythonSdkType", "getVirtualEnvExtraEnv"));
        }
        File root = PythonSdkType.getVirtualEnvRoot(binaryPath);
        if (root != null) {
            return ImmutableMap.of((Object)"PATH", (Object)root.toString());
        }
        return null;
    }

    @Nullable
    public String getVersionString(String sdkHome) {
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdkHome);
        return flavor != null ? flavor.getVersionString(sdkHome) : null;
    }

    public static List<Sdk> getAllSdks() {
        return ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)PythonSdkType.getInstance());
    }

    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module) {
        Facet[] facets;
        if (module == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType) {
            return sdk;
        }
        for (Facet facet : facets = FacetManager.getInstance((Module)module).getAllFacets()) {
            FacetConfiguration configuration = facet.getConfiguration();
            if (!(configuration instanceof PythonFacetSettings)) continue;
            return ((PythonFacetSettings)configuration).getSdk();
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkByPath(@Nullable String path) {
        if (path != null) {
            return PythonSdkType.findSdkByPath(PythonSdkType.getAllSdks(), path);
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkByPath(List<Sdk> sdkList, @Nullable String path) {
        if (path != null) {
            for (Sdk sdk : sdkList) {
                if (sdk == null || !FileUtil.pathsEqual((String)path, (String)sdk.getHomePath())) continue;
                return sdk;
            }
        }
        return null;
    }

    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk) {
        PythonSdkFlavor flavor;
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null) {
            return flavor.getLanguageLevel(sdk);
        }
        return LanguageLevel.getDefault();
    }

    public boolean isRootTypeApplicable(OrderRootType type) {
        return type == OrderRootType.CLASSES;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PythonSdkType", "sdkHasValidPath"));
        }
        if (PySdkUtil.isRemote(sdk)) {
            return true;
        }
        VirtualFile homeDir = sdk.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    public static boolean isStdLib(VirtualFile vFile, Sdk pythonSdk) {
        if (pythonSdk != null) {
            VirtualFile libDir = PyProjectScopeBuilder.findLibDir(pythonSdk);
            if (libDir != null && VfsUtilCore.isAncestor((VirtualFile)libDir, (VirtualFile)vFile, (boolean)false)) {
                return PythonSdkType.isNotSitePackages(vFile, libDir);
            }
            VirtualFile venvLibDir = PyProjectScopeBuilder.findVirtualEnvLibDir(pythonSdk);
            if (venvLibDir != null && VfsUtilCore.isAncestor((VirtualFile)venvLibDir, (VirtualFile)vFile, (boolean)false)) {
                return PythonSdkType.isNotSitePackages(vFile, venvLibDir);
            }
            VirtualFile skeletonsDir = PySdkUtil.findSkeletonsDir(pythonSdk);
            if (skeletonsDir != null && Comparing.equal((Object)vFile.getParent(), (Object)skeletonsDir)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNotSitePackages(VirtualFile vFile, VirtualFile libDir) {
        VirtualFile sitePackages = libDir.findChild("site-packages");
        return sitePackages == null || !VfsUtilCore.isAncestor((VirtualFile)sitePackages, (VirtualFile)vFile, (boolean)false);
    }

    @Nullable
    public static Sdk findPython2Sdk(@Nullable Module module) {
        Sdk moduleSDK = PythonSdkType.findPythonSdk(module);
        if (moduleSDK != null && !PythonSdkType.getLanguageLevelForSdk(moduleSDK).isPy3K()) {
            return moduleSDK;
        }
        List<Sdk> allSdks = PythonSdkType.getAllSdks();
        Collections.sort(allSdks, PreferredSdkComparator.INSTANCE);
        for (Sdk sdk : allSdks) {
            if (PythonSdkType.getLanguageLevelForSdk(sdk).isPy3K()) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk findPython2Sdk(List<Sdk> sdks) {
        Collections.sort(sdks, PreferredSdkComparator.INSTANCE);
        for (Sdk sdk : sdks) {
            if (PythonSdkType.getLanguageLevelForSdk(sdk).isPy3K()) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk findLocalCPython(@Nullable Module module) {
        Sdk moduleSDK = PythonSdkType.findPythonSdk(module);
        if (moduleSDK != null && !PythonSdkType.isRemote(moduleSDK) && PythonSdkFlavor.getFlavor(moduleSDK) instanceof CPythonSdkFlavor) {
            return moduleSDK;
        }
        List<Sdk> allSdks = PythonSdkType.getAllSdks();
        Collections.sort(allSdks, PreferredSdkComparator.INSTANCE);
        for (Sdk sdk : allSdks) {
            if (PythonSdkType.isRemote(sdk)) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/jetbrains/python/sdk/PythonSdkType", "getPythonExecutable"));
        }
        File rootFile = new File(rootPath);
        if (rootFile.isFile()) {
            return rootFile.getAbsolutePath();
        }
        for (String dir : DIRS_WITH_BINARY) {
            File subDir = StringUtil.isEmpty((String)dir) ? rootFile : new File(rootFile, dir);
            if (!subDir.isDirectory()) continue;
            for (String binaryName : PythonSdkType.getBinaryNames()) {
                File executable = new File(subDir, binaryName);
                if (!executable.isFile()) continue;
                return executable.getAbsolutePath();
            }
        }
        return null;
    }

    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name) {
        String resolvedPath;
        if (homeDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homeDirectory", "com/jetbrains/python/sdk/PythonSdkType", "getExecutablePath"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/sdk/PythonSdkType", "getExecutablePath"));
        }
        File binPath = new File(homeDirectory);
        File binDir = binPath.getParentFile();
        if (binDir == null) {
            return null;
        }
        File runner = new File(binDir, name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir, "Scripts"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir.getParentFile(), "Scripts"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir.getParentFile(), "local"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(new File(binDir.getParentFile(), "local"), "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        if (FileSystemUtil.isSymLink((String)homeDirectory) && (resolvedPath = FileSystemUtil.resolveSymLink((String)homeDirectory)) != null) {
            return PythonSdkType.getExecutablePath(resolvedPath, name);
        }
        runner = new File(new File("/usr", "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(new File("/usr", "local"), "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        return null;
    }

    private static String[] getBinaryNames() {
        if (SystemInfo.isUnix) {
            return UNIX_BINARY_NAMES;
        }
        return WIN_BINARY_NAMES;
    }

    public static boolean isIncompleteRemote(Sdk sdk) {
        return PySdkUtil.isRemote(sdk) && !((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).isValid();
    }

    @Nullable
    public static Sdk getSdk(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/sdk/PythonSdkType", "getSdk"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        return ModuleRootManager.getInstance((Module)module).getSdk();
    }
}

