/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ui.EmptyIcon;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.CreateVirtualEnvDialog;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkService;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkDetailsStep
extends BaseListPopupStep<String> {
    @Nullable
    private DialogWrapper myMore;
    private final Project myProject;
    private final Component myOwnerComponent;
    private final Sdk[] myExistingSdks;
    private final NullableConsumer<Sdk> myCallback;
    private static final String LOCAL = "Add Local";
    private static final String REMOTE = "Add Remote";
    private static final String VIRTUALENV = "Create VirtualEnv";
    private static final String MORE = "More...";
    private boolean myNewProject;

    public static void show(Project project, Sdk[] existingSdks, @Nullable DialogWrapper moreDialog, JComponent ownerComponent, Point popupPoint, NullableConsumer<Sdk> callback) {
        PythonSdkDetailsStep.show(project, existingSdks, moreDialog, ownerComponent, popupPoint, callback, false);
    }

    public static void show(Project project, Sdk[] existingSdks, @Nullable DialogWrapper moreDialog, JComponent ownerComponent, Point popupPoint, NullableConsumer<Sdk> callback, boolean isNewProject) {
        PythonSdkDetailsStep sdkHomesStep = new PythonSdkDetailsStep(project, moreDialog, ownerComponent, existingSdks, callback);
        sdkHomesStep.setNewProject(isNewProject);
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
        Dimension size = new JLabel(VIRTUALENV, EmptyIcon.ICON_16, 2).getMinimumSize();
        int componentNum = PythonSdkDetailsStep.getAvailableOptions(moreDialog != null).size() + 1;
        int height = size.height * componentNum + 2 * componentNum;
        popup.setSize(new Dimension(size.width, height));
        popup.setMinimumSize(new Dimension(size.width, height));
        popup.showInScreenCoordinates((Component)ownerComponent, popupPoint);
    }

    private void setNewProject(boolean isNewProject) {
        this.myNewProject = isNewProject;
    }

    public PythonSdkDetailsStep(@Nullable Project project, @Nullable DialogWrapper moreDialog, @NotNull Component ownerComponent, @NotNull Sdk[] existingSdks, @NotNull NullableConsumer<Sdk> callback) {
        if (ownerComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerComponent", "com/jetbrains/python/sdk/PythonSdkDetailsStep", "<init>"));
        }
        if (existingSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingSdks", "com/jetbrains/python/sdk/PythonSdkDetailsStep", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/python/sdk/PythonSdkDetailsStep", "<init>"));
        }
        super(null, PythonSdkDetailsStep.getAvailableOptions(moreDialog != null));
        this.myProject = project;
        this.myMore = moreDialog;
        this.myOwnerComponent = ownerComponent;
        this.myExistingSdks = existingSdks;
        this.myCallback = callback;
    }

    private static List<String> getAvailableOptions(boolean showMore) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(LOCAL);
        if (PythonRemoteInterpreterManager.getInstance() != null) {
            options.add(REMOTE);
        }
        options.add(VIRTUALENV);
        if (showMore) {
            options.add(MORE);
        }
        return options;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(String value) {
        return MORE.equals(value) ? new ListSeparator() : null;
    }

    private void optionSelected(String selectedValue) {
        if (!MORE.equals(selectedValue) && this.myMore != null) {
            Disposer.dispose((Disposable)this.myMore.getDisposable());
        }
        if (LOCAL.equals(selectedValue)) {
            this.createLocalSdk();
        } else if (REMOTE.equals(selectedValue)) {
            this.createRemoteSdk();
        } else if (VIRTUALENV.equals(selectedValue)) {
            this.createVirtualEnvSdk();
        } else if (this.myMore != null) {
            this.myMore.show();
        }
    }

    private void createLocalSdk() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                SdkConfigurationUtil.createSdk(PythonSdkDetailsStep.this.myProject, PythonSdkDetailsStep.this.myExistingSdks, (NullableConsumer<Sdk>)PythonSdkDetailsStep.this.myCallback, false, PythonSdkType.getInstance());
            }
        }, ModalityState.any());
    }

    private void createRemoteSdk() {
        PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (remoteInterpreterManager != null) {
            remoteInterpreterManager.addRemoteSdk(this.myProject, this.myOwnerComponent, Lists.newArrayList((Object[])this.myExistingSdks), this.myCallback);
        } else {
            Messages.showErrorDialog((String)("The Remote Hosts Access plugin is missing. Please enable the plugin in " + ShowSettingsUtil.getSettingsMenuName() + " | Plugins."), (String)"Add Remote Interpreter");
        }
    }

    private void createVirtualEnvSdk() {
        CreateVirtualEnvDialog.VirtualEnvCallback callback = new CreateVirtualEnvDialog.VirtualEnvCallback(){

            @Override
            public void virtualEnvCreated(Sdk sdk, boolean associateWithProject) {
                PythonSdkType.setupSdkPaths(sdk, PythonSdkDetailsStep.this.myProject, null);
                if (associateWithProject) {
                    SdkAdditionalData additionalData = sdk.getSdkAdditionalData();
                    if (additionalData == null) {
                        additionalData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(sdk.getHomePath()));
                        ((ProjectJdkImpl)sdk).setSdkAdditionalData(additionalData);
                    }
                    if (PythonSdkDetailsStep.this.myNewProject) {
                        ((PythonSdkAdditionalData)additionalData).associateWithNewProject();
                    } else {
                        ((PythonSdkAdditionalData)additionalData).associateWithProject(PythonSdkDetailsStep.this.myProject);
                    }
                }
                PythonSdkDetailsStep.this.myCallback.consume((Object)sdk);
            }
        };
        ArrayList allSdks = Lists.newArrayList((Object[])this.myExistingSdks);
        Iterables.removeIf((Iterable)allSdks, (Predicate)new Predicate<Sdk>(){

            public boolean apply(Sdk sdk) {
                return !(sdk.getSdkType() instanceof PythonSdkType);
            }
        });
        List<PythonSdkFlavor> flavors = PythonSdkFlavor.getApplicableFlavors(false);
        for (PythonSdkFlavor flavor : flavors) {
            Collection<String> strings = flavor.suggestHomePaths();
            for (String string : SdkConfigurationUtil.filterExistingPaths(PythonSdkType.getInstance(), strings, this.myExistingSdks)) {
                allSdks.add(new PyDetectedSdk(string));
            }
        }
        Set<String> sdks = PySdkService.getInstance().getAddedSdks();
        for (String string : SdkConfigurationUtil.filterExistingPaths(PythonSdkType.getInstance(), sdks, this.myExistingSdks)) {
            allSdks.add(new PyDetectedSdk(string));
        }
        CreateVirtualEnvDialog dialog = this.myProject != null ? new CreateVirtualEnvDialog(this.myProject, (List<Sdk>)allSdks, null) : new CreateVirtualEnvDialog(this.myOwnerComponent, (List<Sdk>)allSdks, null);
        dialog.show();
        if (dialog.isOK()) {
            dialog.createVirtualEnv(allSdks, callback);
        }
    }

    public boolean canBeHidden(String value) {
        return true;
    }

    public void canceled() {
        if (this.getFinalRunnable() == null && this.myMore != null) {
            Disposer.dispose((Disposable)this.myMore.getDisposable());
        }
    }

    public PopupStep onChosen(final String selectedValue, boolean finalChoice) {
        return this.doFinalStep(new Runnable(){

            @Override
            public void run() {
                PythonSdkDetailsStep.this.optionSelected(selectedValue);
            }
        });
    }
}

