/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkAdditionalData
implements SdkAdditionalData {
    @NonNls
    private static final String PATHS_ADDED_BY_USER_ROOT = "PATHS_ADDED_BY_USER_ROOT";
    @NonNls
    private static final String PATH_ADDED_BY_USER = "PATH_ADDED_BY_USER";
    @NonNls
    private static final String PATHS_REMOVED_BY_USER_ROOT = "PATHS_REMOVED_BY_USER_ROOT";
    @NonNls
    private static final String PATH_REMOVED_BY_USER = "PATH_REMOVED_BY_USER";
    @NonNls
    private static final String ASSOCIATED_PROJECT_PATH = "ASSOCIATED_PROJECT_PATH";
    private Set<SimpleProjectRoot> myAddedPaths = Sets.newHashSet();
    private Set<SimpleProjectRoot> myExcludedPaths = Sets.newHashSet();
    private final PythonSdkFlavor myFlavor;
    private String myAssociatedProjectPath;
    private boolean myAssociateWithNewProject;

    public PythonSdkAdditionalData(@Nullable PythonSdkFlavor flavor) {
        this.myFlavor = flavor;
    }

    public Object clone() throws CloneNotSupportedException {
        PythonSdkAdditionalData copy = new PythonSdkAdditionalData(this.myFlavor);
        copy.setAddedPaths(this.getAddedPaths());
        copy.setExcludedPaths(this.getExcludedPaths());
        copy.setAssociatedProjectPath(this.getAssociatedProjectPath());
        return copy;
    }

    public Set<SimpleProjectRoot> getAddedPaths() {
        return this.myAddedPaths;
    }

    public void setAddedPaths(Set<SimpleProjectRoot> addedPaths) {
        this.myAddedPaths = Sets.newHashSet(addedPaths);
    }

    public void setAddedPathsFromVirtualFiles(Set<VirtualFile> addedPaths) {
        this.myAddedPaths = Sets.newHashSet();
        for (VirtualFile file : addedPaths) {
            this.myAddedPaths.add(new SimpleProjectRoot(file));
        }
    }

    public void setExcludedPathsFromVirtualFiles(Set<VirtualFile> addedPaths) {
        this.myExcludedPaths = Sets.newHashSet();
        for (VirtualFile file : addedPaths) {
            this.myExcludedPaths.add(new SimpleProjectRoot(file));
        }
    }

    public Set<SimpleProjectRoot> getExcludedPaths() {
        return this.myExcludedPaths;
    }

    public void setExcludedPaths(Set<SimpleProjectRoot> excludedPaths) {
        this.myExcludedPaths = Sets.newHashSet(excludedPaths);
    }

    public String getAssociatedProjectPath() {
        return this.myAssociatedProjectPath;
    }

    public void setAssociatedProjectPath(@Nullable String associatedProjectPath) {
        this.myAssociatedProjectPath = associatedProjectPath;
    }

    public void associateWithProject(Project project) {
        String path = project.getBasePath();
        if (path != null) {
            this.myAssociatedProjectPath = FileUtil.toSystemIndependentName((String)path);
        }
    }

    public void associateWithNewProject() {
        this.myAssociateWithNewProject = true;
    }

    public void reassociateWithCreatedProject(Project project) {
        if (this.myAssociateWithNewProject) {
            this.associateWithProject(project);
        }
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/jetbrains/python/sdk/PythonSdkAdditionalData", "save"));
        }
        PythonSdkAdditionalData.savePaths(rootElement, this.myAddedPaths, PATHS_ADDED_BY_USER_ROOT, PATH_ADDED_BY_USER);
        PythonSdkAdditionalData.savePaths(rootElement, this.myExcludedPaths, PATHS_REMOVED_BY_USER_ROOT, PATH_REMOVED_BY_USER);
        if (this.myAssociatedProjectPath != null) {
            rootElement.setAttribute(ASSOCIATED_PROJECT_PATH, this.myAssociatedProjectPath);
        }
    }

    private static void savePaths(Element rootElement, Set<SimpleProjectRoot> paths, String root, String element) {
        for (SimpleProjectRoot addedPath : paths) {
            Element child = new Element(root);
            child.setAttribute(element, addedPath.getUrl());
            rootElement.addContent(child);
        }
    }

    @Nullable
    public PythonSdkFlavor getFlavor() {
        return this.myFlavor;
    }

    @NotNull
    public static PythonSdkAdditionalData load(Sdk sdk, @Nullable Element element) {
        PythonSdkAdditionalData data = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(sdk.getHomePath()));
        PythonSdkAdditionalData.load(element, data);
        PythonSdkAdditionalData pythonSdkAdditionalData = data;
        if (pythonSdkAdditionalData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonSdkAdditionalData", "load"));
        }
        return pythonSdkAdditionalData;
    }

    protected static void load(@Nullable Element element, @NotNull PythonSdkAdditionalData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/python/sdk/PythonSdkAdditionalData", "load"));
        }
        data.setAddedPaths(PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_ADDED_BY_USER_ROOT, (String)PATH_ADDED_BY_USER)));
        data.setExcludedPaths(PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_REMOVED_BY_USER_ROOT, (String)PATH_REMOVED_BY_USER)));
        if (element != null) {
            data.setAssociatedProjectPath(element.getAttributeValue(ASSOCIATED_PROJECT_PATH));
        }
    }

    protected static Set<SimpleProjectRoot> collectPaths(@NotNull List<String> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/jetbrains/python/sdk/PythonSdkAdditionalData", "collectPaths"));
        }
        HashSet files = Sets.newHashSet();
        for (String path : paths) {
            if (StringUtil.isEmpty((String)path)) continue;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            SimpleProjectRoot root = file != null ? new SimpleProjectRoot(file) : new SimpleProjectRoot(path);
            files.add(root);
        }
        return files;
    }

    public Set<VirtualFile> getAddedPathFiles() {
        return PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myAddedPaths);
    }

    public Set<VirtualFile> getExcludedPathFiles() {
        return PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myExcludedPaths);
    }

    private static Set<VirtualFile> getPathsAsVirtualFiles(Set<SimpleProjectRoot> paths) {
        HashSet ret = Sets.newHashSet();
        for (SimpleProjectRoot root : paths) {
            ret.addAll(Lists.newArrayList((Object[])root.getVirtualFiles()));
        }
        return ret;
    }
}

