/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonEnvUtil {
    public static final String PYTHONPATH = "PYTHONPATH";
    public static final String PYTHONUNBUFFERED = "PYTHONUNBUFFERED";
    public static final String PYTHONIOENCODING = "PYTHONIOENCODING";
    public static final String IPYTHONENABLE = "IPYTHONENABLE";

    private PythonEnvUtil() {
    }

    public static Map<String, String> setPythonUnbuffered(@NotNull Map<String, String> env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/sdk/PythonEnvUtil", "setPythonUnbuffered"));
        }
        env.put(PYTHONUNBUFFERED, "1");
        return env;
    }

    public static Map<String, String> setPythonIOEncoding(@NotNull Map<String, String> env, @NotNull String encoding) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/sdk/PythonEnvUtil", "setPythonIOEncoding"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/jetbrains/python/sdk/PythonEnvUtil", "setPythonIOEncoding"));
        }
        env.put(PYTHONIOENCODING, encoding);
        return env;
    }

    @NotNull
    public static String appendToPathEnvVar(@Nullable String source, @NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/sdk/PythonEnvUtil", "appendToPathEnvVar"));
        }
        if (StringUtil.isEmpty((String)source)) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonEnvUtil", "appendToPathEnvVar"));
            }
            return string;
        }
        HashSet paths = Sets.newHashSet((Object[])source.split(File.pathSeparator));
        String string = !paths.contains(value) ? source + File.pathSeparator + value : source;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PythonEnvUtil", "appendToPathEnvVar"));
        }
        return string;
    }

    public static void addPathsToEnv(@NotNull Map<String, String> env, String key, @NotNull Collection<String> values) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/sdk/PythonEnvUtil", "addPathsToEnv"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/jetbrains/python/sdk/PythonEnvUtil", "addPathsToEnv"));
        }
        for (String val : values) {
            PythonEnvUtil.addPathToEnv(env, key, val);
        }
    }

    public static void addPathToEnv(@NotNull Map<String, String> env, String key, String value) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/sdk/PythonEnvUtil", "addPathToEnv"));
        }
        if (!StringUtil.isEmpty((String)value)) {
            if (env.containsKey(key)) {
                env.put(key, PythonEnvUtil.appendToPathEnvVar(env.get(key), value));
            } else {
                env.put(key, value);
            }
        }
    }

    public static void addToPythonPath(@NotNull Map<String, String> env, @NotNull Collection<String> values) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/sdk/PythonEnvUtil", "addToPythonPath"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/jetbrains/python/sdk/PythonEnvUtil", "addToPythonPath"));
        }
        PythonEnvUtil.addPathsToEnv(env, PYTHONPATH, values);
    }

    public static void addToPythonPath(@NotNull Map<String, String> env, String value) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/sdk/PythonEnvUtil", "addToPythonPath"));
        }
        PythonEnvUtil.addPathToEnv(env, PYTHONPATH, value);
    }
}

