/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySdkUtil {
    protected static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.sdk.SdkVersionUtil");
    public static final int SUBSTITUTE = 26;
    public static final String PATH_ENV_VARIABLE = "PATH";

    private PySdkUtil() {
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, -1);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil", "getProcessOutput"));
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, int timeout) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, null, timeout);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil", "getProcessOutput"));
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, extraEnv, timeout, null, true);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil", "getProcessOutput"));
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout, @Nullable byte[] stdin, boolean needEOFMarker) {
        ProcessOutput processOutput;
        if (homePath == null || !new File(homePath).exists()) {
            ProcessOutput processOutput2 = new ProcessOutput();
            if (processOutput2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil", "getProcessOutput"));
            }
            return processOutput2;
        }
        Map<String, String> systemEnv = System.getenv();
        Map<String, String> env = extraEnv != null ? PySdkUtil.mergeEnvVariables(systemEnv, extraEnv) : systemEnv;
        try {
            Process process = new GeneralCommandLine(command).withWorkDirectory(homePath).withEnvironment(env).createProcess();
            CapturingProcessHandler processHandler = new CapturingProcessHandler(process);
            if (stdin != null) {
                OutputStream processInput = processHandler.getProcessInput();
                assert (processInput != null);
                processInput.write(stdin);
                if (SystemInfo.isWindows && needEOFMarker) {
                    processInput.write(26);
                    processInput.flush();
                } else {
                    processInput.close();
                }
            }
            processOutput = processHandler.runProcess(timeout);
        }
        catch (ExecutionException e) {
            ProcessOutput processOutput3 = PySdkUtil.getOutputForException((Exception)((Object)e));
            if (processOutput3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil", "getProcessOutput"));
            }
            return processOutput3;
        }
        catch (IOException e) {
            ProcessOutput processOutput4 = PySdkUtil.getOutputForException(e);
            if (processOutput4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil", "getProcessOutput"));
            }
            return processOutput4;
        }
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil", "getProcessOutput"));
        }
        return processOutput;
    }

    private static ProcessOutput getOutputForException(final Exception e) {
        LOG.warn((Throwable)e);
        return new ProcessOutput(){

            public String getStderr() {
                String err = super.getStderr();
                err = !StringUtil.isEmpty((String)err) ? err + "\n" + e.getMessage() : e.getMessage();
                return err;
            }
        };
    }

    @NotNull
    public static Map<String, String> mergeEnvVariables(@NotNull Map<String, String> environment, @NotNull Map<String, String> extraEnvironment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/python/sdk/PySdkUtil", "mergeEnvVariables"));
        }
        if (extraEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraEnvironment", "com/jetbrains/python/sdk/PySdkUtil", "mergeEnvVariables"));
        }
        HashMap result = new HashMap(environment);
        for (Map.Entry<String, String> entry : extraEnvironment.entrySet()) {
            if (PATH_ENV_VARIABLE.equals(entry.getKey()) && result.containsKey(PATH_ENV_VARIABLE)) {
                result.put(PATH_ENV_VARIABLE, (String)result.get(PATH_ENV_VARIABLE) + File.pathSeparator + entry.getValue());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil", "mergeEnvVariables"));
        }
        return hashMap;
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData;
    }

    public static String getUserSite() {
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            return appdata + File.separator + "Python";
        }
        String userHome = SystemProperties.getUserHome();
        return userHome + File.separator + ".local";
    }

    public static boolean isElementInSkeletons(@NotNull PsiElement element) {
        VirtualFile skeletonsDir;
        Sdk sdk;
        VirtualFile virtualFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/sdk/PySdkUtil", "isElementInSkeletons"));
        }
        PsiFile file = element.getContainingFile();
        return file != null && (virtualFile = file.getVirtualFile()) != null && (sdk = PythonSdkType.getSdk(element)) != null && (skeletonsDir = PySdkUtil.findSkeletonsDir(sdk)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)virtualFile, (boolean)false);
    }

    public static String getRemoteSourcesLocalPath(String sdkHome) {
        String sep = File.separator;
        String basePath = PathManager.getSystemPath();
        return basePath + File.separator + "remote_sources" + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + sep;
    }

    @Nullable
    public static VirtualFile findSkeletonsDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PySdkUtil", "findSkeletonsDir"));
        }
        return PySdkUtil.findLibraryDir(sdk, "python_stubs", PythonSdkType.BUILTIN_ROOT_TYPE);
    }

    @Nullable
    public static VirtualFile findAnyRemoteLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PySdkUtil", "findAnyRemoteLibrary"));
        }
        return PySdkUtil.findLibraryDir(sdk, "remote_sources", OrderRootType.CLASSES);
    }

    private static VirtualFile findLibraryDir(Sdk sdk, String dirName, OrderRootType rootType) {
        VirtualFile[] virtualFiles;
        for (VirtualFile virtualFile : virtualFiles = sdk.getRootProvider().getFiles(rootType)) {
            if (!virtualFile.isValid() || !virtualFile.getPath().contains(dirName)) continue;
            return virtualFile;
        }
        return null;
    }

    @Nullable
    public static List<PyRequirement> getRequirementsFromTxt(Module module) {
        VirtualFile requirementsTxt = PyPackageUtil.findRequirementsTxt(module);
        if (requirementsTxt != null) {
            return PyRequirement.parse(requirementsTxt);
        }
        return null;
    }
}

