/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@State(name="PySdkService", storages={@Storage(file="$APP_CONFIG$/removedInterpreters.xml")})
public class PySdkService
implements PersistentStateComponent<PySdkService> {
    public Set<String> REMOVED_SDKS = new HashSet<String>();
    public Set<String> ADDED_SDKS = new HashSet<String>();

    public static PySdkService getInstance() {
        return (PySdkService)ServiceManager.getService(PySdkService.class);
    }

    public void removeSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PySdkService", "removeSdk"));
        }
        String homePath = sdk.getHomePath();
        if (this.ADDED_SDKS.contains(homePath)) {
            this.ADDED_SDKS.remove(homePath);
        }
        this.REMOVED_SDKS.add(homePath);
    }

    public void addSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PySdkService", "addSdk"));
        }
        this.ADDED_SDKS.add(sdk.getHomePath());
    }

    public Set<String> getAddedSdks() {
        return this.ADDED_SDKS;
    }

    public void restoreSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PySdkService", "restoreSdk"));
        }
        String homePath = sdk.getHomePath();
        if (this.REMOVED_SDKS.contains(homePath)) {
            this.REMOVED_SDKS.remove(homePath);
        }
    }

    public boolean isRemoved(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PySdkService", "isRemoved"));
        }
        String homePath = sdk.getHomePath();
        return this.REMOVED_SDKS.contains(homePath);
    }

    public void solidifySdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/PySdkService", "solidifySdk"));
        }
        String homePath = sdk.getHomePath();
        if (this.ADDED_SDKS.contains(homePath)) {
            this.ADDED_SDKS.remove(homePath);
        }
    }

    public PySdkService getState() {
        return this;
    }

    public void loadState(PySdkService state2) {
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }
}

