/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySdkListCellRenderer
extends ListCellRendererWrapper<Object> {
    private final String myNullText;
    private final Map<Sdk, SdkModificator> mySdkModifiers;
    public static final String SEPARATOR = "separator";
    final Pattern PYTHON_PATTERN = Pattern.compile("(\\d\\.?\\d\\.?\\d?)[ ]*\\(([^\\(\\)]*)\\)|(\\d\\.?\\d\\.?\\d?)[ ]*([^\\(\\)]*)");
    private boolean isShortVersion;

    public PySdkListCellRenderer(boolean shortVersion) {
        this.isShortVersion = shortVersion;
        this.myNullText = "";
        this.mySdkModifiers = null;
    }

    public PySdkListCellRenderer(String nullText, @Nullable Map<Sdk, SdkModificator> sdkModifiers) {
        this.myNullText = nullText;
        this.mySdkModifiers = sdkModifiers;
    }

    public void customize(JList list, Object item, int index, boolean selected, boolean hasFocus) {
        if (item instanceof Sdk) {
            String flavorName;
            String trimmedRemote;
            Sdk sdk = (Sdk)item;
            PythonSdkFlavor flavor = PythonSdkFlavor.getPlatformIndependentFlavor(sdk.getHomePath());
            Icon icon = flavor != null ? flavor.getIcon() : ((SdkType)sdk.getSdkType()).getIcon();
            String name = this.mySdkModifiers != null && this.mySdkModifiers.containsKey(sdk) ? this.mySdkModifiers.get(sdk).getName() : sdk.getName();
            if (name.startsWith("Remote") && !(trimmedRemote = StringUtil.trim((String)name.substring("Remote".length()))).isEmpty()) {
                name = trimmedRemote;
            }
            String string = flavorName = flavor == null ? "Python" : flavor.getName();
            if (name.startsWith(flavorName)) {
                name = StringUtil.trim((String)name.substring(flavorName.length()));
            }
            if (this.isShortVersion) {
                name = this.shortenName(name);
            }
            if (PythonSdkType.isInvalid(sdk)) {
                this.setText("[invalid] " + name);
                this.setIcon((Icon)PySdkListCellRenderer.wrapIconWithWarningDecorator(icon));
            } else if (PythonSdkType.isIncompleteRemote(sdk)) {
                this.setText("[incomplete] " + name);
                this.setIcon((Icon)PySdkListCellRenderer.wrapIconWithWarningDecorator(icon));
            } else if (sdk instanceof PyDetectedSdk) {
                this.setText(name);
                this.setIcon(IconLoader.getTransparentIcon((Icon)icon));
            } else {
                this.setText(name);
                this.setIcon(icon);
            }
        } else if (SEPARATOR.equals(item)) {
            this.setSeparator();
        } else if (item == null) {
            this.setText(this.myNullText);
        }
    }

    private String shortenName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/sdk/PySdkListCellRenderer", "shortenName"));
        }
        Matcher matcher = this.PYTHON_PATTERN.matcher(name);
        if (matcher.matches()) {
            String path = matcher.group(2);
            if (path != null) {
                name = matcher.group(1) + " at " + path;
            } else {
                path = matcher.group(4);
                int index = path.lastIndexOf(File.separator);
                if (index > 0) {
                    path = path.substring(index);
                }
                name = matcher.group(3) + " at ..." + path;
            }
        } else if (new File(name).exists()) {
            name = FileUtil.getLocationRelativeToUserHome((String)name);
        }
        return name;
    }

    private static LayeredIcon wrapIconWithWarningDecorator(Icon icon) {
        LayeredIcon layered = new LayeredIcon(2);
        layered.setIcon(icon, 0);
        Icon overlay = AllIcons.Actions.Cancel;
        layered.setIcon(overlay, 1);
        return layered;
    }
}

