/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import org.jetbrains.annotations.Nullable;

public class InterpreterDirectoryMacro
extends Macro {
    @Override
    public String getName() {
        return "PyInterpreterDirectory";
    }

    @Override
    public String getDescription() {
        return "The directory containing the Python interpreter selected for the project";
    }

    @Override
    @Nullable
    public String expand(DataContext dataContext) throws Macro.ExecutionCancelledException {
        Sdk sdk;
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return null;
            }
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length == 0) {
                return null;
            }
            module = modules[0];
        }
        if ((sdk = PythonSdkType.findPythonSdk(module)) != null) {
            VirtualFile homeDir = sdk.getHomeDirectory();
            if (homeDir == null) {
                return null;
            }
            String path = PathUtil.getLocalPath((VirtualFile)homeDir.getParent());
            if (path != null) {
                return FileUtil.toSystemDependentName((String)path);
            }
        }
        return null;
    }
}

