/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.execution.ExecutionException;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.LocationNameFieldsBinding;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkService;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import com.jetbrains.python.ui.IdeaDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateVirtualEnvDialog
extends IdeaDialog {
    private JPanel myMainPanel;
    private JComboBox mySdkCombo;
    private TextFieldWithBrowseButton myDestination;
    private JTextField myName;
    private JBCheckBox mySitePackagesCheckBox;
    private JBCheckBox myMakeAvailableToAllProjectsCheckbox;
    @Nullable
    private Project myProject;
    private String myInitialPath;

    private static void setupVirtualEnvSdk(List<Sdk> allSdks, final String path, boolean associateWithProject, VirtualEnvCallback callback) {
        VirtualFile sdkHome = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            @Nullable
            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            }
        });
        if (sdkHome != null) {
            String name = SdkConfigurationUtil.createUniqueSdkName(PythonSdkType.getInstance(), sdkHome.getPath(), allSdks);
            ProjectJdkImpl sdk = new ProjectJdkImpl(name, (SdkTypeId)PythonSdkType.getInstance());
            sdk.setHomePath(FileUtil.toSystemDependentName((String)sdkHome.getPath()));
            callback.virtualEnvCreated(sdk, associateWithProject);
        }
    }

    public CreateVirtualEnvDialog(Project project, List<Sdk> allSdks, @Nullable Sdk suggestedBaseSdk) {
        super(project);
        this.setupDialog(project, allSdks, suggestedBaseSdk);
    }

    public CreateVirtualEnvDialog(Component owner, List<Sdk> allSdks, @Nullable Sdk suggestedBaseSdk) {
        super(owner);
        this.setupDialog(null, allSdks, suggestedBaseSdk);
    }

    private void setupDialog(Project project, List<Sdk> allSdks, @Nullable Sdk suggestedBaseSdk) {
        this.myProject = project;
        this.layoutPanel(allSdks);
        this.init();
        this.setTitle("Create Virtual Environment");
        Iterables.removeIf(allSdks, (Predicate)new Predicate<Sdk>(){

            public boolean apply(Sdk s) {
                return PythonSdkType.isInvalid(s) || PythonSdkType.isVirtualEnv(s) || RemoteSdkCredentialsHolder.isRemoteSdk(s.getHomePath());
            }
        });
        if (suggestedBaseSdk == null && allSdks.size() > 0) {
            ArrayList<Sdk> sortedSdks = new ArrayList<Sdk>(allSdks);
            Collections.sort(sortedSdks, new PreferredSdkComparator());
            suggestedBaseSdk = (Sdk)sortedSdks.get(0);
        }
        this.updateSdkList(allSdks, suggestedBaseSdk);
        if (project == null || project.isDefault() || !PlatformUtils.isPyCharm()) {
            this.myMakeAvailableToAllProjectsCheckbox.setSelected(true);
            this.myMakeAvailableToAllProjectsCheckbox.setVisible(false);
        }
        this.setOKActionEnabled(false);
        this.myInitialPath = "";
        VirtualFile file = VirtualEnvSdkFlavor.getDefaultLocation();
        if (file != null) {
            this.myInitialPath = file.getPath();
        } else {
            VirtualFile baseDir;
            String savedPath = PyPackageService.getInstance().getVirtualEnvBasePath();
            if (!StringUtil.isEmptyOrSpaces((String)savedPath)) {
                this.myInitialPath = savedPath;
            } else if (this.myProject != null && (baseDir = this.myProject.getBaseDir()) != null) {
                this.myInitialPath = baseDir.getPath();
            }
        }
        this.addUpdater(this.myName);
        new LocationNameFieldsBinding(project, this.myDestination, this.myName, this.myInitialPath, "Select Location for Virtual Environment");
        this.registerValidators(new FacetValidatorsManager(){

            public void registerValidator(FacetEditorValidator validator, JComponent ... componentsToWatch) {
            }

            public void validate() {
                CreateVirtualEnvDialog.this.checkValid();
            }
        });
        this.myMainPanel.setPreferredSize(new Dimension(300, 50));
        this.checkValid();
    }

    private void layoutPanel(final List<Sdk> allSdks) {
        GridBagLayout layout = new GridBagLayout();
        this.myMainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        this.myMainPanel.add((Component)new JBLabel("Name:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.myName = new JTextField();
        this.myMainPanel.add((Component)this.myName, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.myMainPanel.add((Component)new JBLabel("Location:"), c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.myDestination = new TextFieldWithBrowseButton();
        this.myMainPanel.add((Component)this.myDestination, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.myMainPanel.add((Component)new JBLabel("Base interpreter:"), c);
        c.gridx = 1;
        c.gridy = 2;
        this.mySdkCombo = new ComboBox();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        this.myMainPanel.add((Component)this.mySdkCombo, c);
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(0, 0, 2, 2);
        c.weightx = 0.0;
        FixedSizeButton button = new FixedSizeButton();
        button.setPreferredSize(this.myDestination.getButton().getPreferredSize());
        this.myMainPanel.add((Component)button, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.insets = new Insets(2, 2, 2, 2);
        this.mySitePackagesCheckBox = new JBCheckBox("Inherit global site-packages");
        this.myMainPanel.add((Component)this.mySitePackagesCheckBox, c);
        c.gridx = 0;
        c.gridy = 4;
        this.myMakeAvailableToAllProjectsCheckbox = new JBCheckBox("Make available to all projects");
        this.myMainPanel.add((Component)this.myMakeAvailableToAllProjectsCheckbox, c);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final PySdkService sdkService = PySdkService.getInstance();
                final PythonSdkType sdkType = PythonSdkType.getInstance();
                FileChooserDescriptor descriptor = sdkType.getHomeChooserDescriptor();
                String suggestedPath = sdkType.suggestHomePath();
                VirtualFile suggestedDir = suggestedPath == null ? null : LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)suggestedPath));
                NullableConsumer<Sdk> consumer = new NullableConsumer<Sdk>(){

                    public void consume(@Nullable Sdk sdk) {
                        if (sdk == null) {
                            return;
                        }
                        if (!allSdks.contains(sdk)) {
                            allSdks.add(sdk);
                            sdkService.addSdk(sdk);
                        }
                        CreateVirtualEnvDialog.this.updateSdkList(allSdks, sdk);
                    }
                };
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)CreateVirtualEnvDialog.this.myProject, (VirtualFile)suggestedDir, (Consumer)new FileChooser.FileChooserConsumer((NullableConsumer)consumer){
                    final /* synthetic */ NullableConsumer val$consumer;
                    {
                        this.val$consumer = nullableConsumer;
                    }

                    public void consume(List<VirtualFile> selectedFiles) {
                        String path = selectedFiles.get(0).getPath();
                        if (sdkType.isValidSdkHome(path)) {
                            path = FileUtil.toSystemDependentName((String)path);
                            PyDetectedSdk newSdk = null;
                            for (Sdk sdk : allSdks) {
                                if (!path.equals(sdk.getHomePath())) continue;
                                newSdk = sdk;
                            }
                            if (newSdk == null) {
                                newSdk = new PyDetectedSdk(path);
                            }
                            this.val$consumer.consume(newSdk);
                        }
                    }

                    public void cancelled() {
                    }
                });
            }
        });
    }

    private void checkValid() {
        String projectName = this.myName.getText();
        if (new File(this.getDestination()).exists()) {
            this.setOKActionEnabled(false);
            this.setErrorText("Directory already exists");
            return;
        }
        if (StringUtil.isEmptyOrSpaces((String)projectName)) {
            this.setOKActionEnabled(false);
            this.setErrorText("VirtualEnv name can't be empty");
            return;
        }
        if (!PathUtil.isValidFileName((String)projectName)) {
            this.setOKActionEnabled(false);
            this.setErrorText("Invalid directory name");
            return;
        }
        if (this.mySdkCombo.getSelectedItem() == null) {
            this.setOKActionEnabled(false);
            this.setErrorText("Select base interpreter");
            return;
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myDestination.getText())) {
            this.setOKActionEnabled(false);
            this.setErrorText("Destination directory can't be empty");
            return;
        }
        this.setOKActionEnabled(true);
        this.setErrorText(null);
    }

    private void registerValidators(final FacetValidatorsManager validatorsManager) {
        this.myDestination.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                validatorsManager.validate();
            }
        });
        this.mySdkCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                validatorsManager.validate();
            }
        });
        this.myDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                validatorsManager.validate();
            }
        });
        this.myName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent event) {
                validatorsManager.validate();
            }
        });
        this.myDestination.getTextField().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent event) {
                validatorsManager.validate();
            }
        });
    }

    private void updateSdkList(List<Sdk> allSdks, @Nullable Sdk initialSelection) {
        this.mySdkCombo.setRenderer(new PySdkListCellRenderer(false));
        this.mySdkCombo.setModel(new CollectionComboBoxModel(allSdks, (Object)initialSelection));
        this.checkValid();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public String getDestination() {
        return this.myDestination.getText();
    }

    public String getName() {
        return this.myName.getText();
    }

    protected void doOKAction() {
        VirtualFile baseDir;
        super.doOKAction();
        VirtualFile virtualFile = baseDir = this.myProject != null ? this.myProject.getBaseDir() : null;
        if (!(this.myDestination.getText().startsWith(this.myInitialPath) || baseDir != null && this.myDestination.getText().startsWith(baseDir.getPath()))) {
            String path = this.myDestination.getText();
            PyPackageService.getInstance().setVirtualEnvBasePath(!path.contains(File.separator) ? path : path.substring(0, path.lastIndexOf(File.separator)));
        }
    }

    public Sdk getSdk() {
        return (Sdk)this.mySdkCombo.getSelectedItem();
    }

    public boolean useGlobalSitePackages() {
        return this.mySitePackagesCheckBox.isSelected();
    }

    public boolean associateWithProject() {
        return !this.myMakeAvailableToAllProjectsCheckbox.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    public void createVirtualEnv(final List<Sdk> allSdks, final VirtualEnvCallback callback) {
        ProgressManager progman = ProgressManager.getInstance();
        final Sdk basicSdk = this.getSdk();
        Task.Modal createTask = new Task.Modal(this.myProject, "Creating virtual environment for " + basicSdk.getName(), false){
            String myPath;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/sdk/CreateVirtualEnvDialog$10", "run"));
                }
                PyPackageManager packageManager = PyPackageManager.getInstance(basicSdk);
                try {
                    indicator.setText("Creating virtual environment for " + basicSdk.getName());
                    this.myPath = packageManager.createVirtualEnv(CreateVirtualEnvDialog.this.getDestination(), CreateVirtualEnvDialog.this.useGlobalSitePackages());
                }
                catch (ExecutionException e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PackageManagementService.ErrorDescription description = PyPackageManagementService.toErrorDescription(Collections.singletonList(e), basicSdk);
                            if (description != null) {
                                PackagesNotificationPanel.showError("Failed to Create Virtual Environment", description);
                            }
                        }
                    }, ModalityState.any());
                }
            }

            public void onSuccess() {
                if (this.myPath != null) {
                    Application application = ApplicationManager.getApplication();
                    application.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CreateVirtualEnvDialog.setupVirtualEnvSdk(allSdks, myPath, CreateVirtualEnvDialog.this.associateWithProject(), callback);
                        }
                    }, ModalityState.any());
                }
            }
        };
        progman.run((Task)createTask);
    }

    public static interface VirtualEnvCallback {
        public void virtualEnvCreated(Sdk var1, boolean var2);
    }
}

