/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PythonTask {
    private static final long TIME_TO_WAIT_PROCESS_STOP = 2000L;
    protected final Module myModule;
    private final Sdk mySdk;
    private String myWorkingDirectory;
    private String myRunnerScript;
    private List<String> myParameters = new ArrayList<String>();
    private final String myRunTabTitle;
    private String myHelpId;
    private Runnable myAfterCompletion;

    public PythonTask(Module module, String runTabTitle) throws ExecutionException {
        this(module, runTabTitle, PythonSdkType.findPythonSdk(module));
    }

    public PythonTask(Module module, String runTabTitle, @Nullable Sdk sdk) throws ExecutionException {
        this.myModule = module;
        this.myRunTabTitle = runTabTitle;
        this.mySdk = sdk;
        if (this.mySdk == null) {
            throw new ExecutionException("Cannot find Python interpreter for selected module");
        }
    }

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public void setRunnerScript(String script) {
        this.myRunnerScript = script;
    }

    public void setParameters(List<String> parameters) {
        this.myParameters = parameters;
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    public void setAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
    }

    public ProcessHandler createProcess(@Nullable Map<String, String> env) throws ExecutionException {
        ProcessHandler handler;
        GeneralCommandLine commandLine = this.createCommandLine();
        if (env != null) {
            commandLine.getEnvironment().putAll(env);
        }
        if (PySdkUtil.isRemote(this.mySdk)) {
            assert (this.mySdk != null);
            handler = new PyRemoteProcessStarter().startRemoteProcess(this.mySdk, commandLine, this.myModule.getProject(), null);
        } else {
            EncodingEnvironmentUtil.fixDefaultEncodingIfMac((GeneralCommandLine)commandLine, (Project)this.myModule.getProject());
            handler = PythonProcessRunner.createProcessHandlingCtrlC(commandLine);
            ProcessTerminatedListener.attach((ProcessHandler)handler);
        }
        return handler;
    }

    public GeneralCommandLine createCommandLine() {
        String homePath;
        GeneralCommandLine cmd = new GeneralCommandLine();
        if (this.myWorkingDirectory != null) {
            cmd.setWorkDirectory(this.myWorkingDirectory);
        }
        if ((homePath = this.mySdk.getHomePath()) != null) {
            homePath = FileUtil.toSystemDependentName((String)homePath);
        }
        PythonCommandLineState.createStandardGroupsIn(cmd);
        ParamsGroup scriptParams = cmd.getParametersList().getParamsGroup("Script");
        assert (scriptParams != null);
        cmd.setPassParentEnvironment(true);
        Map env = cmd.getEnvironment();
        if (!SystemInfo.isWindows && !PySdkUtil.isRemote(this.mySdk)) {
            cmd.setExePath("bash");
            ParamsGroup bashParams = cmd.getParametersList().addParamsGroupAt(0, "Bash");
            bashParams.addParameter("-cl");
            NotNullFunction escaperFunction = StringUtil.escaper((boolean)false, (String)"|>$\"'& ");
            StringBuilder paramString = new StringBuilder((String)escaperFunction.fun((Object)homePath) + " " + (String)escaperFunction.fun((Object)this.myRunnerScript));
            for (String p : this.myParameters) {
                paramString.append(" ").append(p);
            }
            bashParams.addParameter(paramString.toString());
        } else {
            cmd.setExePath(homePath);
            scriptParams.addParameter(this.myRunnerScript);
            scriptParams.addParameters(this.myParameters);
        }
        PythonEnvUtil.setPythonUnbuffered(env);
        List<String> pythonPath = this.setupPythonPath();
        PythonCommandLineState.initPythonPath(cmd, true, pythonPath, homePath);
        BuildoutFacet facet = BuildoutFacet.getInstance(this.myModule);
        if (facet != null) {
            facet.patchCommandLineForBuildout(cmd);
        }
        return cmd;
    }

    protected List<String> setupPythonPath() {
        return this.setupPythonPath(true, true);
    }

    protected List<String> setupPythonPath(boolean addContent, boolean addSource) {
        ArrayList pythonPath = Lists.newArrayList(PythonCommandLineState.getAddedPaths(this.mySdk));
        pythonPath.addAll(PythonCommandLineState.collectPythonPath(this.myModule, addContent, addSource));
        return pythonPath;
    }

    public void run(final @Nullable Map<String, String> env) throws ExecutionException {
        final ProcessHandler process = this.createProcess(env);
        Project project = this.myModule.getProject();
        new RunContentExecutor(project, process).withFilter(new PythonTracebackFilter(project)).withTitle(this.myRunTabTitle).withRerun(new Runnable(){

            @Override
            public void run() {
                try {
                    process.destroyProcess();
                    if (process.waitFor(2000L)) {
                        PythonTask.this.run(env);
                    } else {
                        Messages.showErrorDialog((String)PyBundle.message("unable.to.stop", new Object[0]), (String)PythonTask.this.myRunTabTitle);
                    }
                }
                catch (ExecutionException e) {
                    Messages.showErrorDialog((String)e.getMessage(), (String)PythonTask.this.myRunTabTitle);
                }
            }
        }).withStop(new Runnable(){

            @Override
            public void run() {
                process.destroyProcess();
            }
        }, new Computable<Boolean>(){

            public Boolean compute() {
                return !process.isProcessTerminated();
            }
        }).withAfterCompletion(this.myAfterCompletion).withHelpId(this.myHelpId).run();
    }
}

