/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.CommandLineArgumentsProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonScriptCommandLineState
extends PythonCommandLineState {
    private final PythonRunConfiguration myConfig;

    public PythonScriptCommandLineState(PythonRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    @NotNull
    public ExecutionResult execute(Executor executor, CommandLinePatcher ... patchers) throws ExecutionException {
        if (this.myConfig.showCommandLineAfterwards()) {
            if (executor.getId() == DefaultDebugExecutor.EXECUTOR_ID) {
                ExecutionResult executionResult = super.execute(executor, (CommandLinePatcher[])ArrayUtil.append((Object[])patchers, (Object)new CommandLinePatcher(){

                    @Override
                    public void patchCommandLine(GeneralCommandLine commandLine) {
                        commandLine.getParametersList().getParamsGroup("Debugger").addParameterAt(1, "--cmd-line");
                    }
                }));
                if (executionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonScriptCommandLineState", "execute"));
                }
                return executionResult;
            }
            PythonScriptWithConsoleRunner runner = new PythonScriptWithConsoleRunner(this.myConfig.getProject(), this.myConfig.getSdk(), PyConsoleType.PYTHON, this.myConfig.getWorkingDirectory(), this.myConfig.getEnvs(), patchers, new String[0]);
            runner.runSync();
            ArrayList actions = Lists.newArrayList((Object[])this.createActions((ConsoleView)runner.getConsoleView(), runner.getProcessHandler()));
            DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(runner.getConsoleView(), runner.getProcessHandler(), actions.toArray(new AnAction[actions.size()]));
            if (defaultExecutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonScriptCommandLineState", "execute"));
            }
            return defaultExecutionResult;
        }
        ExecutionResult executionResult = super.execute(executor, patchers);
        if (executionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonScriptCommandLineState", "execute"));
        }
        return executionResult;
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        String script_options_string;
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exe_options = parametersList.getParamsGroup("Exe Options");
        assert (exe_options != null);
        exe_options.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup script_parameters = parametersList.getParamsGroup("Script");
        assert (script_parameters != null);
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getScriptName())) {
            script_parameters.addParameter(this.myConfig.getScriptName());
        }
        if ((script_options_string = this.myConfig.getScriptParameters()) != null) {
            script_parameters.addParametersString(script_options_string);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getWorkingDirectory())) {
            commandLine.setWorkDirectory(this.myConfig.getWorkingDirectory());
        }
    }

    public class PythonScriptWithConsoleRunner
    extends PydevConsoleRunner {
        private CommandLinePatcher[] myPatchers;

        public PythonScriptWithConsoleRunner(@NotNull Project project, @NotNull Sdk sdk, @Nullable PyConsoleType consoleType, String workingDir, Map<String, String> environmentVariables, CommandLinePatcher[] patchers, String ... statementsToExecute) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/run/PythonScriptCommandLineState$PythonScriptWithConsoleRunner", "<init>"));
            }
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/run/PythonScriptCommandLineState$PythonScriptWithConsoleRunner", "<init>"));
            }
            if (consoleType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleType", "com/jetbrains/python/run/PythonScriptCommandLineState$PythonScriptWithConsoleRunner", "<init>"));
            }
            super(project, sdk, consoleType, workingDir, environmentVariables, statementsToExecute);
            this.myPatchers = patchers;
        }

        @Override
        protected void createContentDescriptorAndActions() {
            AnAction a = this.createConsoleExecAction(this.myConsoleExecuteActionHandler);
            PythonScriptWithConsoleRunner.registerActionShortcuts(Lists.newArrayList((Object[])new AnAction[]{a}), ((PythonConsoleView)this.getConsoleView()).getConsole().getConsoleEditor().getComponent());
        }

        @Override
        protected CommandLineArgumentsProvider createCommandLineArgumentsProvider(final Sdk sdk, final Map<String, String> environmentVariables, int[] ports) {
            final ArrayList<String> args = new ArrayList<String>();
            args.add(sdk.getHomePath());
            String versionString = sdk.getVersionString();
            if (versionString == null || !versionString.toLowerCase().contains("jython")) {
                args.add("-u");
            }
            args.add(FileUtil.toSystemDependentName((String)PythonHelpersLocator.getHelperPath("pydev/pydev_run_in_console.py")));
            for (int port : ports) {
                args.add(String.valueOf(port));
            }
            try {
                final GeneralCommandLine cmd = PythonScriptCommandLineState.this.generateCommandLine(this.myPatchers);
                args.addAll(cmd.getParametersList().getList());
                return new CommandLineArgumentsProvider(){

                    public String[] getArguments() {
                        return ArrayUtil.toStringArray((Collection)args);
                    }

                    public boolean passParentEnvs() {
                        return false;
                    }

                    public Map<String, String> getAdditionalEnvs() {
                        Map<String, String> map = PydevConsoleRunner.addDefaultEnvironments(sdk, environmentVariables);
                        map.putAll(cmd.getEnvironment());
                        return map;
                    }
                };
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

