/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class PythonRunConfigurationForm
implements PythonRunConfigurationParams,
PanelWithAnchor {
    private JPanel myRootPanel;
    private TextFieldWithBrowseButton myScriptTextField;
    private RawCommandLineEditor myScriptParametersTextField;
    private JPanel myCommonOptionsPlaceholder;
    private JBLabel myScriptParametersLabel;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private JComponent anchor;
    private final Project myProject;
    private JBCheckBox myShowCommandLineCheckbox;

    public PythonRunConfigurationForm(PythonRunConfiguration configuration) {
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsPlaceholder.add((Component)this.myCommonOptionsForm.getMainPanel(), "Center");
        this.myProject = configuration.getProject();
        FileChooserDescriptor chooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || file.getExtension() == null || Comparing.equal((String)file.getExtension(), (String)"py");
            }
        };
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> listener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>("Select Script", "", (ComponentWithBrowseButton)this.myScriptTextField, this.myProject, chooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/python/run/PythonRunConfigurationForm$2", "onFileChosen"));
                }
                super.onFileChosen(chosenFile);
                PythonRunConfigurationForm.this.myCommonOptionsForm.setWorkingDirectory(chosenFile.getParent().getPath());
            }
        };
        this.myScriptTextField.addActionListener((ActionListener)listener);
        this.setAnchor(this.myCommonOptionsForm.getAnchor());
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this.myCommonOptionsForm;
    }

    @Override
    public String getScriptName() {
        return FileUtil.toSystemIndependentName((String)this.myScriptTextField.getText().trim());
    }

    @Override
    public void setScriptName(String scriptName) {
        this.myScriptTextField.setText(scriptName == null ? "" : FileUtil.toSystemDependentName((String)scriptName));
    }

    @Override
    public String getScriptParameters() {
        return this.myScriptParametersTextField.getText().trim();
    }

    @Override
    public void setScriptParameters(String scriptParameters) {
        this.myScriptParametersTextField.setText(scriptParameters);
    }

    @Override
    public boolean showCommandLineAfterwards() {
        return this.myShowCommandLineCheckbox.isSelected();
    }

    @Override
    public void setShowCommandLineAfterwards(boolean showCommandLineAfterwards) {
        this.myShowCommandLineCheckbox.setSelected(showCommandLineAfterwards);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public boolean isMultiprocessMode() {
        return PyDebuggerOptionsProvider.getInstance(this.myProject).isAttachToSubprocess();
    }

    public void setMultiprocessMode(boolean multiprocess) {
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myScriptParametersLabel.setAnchor(anchor);
        this.myCommonOptionsForm.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        RawCommandLineEditor rawCommandLineEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("runcfg.labels.script"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptParametersLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("runcfg.labels.script_parameters"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 1, null, null, null));
        this.myScriptParametersTextField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("runcfg.captions.script_parameters_dialog"));
        rawCommandLineEditor.setText("");
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommonOptionsPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myShowCommandLineCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Show command line afterwards");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

