/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PythonRunConfigurationEditor;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PythonRunConfiguration
extends AbstractPythonRunConfiguration
implements AbstractPythonRunConfigurationParams,
PythonRunConfigurationParams,
RefactoringListenerProvider {
    public static final String SCRIPT_NAME = "SCRIPT_NAME";
    public static final String PARAMETERS = "PARAMETERS";
    public static final String MULTIPROCESS = "MULTIPROCESS";
    public static final String SHOW_COMMAND_LINE = "SHOW_COMMAND_LINE";
    private String myScriptName;
    private String myScriptParameters;
    private boolean myShowCommandLineAfterwards = false;

    protected PythonRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
        this.setUnbufferedEnv();
    }

    protected SettingsEditor<? extends RunConfiguration> createConfigurationEditor() {
        return new PythonRunConfigurationEditor(this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/python/run/PythonRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/run/PythonRunConfiguration", "getState"));
        }
        return new PythonScriptCommandLineState(this, env);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (StringUtil.isEmptyOrSpaces((String)this.myScriptName)) {
            throw new RuntimeConfigurationException(PyBundle.message("runcfg.unittest.no_script_name", new Object[0]));
        }
    }

    public String suggestedName() {
        String scriptName = this.getScriptName();
        if (scriptName == null) {
            return null;
        }
        String name = new File(scriptName).getName();
        if (name.endsWith(".py")) {
            return name.substring(0, name.length() - 3);
        }
        return name;
    }

    @Override
    public String getScriptName() {
        return this.myScriptName;
    }

    @Override
    public void setScriptName(String scriptName) {
        this.myScriptName = scriptName;
    }

    @Override
    public String getScriptParameters() {
        return this.myScriptParameters;
    }

    @Override
    public void setScriptParameters(String scriptParameters) {
        this.myScriptParameters = scriptParameters;
    }

    @Override
    public boolean showCommandLineAfterwards() {
        return this.myShowCommandLineAfterwards;
    }

    @Override
    public void setShowCommandLineAfterwards(boolean showCommandLineAfterwards) {
        this.myShowCommandLineAfterwards = showCommandLineAfterwards;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        this.myScriptName = JDOMExternalizerUtil.readField((Element)element, (String)SCRIPT_NAME);
        this.myScriptParameters = JDOMExternalizerUtil.readField((Element)element, (String)PARAMETERS);
        this.myShowCommandLineAfterwards = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)SHOW_COMMAND_LINE, (String)"false"));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_NAME, (String)this.myScriptName);
        JDOMExternalizerUtil.writeField((Element)element, (String)PARAMETERS, (String)this.myScriptParameters);
        JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_COMMAND_LINE, (String)Boolean.toString(this.myShowCommandLineAfterwards));
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this;
    }

    public static void copyParams(PythonRunConfigurationParams source, PythonRunConfigurationParams target) {
        AbstractPythonRunConfiguration.copyParams(source.getBaseParams(), target.getBaseParams());
        target.setScriptName(source.getScriptName());
        target.setScriptParameters(source.getScriptParameters());
        target.setShowCommandLineAfterwards(source.showCommandLineAfterwards());
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        VirtualFile virtualFile;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null && Comparing.equal((String)new File(virtualFile.getPath()).getAbsolutePath(), (String)new File(this.myScriptName).getAbsolutePath())) {
            return new RefactoringElementAdapter(){

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/run/PythonRunConfiguration$1", "elementRenamedOrMoved"));
                    }
                    VirtualFile virtualFile = ((PsiFile)newElement).getVirtualFile();
                    if (virtualFile != null) {
                        this.updateScriptName(virtualFile.getPath());
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/run/PythonRunConfiguration$1", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/jetbrains/python/run/PythonRunConfiguration$1", "undoElementMovedOrRenamed"));
                    }
                    this.updateScriptName(oldQualifiedName);
                }

                private void updateScriptName(String path) {
                    PythonRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)path);
                }
            };
        }
        return null;
    }
}

