/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteProcessHandlerBase;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PyRemoteTracebackFilter;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonCommandLineState
extends CommandLineState {
    public static final String GROUP_EXE_OPTIONS = "Exe Options";
    public static final String GROUP_DEBUGGER = "Debugger";
    public static final String GROUP_SCRIPT = "Script";
    private final AbstractPythonRunConfiguration myConfig;
    private final List<Filter> myFilters = Lists.newArrayList((Object[])new Filter[]{new UrlFilter()});
    private Boolean myMultiprocessDebug = null;

    public boolean isDebug() {
        return "PyDebugRunner".equals(this.getEnvironment().getRunner().getRunnerId());
    }

    public static ServerSocket createServerSocket() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to find free socket port", (Throwable)e);
        }
        return serverSocket;
    }

    public PythonCommandLineState(AbstractPythonRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(env);
        this.myConfig = runConfiguration;
    }

    @Nullable
    public PythonSdkFlavor getSdkFlavor() {
        return PythonSdkFlavor.getFlavor(this.myConfig.getInterpreterPath());
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/python/run/PythonCommandLineState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/jetbrains/python/run/PythonCommandLineState", "execute"));
        }
        ExecutionResult executionResult = this.execute(executor, (CommandLinePatcher[])null);
        if (executionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonCommandLineState", "execute"));
        }
        return executionResult;
    }

    public ExecutionResult execute(Executor executor, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(patchers);
        ConsoleView console = this.createAndAttachConsole(this.myConfig.getProject(), processHandler, executor);
        ArrayList actions = Lists.newArrayList((Object[])this.createActions(console, processHandler));
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler, actions.toArray(new AnAction[actions.size()]));
    }

    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        ConsoleView consoleView = this.createConsoleBuilder(project).filters(this.myFilters).getConsole();
        this.addTracebackFilter(project, consoleView, processHandler);
        consoleView.attachToProcess(processHandler);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonCommandLineState", "createAndAttachConsole"));
        }
        return consoleView2;
    }

    protected void addTracebackFilter(Project project, ConsoleView consoleView, ProcessHandler processHandler) {
        if (PySdkUtil.isRemote(this.myConfig.getSdk())) {
            assert (processHandler instanceof RemoteProcessHandlerBase);
            consoleView.addMessageFilter((Filter)new PyRemoteTracebackFilter(project, this.myConfig.getWorkingDirectory(), (RemoteProcessHandlerBase)processHandler));
        } else {
            consoleView.addMessageFilter((Filter)new PythonTracebackFilter(project, this.myConfig.getWorkingDirectory()));
        }
    }

    private TextConsoleBuilder createConsoleBuilder(Project project) {
        if (this.isDebug()) {
            return new PyDebugConsoleBuilder(project, PythonSdkType.findSdkByPath(this.myConfig.getInterpreterPath()));
        }
        return TextConsoleBuilderFactory.getInstance().createBuilder(project);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(new CommandLinePatcher[0]);
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonCommandLineState", "startProcess"));
        }
        return processHandler;
    }

    protected ProcessHandler startProcess(CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler;
        GeneralCommandLine commandLine = this.generateCommandLine(patchers);
        PythonRunConfigurationExtensionsManager.getInstance().patchCommandLine((RunConfigurationBase)this.myConfig, this.getRunnerSettings(), commandLine, this.getEnvironment().getRunner().getRunnerId());
        Sdk sdk = PythonSdkType.findSdkByPath(this.myConfig.getInterpreterPath());
        if (PySdkUtil.isRemote(sdk)) {
            processHandler = this.createRemoteProcessStarter().startRemoteProcess(sdk, commandLine, this.myConfig.getProject(), this.myConfig.getMappingSettings());
        } else {
            EncodingEnvironmentUtil.fixDefaultEncodingIfMac((GeneralCommandLine)commandLine, (Project)this.myConfig.getProject());
            processHandler = this.doCreateProcess(commandLine);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        }
        PythonRunConfigurationExtensionsManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfig, processHandler, this.getRunnerSettings());
        return processHandler;
    }

    protected PyRemoteProcessStarter createRemoteProcessStarter() {
        return new PyRemoteProcessStarter();
    }

    public GeneralCommandLine generateCommandLine(CommandLinePatcher[] patchers) throws ExecutionException {
        GeneralCommandLine commandLine = this.generateCommandLine();
        if (patchers != null) {
            for (CommandLinePatcher patcher : patchers) {
                if (patcher == null) continue;
                patcher.patchCommandLine(commandLine);
            }
        }
        return commandLine;
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        return PythonProcessRunner.createProcess(commandLine);
    }

    public GeneralCommandLine generateCommandLine() throws ExecutionException {
        GeneralCommandLine commandLine = PythonCommandLineState.createCommandLine();
        this.setRunnerPath(commandLine);
        PythonCommandLineState.createStandardGroupsIn(commandLine);
        this.buildCommandLineParameters(commandLine);
        this.initEnvironment(commandLine);
        return commandLine;
    }

    private static GeneralCommandLine createCommandLine() {
        return Registry.is((String)"run.processes.with.pty") ? new PtyCommandLine() : new GeneralCommandLine();
    }

    public static void createStandardGroupsIn(GeneralCommandLine commandLine) {
        ParametersList params = commandLine.getParametersList();
        params.addParamsGroup(GROUP_EXE_OPTIONS);
        params.addParamsGroup(GROUP_DEBUGGER);
        params.addParamsGroup(GROUP_SCRIPT);
    }

    protected void initEnvironment(GeneralCommandLine commandLine) {
        Map env = this.myConfig.getEnvs();
        env = env == null ? new HashMap() : new HashMap(env);
        this.addPredefinedEnvironmentVariables(env, this.myConfig.isPassParentEnvs());
        PythonCommandLineState.addCommonEnvironmentVariables(env);
        commandLine.getEnvironment().clear();
        commandLine.getEnvironment().putAll(env);
        commandLine.setPassParentEnvironment(this.myConfig.isPassParentEnvs());
        this.buildPythonPath(commandLine, this.myConfig.isPassParentEnvs());
    }

    protected static void addCommonEnvironmentVariables(Map<String, String> env) {
        PythonEnvUtil.setPythonUnbuffered(env);
        env.put("PYCHARM_HOSTED", "1");
    }

    public void addPredefinedEnvironmentVariables(Map<String, String> envs, boolean passParentEnvs) {
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(this.myConfig.getInterpreterPath());
        if (flavor != null) {
            flavor.addPredefinedEnvironmentVariables(envs);
        }
    }

    private void buildPythonPath(GeneralCommandLine commandLine, boolean passParentEnvs) {
        Sdk pythonSdk = PythonSdkType.findSdkByPath(this.myConfig.getInterpreterPath());
        if (pythonSdk != null) {
            ArrayList pathList = Lists.newArrayList(PythonCommandLineState.getAddedPaths(pythonSdk));
            pathList.addAll(this.collectPythonPath());
            PythonCommandLineState.initPythonPath(commandLine, passParentEnvs, pathList, this.myConfig.getInterpreterPath());
        }
    }

    public static void initPythonPath(GeneralCommandLine commandLine, boolean passParentEnvs, List<String> pathList, String interpreterPath) {
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(interpreterPath);
        if (flavor != null) {
            flavor.initPythonPath(commandLine, pathList);
        } else {
            PythonSdkFlavor.initPythonPath(commandLine.getEnvironment(), passParentEnvs, pathList);
        }
    }

    public static List<String> getAddedPaths(Sdk pythonSdk) {
        ArrayList<String> pathList = new ArrayList<String>();
        SdkAdditionalData sdkAdditionalData = pythonSdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            Set<VirtualFile> addedPaths = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
            for (VirtualFile file : addedPaths) {
                PythonCommandLineState.addToPythonPath(file, pathList);
            }
        }
        return pathList;
    }

    private static void addToPythonPath(VirtualFile file, Collection<String> pathList) {
        if (file.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (realFile != null) {
                PythonCommandLineState.addIfNeeded(realFile, pathList);
            }
        } else {
            PythonCommandLineState.addIfNeeded(file, pathList);
        }
    }

    private static void addIfNeeded(@NotNull VirtualFile file, @NotNull Collection<String> pathList) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/run/PythonCommandLineState", "addIfNeeded"));
        }
        if (pathList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathList", "com/jetbrains/python/run/PythonCommandLineState", "addIfNeeded"));
        }
        PythonCommandLineState.addIfNeeded(pathList, file.getPath());
    }

    protected static void addIfNeeded(Collection<String> pathList, String path) {
        String filePath;
        HashSet vals = Sets.newHashSet(pathList);
        if (!vals.contains(filePath = FileUtil.toSystemDependentName((String)path))) {
            pathList.add(filePath);
        }
    }

    protected Collection<String> collectPythonPath() {
        Module module = this.myConfig.getModule();
        HashSet pythonPath = Sets.newHashSet(PythonCommandLineState.collectPythonPath(module, this.myConfig.shouldAddContentRoots(), this.myConfig.shouldAddSourceRoots()));
        if (this.isDebug() && this.getSdkFlavor() instanceof JythonSdkFlavor) {
            pythonPath.add(PythonHelpersLocator.getHelperPath("pycharm"));
            pythonPath.add(PythonHelpersLocator.getHelperPath("pydev"));
        }
        return pythonPath;
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module) {
        Collection<String> collection = PythonCommandLineState.collectPythonPath(module, true, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonCommandLineState", "collectPythonPath"));
        }
        return collection;
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module, boolean addContentRoots, boolean addSourceRoots) {
        LinkedHashSet pythonPathList = Sets.newLinkedHashSet();
        if (module != null) {
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            if (addContentRoots) {
                PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)module).getContentRoots());
                for (Module dependency : dependencies) {
                    PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)dependency).getContentRoots());
                }
            }
            if (addSourceRoots) {
                PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)module).getSourceRoots());
                for (Module dependency : dependencies) {
                    PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)dependency).getSourceRoots());
                }
            }
            PythonCommandLineState.addLibrariesFromModule(module, pythonPathList);
            PythonCommandLineState.addRootsFromModule(module, pythonPathList);
            for (Module dependency : dependencies) {
                PythonCommandLineState.addLibrariesFromModule(dependency, pythonPathList);
                PythonCommandLineState.addRootsFromModule(dependency, pythonPathList);
            }
        }
        LinkedHashSet linkedHashSet = pythonPathList;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonCommandLineState", "collectPythonPath"));
        }
        return linkedHashSet;
    }

    private static void addLibrariesFromModule(Module module, Collection<String> list) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            String name;
            if (!(entry instanceof LibraryOrderEntry) || (name = ((LibraryOrderEntry)entry).getLibraryName()) != null && name.endsWith(" interpreter library")) continue;
            for (VirtualFile root : ((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)) {
                PersistentLibraryKind<?> kind;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    PythonCommandLineState.addToPythonPath(root, list);
                    continue;
                }
                if (!(library instanceof LibraryImpl) || (kind = ((LibraryImpl)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                PythonCommandLineState.addToPythonPath(root, list);
            }
        }
    }

    private static void addRootsFromModule(Module module, Collection<String> pythonPathList) {
        Facet[] facets;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension != null) {
            VirtualFile pathForTests;
            VirtualFile path = extension.getCompilerOutputPath();
            if (path != null) {
                pythonPathList.add(path.getPath());
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                pythonPathList.add(pathForTests.getPath());
            }
        }
        for (Facet facet : facets = FacetManager.getInstance((Module)module).getAllFacets()) {
            List<String> more_paths;
            if (!(facet instanceof PythonPathContributingFacet) || (more_paths = ((PythonPathContributingFacet)facet).getAdditionalPythonPath()) == null) continue;
            pythonPathList.addAll(more_paths);
        }
    }

    private static void addRoots(Collection<String> pythonPathList, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            PythonCommandLineState.addToPythonPath(root, pythonPathList);
        }
    }

    protected void setRunnerPath(GeneralCommandLine commandLine) throws ExecutionException {
        String interpreterPath = this.getInterpreterPath();
        commandLine.setExePath(FileUtil.toSystemDependentName((String)interpreterPath));
    }

    protected String getInterpreterPath() throws ExecutionException {
        String interpreterPath = this.myConfig.getInterpreterPath();
        if (interpreterPath == null) {
            throw new ExecutionException("Cannot find Python interpreter for this run configuration");
        }
        return interpreterPath;
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
    }

    public boolean isMultiprocessDebug() {
        if (this.myMultiprocessDebug != null) {
            return this.myMultiprocessDebug;
        }
        return PyDebuggerOptionsProvider.getInstance(this.myConfig.getProject()).isAttachToSubprocess();
    }

    public void setMultiprocessDebug(boolean multiprocessDebug) {
        this.myMultiprocessDebug = multiprocessDebug;
    }
}

