/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteProcessHandlerBase;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.run.PythonTracebackFilter;
import org.jetbrains.annotations.Nullable;

public class PyRemoteTracebackFilter
extends PythonTracebackFilter {
    private final RemoteProcessHandlerBase myHandler;

    public PyRemoteTracebackFilter(Project project, String workingDirectory, RemoteProcessHandlerBase remoteProcessHandler) {
        super(project, workingDirectory);
        this.myHandler = remoteProcessHandler;
    }

    @Override
    @Nullable
    protected VirtualFile findFileByName(String fileName) {
        VirtualFile vFile = super.findFileByName(fileName);
        if (vFile != null) {
            return vFile;
        }
        for (PathMappingSettings.PathMapping m : this.myHandler.getMappingSettings().getPathMappings()) {
            VirtualFile file;
            if (!m.canReplaceRemote(fileName) || (file = LocalFileSystem.getInstance().findFileByPath(m.mapToLocal(fileName))) == null || !file.exists()) continue;
            return file;
        }
        return null;
    }
}

