/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteProcessStarter {
    public ProcessHandler startRemoteProcess(@NotNull Sdk sdk, @NotNull GeneralCommandLine commandLine, @Nullable Project project, @Nullable PathMappingSettings mappingSettings) throws ExecutionException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/run/PyRemoteProcessStarter", "startRemoteProcess"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/python/run/PyRemoteProcessStarter", "startRemoteProcess"));
        }
        PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
        if (manager != null) {
            ProcessHandler processHandler;
            try {
                processHandler = this.doStartRemoteProcess(sdk, commandLine, manager, project, mappingSettings);
            }
            catch (ExecutionException e) {
                Application application = ApplicationManager.getApplication();
                if (application != null && (application.isUnitTestMode() || application.isHeadlessEnvironment())) {
                    throw new RuntimeException(e);
                }
                throw new ExecutionException("Can't run remote python interpreter: " + e.getMessage(), (Throwable)e);
            }
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            return processHandler;
        }
        throw new PythonRemoteInterpreterManager.PyRemoteInterpreterExecutionException();
    }

    protected ProcessHandler doStartRemoteProcess(@NotNull Sdk sdk, @NotNull GeneralCommandLine commandLine, @NotNull PythonRemoteInterpreterManager manager, @Nullable Project project, @Nullable PathMappingSettings settings) throws ExecutionException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/run/PyRemoteProcessStarter", "doStartRemoteProcess"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/python/run/PyRemoteProcessStarter", "doStartRemoteProcess"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/python/run/PyRemoteProcessStarter", "doStartRemoteProcess"));
        }
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        assert (data instanceof PyRemoteSdkAdditionalDataBase);
        PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)data;
        try {
            settings = manager.setupMappings(project, pyRemoteSdkAdditionalDataBase, settings);
            return manager.startRemoteProcess(project, (PyRemoteSdkCredentials)pyRemoteSdkAdditionalDataBase.getRemoteSdkCredentials(true), commandLine, settings);
        }
        catch (InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
    }
}

