/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.Output;
import com.intellij.execution.OutputListener;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessRunner {
    private ProcessRunner() {
    }

    @NotNull
    public static Output runInPath(@Nullable Project project, @Nullable String workingDir, boolean showErrors, @Nullable Map<String, String> envs, String ... command) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/python/run/ProcessRunner", "runInPath"));
        }
        StringBuilder out = new StringBuilder();
        StringBuilder err = new StringBuilder();
        Process process = ProcessRunner.createProcess(workingDir, envs, command);
        String commandLine = StringUtil.join((String[])command, (String)" ");
        ColoredProcessHandler osProcessHandler = new ColoredProcessHandler(process, commandLine);
        osProcessHandler.addProcessListener((ProcessListener)new OutputListener(out, err));
        osProcessHandler.startNotify();
        ExecutionHelper.executeExternalProcess(project, (ProcessHandler)osProcessHandler, (ExecutionMode)new ExecutionModes.ModalProgressMode(null), commandLine);
        Output output = new Output(out.toString(), err.toString());
        if (showErrors && !StringUtil.isEmpty((String)output.getStderr())) {
            assert (project != null);
            String tabName = "Unknown error";
            LinkedList<Exception> errorList = new LinkedList<Exception>();
            errorList.add(new Exception(output.getStderr()));
            VirtualFile executableFile = LocalFileSystem.getInstance().findFileByPath(command[0]);
            ExecutionHelper.showErrors(project, errorList, "Unknown error", executableFile);
        }
        Output output2 = output;
        if (output2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/ProcessRunner", "runInPath"));
        }
        return output2;
    }

    @Nullable
    public static Process createProcess(@Nullable String workingDir, String ... command) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/python/run/ProcessRunner", "createProcess"));
        }
        return ProcessRunner.createProcess(workingDir, null, command);
    }

    @Nullable
    public static Process createProcess(@Nullable String workingDir, @Nullable Map<String, String> additionalEnvs, String ... command) throws ExecutionException {
        String[] arguments;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/python/run/ProcessRunner", "createProcess"));
        }
        if (command.length > 1) {
            arguments = new String[command.length - 1];
            System.arraycopy(command, 1, arguments, 0, command.length - 1);
        } else {
            arguments = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        GeneralCommandLine cmdLine = ProcessRunner.createAndSetupCmdLine(workingDir, additionalEnvs, true, command[0], arguments);
        return cmdLine.createProcess();
    }

    public static GeneralCommandLine createAndSetupCmdLine(@Nullable String workingDir, @Nullable Map<String, String> userDefinedEnv, boolean passParentEnv, @NotNull String executablePath, String ... arguments) {
        if (executablePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executablePath", "com/jetbrains/python/run/ProcessRunner", "createAndSetupCmdLine"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/python/run/ProcessRunner", "createAndSetupCmdLine"));
        }
        GeneralCommandLine cmdLine = new GeneralCommandLine();
        cmdLine.setExePath(FileUtil.toSystemDependentName((String)executablePath));
        if (workingDir != null) {
            cmdLine.setWorkDirectory(FileUtil.toSystemDependentName((String)workingDir));
        }
        ArrayList fixedArguments = new ArrayList();
        Collections.addAll(fixedArguments, arguments);
        cmdLine.addParameters(fixedArguments);
        cmdLine.setPassParentEnvironment(passParentEnv);
        Map env = cmdLine.getEnvironment();
        if (userDefinedEnv != null) {
            env.putAll(userDefinedEnv);
        }
        EnvironmentUtil.inlineParentOccurrences((Map)env);
        return cmdLine;
    }
}

