/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonRunConfiguration<T extends AbstractRunConfiguration>
extends AbstractRunConfiguration
implements LocatableConfiguration,
AbstractPythonRunConfigurationParams,
CommandLinePatcher {
    private String myInterpreterOptions = "";
    private String myWorkingDirectory = "";
    private String mySdkHome = "";
    private boolean myUseModuleSdk;
    private boolean myAddContentRoots = true;
    private boolean myAddSourceRoots = true;
    protected PathMappingSettings myMappingSettings;

    public AbstractPythonRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.getConfigurationModule().init();
    }

    public List<Module> getValidModules() {
        return AbstractPythonRunConfiguration.getValidModules(this.getProject());
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.myMappingSettings;
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings;
    }

    public static List<Module> getValidModules(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList result = Lists.newArrayList();
        for (Module module : modules) {
            if (PythonSdkType.findPythonSdk(module) == null) continue;
            result.add(module);
        }
        return result;
    }

    public PyCommonOptionsFormData getCommonOptionsFormData() {
        return new PyCommonOptionsFormData(){

            @Override
            public Project getProject() {
                return AbstractPythonRunConfiguration.this.getProject();
            }

            @Override
            public List<Module> getValidModules() {
                return AbstractPythonRunConfiguration.this.getValidModules();
            }

            @Override
            public boolean showConfigureInterpretersLink() {
                return false;
            }
        };
    }

    @NotNull
    public final SettingsEditor<T> getConfigurationEditor() {
        SettingsEditor<T> runConfigurationEditor = this.createConfigurationEditor();
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), runConfigurationEditor);
        PythonRunConfigurationExtensionsManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/AbstractPythonRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    protected abstract SettingsEditor<T> createConfigurationEditor();

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.checkSdk();
        this.checkExtensions();
    }

    private void checkExtensions() throws RuntimeConfigurationException {
        try {
            PythonRunConfigurationExtensionsManager.getInstance().validateConfiguration((RunConfigurationBase)this, false);
        }
        catch (RuntimeConfigurationException e) {
            throw e;
        }
        catch (Exception ee) {
            throw new RuntimeConfigurationException(ee.getMessage());
        }
    }

    private void checkSdk() throws RuntimeConfigurationError {
        if (PlatformUtils.isPyCharm()) {
            String path = this.getInterpreterPath();
            if (path == null) {
                throw new RuntimeConfigurationError("Please select a valid Python interpreter");
            }
        } else if (!this.myUseModuleSdk) {
            if (StringUtil.isEmptyOrSpaces((String)this.getSdkHome())) {
                Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
                if (projectSdk == null || !(projectSdk.getSdkType() instanceof PythonSdkType)) {
                    throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_sdk", new Object[0]));
                }
            } else if (!PythonSdkType.getInstance().isValidSdkHome(this.getSdkHome())) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_valid_sdk", new Object[0]));
            }
        } else {
            Sdk sdk = PythonSdkType.findPythonSdk(this.getModule());
            if (sdk == null) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_module_sdk", new Object[0]));
            }
        }
    }

    @Override
    public String getSdkHome() {
        Sdk projectJdk;
        String sdkHome = this.mySdkHome;
        if (StringUtil.isEmptyOrSpaces((String)this.mySdkHome) && (projectJdk = PythonSdkType.findPythonSdk(this.getModule())) != null) {
            sdkHome = projectJdk.getHomePath();
        }
        return sdkHome;
    }

    @Nullable
    public String getInterpreterPath() {
        String sdkHome;
        if (this.myUseModuleSdk) {
            Sdk sdk = PythonSdkType.findPythonSdk(this.getModule());
            if (sdk == null) {
                return null;
            }
            sdkHome = sdk.getHomePath();
        } else {
            sdkHome = this.getSdkHome();
        }
        return sdkHome;
    }

    public Sdk getSdk() {
        if (this.myUseModuleSdk) {
            return PythonSdkType.findPythonSdk(this.getModule());
        }
        return PythonSdkType.findSdkByPath(this.getSdkHome());
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myInterpreterOptions = JDOMExternalizerUtil.readField((Element)element, (String)"INTERPRETER_OPTIONS");
        this.readEnvs(element);
        this.mySdkHome = JDOMExternalizerUtil.readField((Element)element, (String)"SDK_HOME");
        this.myWorkingDirectory = JDOMExternalizerUtil.readField((Element)element, (String)"WORKING_DIRECTORY");
        this.myUseModuleSdk = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"IS_MODULE_SDK"));
        String addContentRoots = JDOMExternalizerUtil.readField((Element)element, (String)"ADD_CONTENT_ROOTS");
        this.myAddContentRoots = addContentRoots == null || Boolean.parseBoolean(addContentRoots);
        String addSourceRoots = JDOMExternalizerUtil.readField((Element)element, (String)"ADD_SOURCE_ROOTS");
        this.myAddSourceRoots = addSourceRoots == null || Boolean.parseBoolean(addSourceRoots);
        this.getConfigurationModule().readExternal(element);
        this.setMappingSettings(PathMappingSettings.readExternal((Element)element));
        PythonRunConfigurationExtensionsManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    protected void readEnvs(Element element) {
        String parentEnvs = JDOMExternalizerUtil.readField((Element)element, (String)"PARENT_ENVS");
        if (parentEnvs != null) {
            this.setPassParentEnvs(Boolean.parseBoolean(parentEnvs));
        }
        EnvironmentVariablesComponent.readExternal(element, this.getEnvs());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"INTERPRETER_OPTIONS", (String)this.myInterpreterOptions);
        this.writeEnvs(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"SDK_HOME", (String)this.mySdkHome);
        JDOMExternalizerUtil.writeField((Element)element, (String)"WORKING_DIRECTORY", (String)this.myWorkingDirectory);
        JDOMExternalizerUtil.writeField((Element)element, (String)"IS_MODULE_SDK", (String)Boolean.toString(this.myUseModuleSdk));
        JDOMExternalizerUtil.writeField((Element)element, (String)"ADD_CONTENT_ROOTS", (String)Boolean.toString(this.myAddContentRoots));
        JDOMExternalizerUtil.writeField((Element)element, (String)"ADD_SOURCE_ROOTS", (String)Boolean.toString(this.myAddSourceRoots));
        this.getConfigurationModule().writeExternal(element);
        PythonRunConfigurationExtensionsManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        PathMappingSettings.writeExternal((Element)element, (PathMappingSettings)this.getMappingSettings());
    }

    protected void writeEnvs(Element element) {
        JDOMExternalizerUtil.writeField((Element)element, (String)"PARENT_ENVS", (String)Boolean.toString(this.isPassParentEnvs()));
        EnvironmentVariablesComponent.writeExternal(element, this.getEnvs());
    }

    @Override
    public String getInterpreterOptions() {
        return this.myInterpreterOptions;
    }

    @Override
    public void setInterpreterOptions(String interpreterOptions) {
        this.myInterpreterOptions = interpreterOptions;
    }

    @Override
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    @Override
    public void setSdkHome(String sdkHome) {
        this.mySdkHome = sdkHome;
    }

    @Override
    public Module getModule() {
        return this.getConfigurationModule().getModule();
    }

    @Override
    public boolean isUseModuleSdk() {
        return this.myUseModuleSdk;
    }

    @Override
    public void setUseModuleSdk(boolean useModuleSdk) {
        this.myUseModuleSdk = useModuleSdk;
    }

    @Override
    public boolean shouldAddContentRoots() {
        return this.myAddContentRoots;
    }

    @Override
    public boolean shouldAddSourceRoots() {
        return this.myAddSourceRoots;
    }

    @Override
    public void setAddSourceRoots(boolean flag) {
        this.myAddSourceRoots = flag;
    }

    @Override
    public void setAddContentRoots(boolean flag) {
        this.myAddContentRoots = flag;
    }

    public static void copyParams(AbstractPythonRunConfigurationParams source, AbstractPythonRunConfigurationParams target) {
        target.setEnvs(new HashMap<String, String>(source.getEnvs()));
        target.setInterpreterOptions(source.getInterpreterOptions());
        target.setPassParentEnvs(source.isPassParentEnvs());
        target.setSdkHome(source.getSdkHome());
        target.setWorkingDirectory(source.getWorkingDirectory());
        target.setModule(source.getModule());
        target.setUseModuleSdk(source.isUseModuleSdk());
        target.setMappingSettings(source.getMappingSettings());
        target.setAddContentRoots(source.shouldAddContentRoots());
        target.setAddSourceRoots(source.shouldAddSourceRoots());
    }

    @Override
    public void patchCommandLine(GeneralCommandLine commandLine) {
        String interpreterPath = this.getInterpreterPath();
        Sdk sdk = this.getSdk();
        if (sdk != null && interpreterPath != null) {
            this.patchCommandLineFirst(commandLine, interpreterPath);
            this.patchCommandLineForVirtualenv(commandLine, interpreterPath);
            this.patchCommandLineForBuildout(commandLine, interpreterPath);
            this.patchCommandLineLast(commandLine, interpreterPath);
        }
    }

    protected void patchCommandLineFirst(GeneralCommandLine commandLine, String sdk_home) {
    }

    protected void patchCommandLineLast(GeneralCommandLine commandLine, String sdk_home) {
    }

    protected void patchCommandLineForBuildout(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineForVirtualenv(GeneralCommandLine commandLine, String sdkHome) {
        PythonSdkType.patchCommandLineForVirtualenv(commandLine, sdkHome, this.isPassParentEnvs());
    }

    protected void setUnbufferedEnv() {
        Map envs = this.getEnvs();
        PythonEnvUtil.setPythonUnbuffered(envs);
    }

    public boolean excludeCompileBeforeLaunchOption() {
        Module module = this.getModule();
        return module != null ? ModuleType.get((Module)module) instanceof PythonModuleTypeBase : true;
    }

    public boolean canRunWithCoverage() {
        return true;
    }

    public String getTestSpec(Location location) {
        PsiElement element = location.getPsiElement();
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        VirtualFile virtualFile = location.getVirtualFile();
        if (virtualFile != null) {
            String path = virtualFile.getCanonicalPath();
            if (pyClass != null) {
                path = path + "::" + pyClass.getName();
            }
            if (pyFunction != null) {
                path = path + "::" + pyFunction.getName();
            }
            return path;
        }
        return null;
    }
}

