/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.RemoteProjectSettings;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import java.awt.Component;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonRemoteInterpreterManager {
    public static final ExtensionPointName<PythonRemoteInterpreterManager> EP_NAME = ExtensionPointName.create((String)"Pythonid.remoteInterpreterManager");
    public static final String WEB_DEPLOYMENT_PLUGIN_IS_DISABLED = "Remote interpreter can't be executed. Please enable the Remote Hosts Access plugin.";

    public abstract ProcessHandler startRemoteProcess(@Nullable Project var1, @NotNull PyRemoteSdkCredentials var2, @NotNull GeneralCommandLine var3, @NotNull PathMappingSettings var4) throws RemoteSdkException;

    public abstract ProcessHandler startRemoteProcessWithPid(@Nullable Project var1, @NotNull PyRemoteSdkCredentials var2, @NotNull GeneralCommandLine var3, @NotNull PathMappingSettings var4) throws RemoteSdkException;

    public abstract void addRemoteSdk(Project var1, Component var2, Collection<Sdk> var3, NullableConsumer<Sdk> var4);

    public abstract ProcessOutput runRemoteProcess(@Nullable Project var1, RemoteSdkCredentials var2, @NotNull PathMappingSettings var3, String[] var4, @Nullable String var5, boolean var6) throws RemoteSdkException;

    @NotNull
    public abstract RemoteSshProcess createRemoteProcess(@Nullable Project var1, @NotNull PyRemoteSdkCredentials var2, @NotNull PathMappingSettings var3, @NotNull GeneralCommandLine var4, boolean var5) throws RemoteSdkException;

    public abstract boolean editSdk(@NotNull Project var1, @NotNull SdkModificator var2, Collection<Sdk> var3);

    public abstract PySkeletonGenerator createRemoteSkeletonGenerator(@Nullable Project var1, @Nullable Component var2, @NotNull Sdk var3, String var4) throws ExecutionException;

    public abstract boolean ensureCanWrite(@Nullable Object var1, RemoteSdkCredentials var2, String var3);

    @Nullable
    public abstract RemoteProjectSettings showRemoteProjectSettingsDialog(VirtualFile var1, RemoteSdkCredentials var2);

    public abstract void createDeployment(Project var1, VirtualFile var2, RemoteProjectSettings var3, RemoteSdkCredentials var4);

    public abstract void copyFromRemote(@NotNull Project var1, RemoteSdkCredentials var2, List<PathMappingSettings.PathMapping> var3);

    @Nullable
    public static PythonRemoteInterpreterManager getInstance() {
        if (((PythonRemoteInterpreterManager[])EP_NAME.getExtensions()).length > 0) {
            return ((PythonRemoteInterpreterManager[])EP_NAME.getExtensions())[0];
        }
        return null;
    }

    public static void addUnbuffered(ParamsGroup exeGroup) {
        for (String param : exeGroup.getParametersList().getParameters()) {
            if (!"-u".equals(param)) continue;
            return;
        }
        exeGroup.addParameter("-u");
    }

    public static String toSystemDependent(String path, boolean isWin) {
        char separator = isWin ? (char)'\\' : '/';
        return FileUtil.toSystemIndependentName((String)path).replace('/', separator);
    }

    public static void addHelpersMapping(@NotNull RemoteSdkProperties data, @Nullable PathMappingSettings newMappingSettings) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/python/remote/PythonRemoteInterpreterManager", "addHelpersMapping"));
        }
        if (newMappingSettings == null) {
            newMappingSettings = new PathMappingSettings();
        }
        newMappingSettings.addMapping(PythonHelpersLocator.getHelpersRoot().getPath(), data.getHelpersPath());
    }

    @NotNull
    public abstract PathMappingSettings setupMappings(@Nullable Project var1, @NotNull PyRemoteSdkAdditionalDataBase var2, @Nullable PathMappingSettings var3);

    public abstract SdkAdditionalData loadRemoteSdkData(Sdk var1, Element var2);

    public abstract PyConsoleProcessHandler createConsoleProcessHandler(Process var1, PyRemoteSdkCredentials var2, PythonConsoleView var3, PydevConsoleCommunication var4, String var5, Charset var6, PathMappingSettings var7);

    @NotNull
    public abstract RemoteSdkCredentialsProducer<PyRemoteSdkCredentials> getRemoteSdkCredentialsProducer(Function<RemoteCredentials, PyRemoteSdkCredentials> var1, RemoteConnectionCredentialsWrapper var2);

    public abstract void runVagrant(String var1) throws ExecutionException;

    public static class PyRemoteInterpreterRuntimeException
    extends RuntimeException {
        public PyRemoteInterpreterRuntimeException() {
            super(PythonRemoteInterpreterManager.WEB_DEPLOYMENT_PLUGIN_IS_DISABLED);
        }
    }

    public static class PyRemoteInterpreterExecutionException
    extends ExecutionException {
        public PyRemoteInterpreterExecutionException() {
            super(PythonRemoteInterpreterManager.WEB_DEPLOYMENT_PLUGIN_IS_DISABLED);
        }
    }
}

