/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PyStatementWithElse;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyIfPartIfImpl;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class PyUnwrapper
extends AbstractUnwrapper<Context> {
    public PyUnwrapper(String description) {
        super(description);
    }

    @Override
    protected Context createContext() {
        return new Context();
    }

    @Override
    public List<PsiElement> unwrap(Editor editor, PsiElement element) throws IncorrectOperationException {
        List<PsiElement> res = super.unwrap(editor, element);
        for (PsiElement e : res) {
            CodeEditUtil.markToReformat(e.getNode(), true);
        }
        return res;
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        public void extractPart(@Nullable PsiElement from) {
            if (from instanceof PyStatementWithElse) {
                this.extractFromConditionalBlock((PyStatementWithElse)from);
            } else if (from instanceof PyStatementPart) {
                this.extractFromElseBlock((PyStatementPart)from);
            } else if (from instanceof PyWithStatement) {
                this.extractFromWithBlock((PyWithStatement)from);
            }
        }

        public void extractFromConditionalBlock(PyStatementWithElse from) {
            PyStatementList statementList = null;
            if (from instanceof PyIfStatement) {
                PyIfPart ifPart = ((PyIfStatement)from).getIfPart();
                if (ifPart instanceof PyIfPartIfImpl) {
                    statementList = ifPart.getStatementList();
                }
            } else if (from instanceof PyWhileStatement) {
                PyWhilePart part = ((PyWhileStatement)from).getWhilePart();
                statementList = part.getStatementList();
            } else if (from instanceof PyTryExceptStatement) {
                PyTryPart part = ((PyTryExceptStatement)from).getTryPart();
                statementList = part.getStatementList();
            } else if (from instanceof PyForStatement) {
                PyForPart part = ((PyForStatement)from).getForPart();
                statementList = part.getStatementList();
            }
            if (statementList != null) {
                this.extract(statementList.getFirstChild(), statementList.getLastChild(), (PsiElement)from);
            }
        }

        public void extractFromElseBlock(PyStatementPart from) {
            PyStatementList body = from.getStatementList();
            if (body != null) {
                this.extract(body.getFirstChild(), body.getLastChild(), from.getParent());
            }
        }

        public void extractFromWithBlock(PyWithStatement from) {
            PyStatementList body;
            ASTNode n = from.getNode().findChildByType(PyElementTypes.STATEMENT_LISTS);
            if (n != null && (body = (PyStatementList)n.getPsi()) != null) {
                this.extract(body.getFirstChild(), body.getLastChild(), from);
            }
        }

        @Override
        protected boolean isWhiteSpace(PsiElement element) {
            return element instanceof PsiWhiteSpace;
        }
    }
}

