/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PyIfPartIfImpl;
import com.jetbrains.python.refactoring.unwrap.PyUnwrapper;
import java.util.List;

public class PyIfUnwrapper
extends PyUnwrapper {
    public PyIfUnwrapper() {
        super(PyBundle.message("unwrap.if", new Object[0]));
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        PyStatementList statementList;
        if (e instanceof PyIfPartIfImpl && (statementList = ((PyIfPartIfImpl)e).getStatementList()) != null) {
            PyStatement[] statements = statementList.getStatements();
            return statements.length == 1 && !(statements[0] instanceof PyPassStatement) || statements.length > 1;
        }
        return false;
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return PsiTreeUtil.getParentOfType((PsiElement)e, PyIfStatement.class);
    }

    @Override
    protected void doUnwrap(PsiElement element, PyUnwrapper.Context context) throws IncorrectOperationException {
        PyIfStatement ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyIfStatement.class);
        context.extractPart((PsiElement)ifStatement);
        context.delete((PsiElement)ifStatement);
    }
}

