/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.refactoring.unwrap.PyUnwrapper;

public class PyForUnwrapper
extends PyUnwrapper {
    public PyForUnwrapper() {
        super(PyBundle.message("unwrap.for", new Object[0]));
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        PyStatementList statementList;
        if (e instanceof PyForStatement && (statementList = ((PyForStatement)e).getForPart().getStatementList()) != null) {
            PyStatement[] statements = statementList.getStatements();
            return statements.length == 1 && !(statements[0] instanceof PyPassStatement) || statements.length > 1;
        }
        return false;
    }

    @Override
    protected void doUnwrap(PsiElement element, PyUnwrapper.Context context) throws IncorrectOperationException {
        PyForStatement forStatement = (PyForStatement)element;
        context.extractPart(forStatement);
        context.extractPart((PsiElement)forStatement.getElsePart());
        context.delete(forStatement);
    }
}

