/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementWithElse;
import com.jetbrains.python.psi.impl.PyIfPartElifImpl;
import com.jetbrains.python.refactoring.unwrap.PyUnwrapper;
import java.util.List;

public class PyElIfUnwrapper
extends PyUnwrapper {
    public PyElIfUnwrapper() {
        super(PyBundle.message("unwrap.elif", new Object[0]));
    }

    @Override
    protected void doUnwrap(PsiElement element, PyUnwrapper.Context context) throws IncorrectOperationException {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, PyStatementWithElse.class);
        context.extractPart(element);
        context.delete(parent);
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return PsiTreeUtil.getParentOfType((PsiElement)e, PyStatementWithElse.class);
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        PyStatementList statementList;
        if (e instanceof PyIfPartElifImpl && (statementList = ((PyIfPartElifImpl)e).getStatementList()) != null) {
            PyStatement[] statements = statementList.getStatements();
            return statements.length == 1 && !(statements[0] instanceof PyPassStatement) || statements.length > 1;
        }
        return false;
    }
}

