/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.surround.surrounders.statements;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.refactoring.surround.surrounders.statements.PyStatementSurrounder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyWithWhileSurrounder
extends PyStatementSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithWhileSurrounder", "surroundStatement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithWhileSurrounder", "surroundStatement"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithWhileSurrounder", "surroundStatement"));
        }
        PyWhileStatement whileStatement = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyWhileStatement.class, "while True:\n    ");
        PsiElement parent = elements[0].getParent();
        PyStatementList statementList = whileStatement.getWhilePart().getStatementList();
        statementList.addRange(elements[0], elements[elements.length - 1]);
        whileStatement = (PyWhileStatement)parent.addBefore((PsiElement)whileStatement, elements[0]);
        parent.deleteChildRange(elements[0], elements[elements.length - 1]);
        whileStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(whileStatement);
        if (whileStatement == null) {
            return null;
        }
        PyExpression condition = whileStatement.getWhilePart().getCondition();
        assert (condition != null);
        return condition.getTextRange();
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.while.template", (Object[])new Object[0]);
    }
}

