/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.surround.surrounders.statements;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.refactoring.surround.surrounders.statements.PyStatementSurrounder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyWithTryExceptSurrounder
extends PyStatementSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithTryExceptSurrounder", "surroundStatement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithTryExceptSurrounder", "surroundStatement"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithTryExceptSurrounder", "surroundStatement"));
        }
        PyTryExceptStatement tryStatement = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyTryExceptStatement.class, this.getTemplate());
        PsiElement parent = elements[0].getParent();
        PyStatementList statementList = tryStatement.getTryPart().getStatementList();
        statementList.addRange(elements[0], elements[elements.length - 1]);
        statementList.getFirstChild().delete();
        tryStatement = (PyTryExceptStatement)parent.addBefore((PsiElement)tryStatement, elements[0]);
        parent.deleteChildRange(elements[0], elements[elements.length - 1]);
        PsiFile psiFile = parent.getContainingFile();
        Document document = psiFile.getViewProvider().getDocument();
        TextRange range = tryStatement.getTextRange();
        assert (document != null);
        RangeMarker rangeMarker = document.createRangeMarker(range);
        PsiElement element = psiFile.findElementAt(rangeMarker.getStartOffset());
        tryStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyTryExceptStatement.class);
        if (tryStatement != null) {
            return this.getResultRange(tryStatement);
        }
        return null;
    }

    protected String getTemplate() {
        return "try:\n    pass\nexcept:\n    pass";
    }

    protected TextRange getResultRange(PyTryExceptStatement tryStatement) {
        PyExceptPart part = tryStatement.getExceptParts()[0];
        PyStatementList list = part.getStatementList();
        return list.getTextRange();
    }

    public String getTemplateDescription() {
        return PyBundle.message("surround.with.try.except.template", new Object[0]);
    }
}

