/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.surround.surrounders.statements;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.refactoring.surround.surrounders.statements.PyStatementSurrounder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyWithIfSurrounder
extends PyStatementSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithIfSurrounder", "surroundStatement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithIfSurrounder", "surroundStatement"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/surround/surrounders/statements/PyWithIfSurrounder", "surroundStatement"));
        }
        PyIfStatement ifStatement = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyIfStatement.class, "if True:\n    ");
        PsiElement parent = elements[0].getParent();
        PyStatementList statementList = ifStatement.getIfPart().getStatementList();
        statementList.addRange(elements[0], elements[elements.length - 1]);
        ifStatement = (PyIfStatement)parent.addBefore((PsiElement)ifStatement, elements[0]);
        parent.deleteChildRange(elements[0], elements[elements.length - 1]);
        ifStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(ifStatement);
        if (ifStatement == null) {
            return null;
        }
        PyExpression condition = ifStatement.getIfPart().getCondition();
        return condition != null ? condition.getTextRange() : null;
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.if.template", (Object[])new Object[0]);
    }
}

