/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.rename.RenamePyElementProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePyVariableProcessor
extends RenamePyElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/rename/RenamePyVariableProcessor", "canProcessElement"));
        }
        return element instanceof PyElement && !(element instanceof PyReferenceExpression);
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_VARIABLE;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_VARIABLE = enabled;
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        if (element instanceof PyLambdaExpression) {
            PyTargetExpression site;
            PyClass cls;
            Property property;
            PyLambdaExpression lambdaExpression = (PyLambdaExpression)element;
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)lambdaExpression);
            if (owner instanceof PyClass && (property = (cls = (PyClass)owner).findPropertyByCallable(lambdaExpression)) != null && (site = property.getDefinitionSite()) != null) {
                return site;
            }
            return null;
        }
        return element;
    }
}

