/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.refactoring.rename.RenamePyElementProcessor;
import com.jetbrains.python.toolbox.Maybe;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RenamePyFunctionProcessor
extends RenamePyElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/rename/RenamePyFunctionProcessor", "canProcessElement"));
        }
        return element instanceof PyFunction;
    }

    @Override
    public boolean forcesShowPreview() {
        return true;
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION = enabled;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION = enabled;
    }

    @Override
    public PsiElement substituteElementToRename(PsiElement element, Editor editor) {
        PyTargetExpression site;
        PyFunction function = (PyFunction)element;
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return function;
        }
        if ("__init__".equals(function.getName())) {
            return containingClass;
        }
        PyFunction deepestSuperMethod = PySuperMethodsSearch.findDeepestSuperMethod(function);
        if (!deepestSuperMethod.equals(function)) {
            String message = "Method " + function.getName() + " of class " + containingClass.getQualifiedName() + "\noverrides method of class " + deepestSuperMethod.getContainingClass().getQualifiedName() + ".\nDo you want to rename the base method?";
            int rc = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)message, (String)"Rename", (Icon)Messages.getQuestionIcon());
            if (rc == 0) {
                return deepestSuperMethod;
            }
            if (rc == 1) {
                return function;
            }
            return null;
        }
        Property property = containingClass.findPropertyByCallable(function);
        if (property != null && (site = property.getDefinitionSite()) != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return site;
            }
            String message = String.format("Do you want to rename the property '%s' instead of its accessor function '%s'?", property.getName(), function.getName());
            int rc = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)message, (String)"Rename", (Icon)Messages.getQuestionIcon());
            switch (rc) {
                case 0: {
                    return site;
                }
                case 1: {
                    return function;
                }
            }
            return null;
        }
        return function;
    }

    @Override
    public void prepareRenaming(PsiElement element, final String newName, final Map<PsiElement, String> allRenames) {
        Property property;
        PyFunction function = (PyFunction)element;
        PyOverridingMethodsSearch.search(function, true).forEach((Processor)new Processor<PyFunction>(){

            public boolean process(PyFunction pyFunction) {
                allRenames.put(pyFunction, newName);
                return true;
            }
        });
        PyClass containingClass = function.getContainingClass();
        if (containingClass != null && (property = containingClass.findPropertyByCallable(function)) != null) {
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getGetter());
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getSetter());
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getDeleter());
        }
    }

    private static void addRename(Map<PsiElement, String> renames, String newName, Maybe<Callable> accessor) {
        Callable callable = accessor.valueOrNull();
        if (callable instanceof PyFunction) {
            renames.put((PsiElement)callable, newName);
        }
    }
}

