/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePyFileProcessor
extends RenamePsiFileProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/rename/RenamePyFileProcessor", "canProcessElement"));
        }
        return element instanceof PyFile;
    }

    @Override
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        PyFile file = (PyFile)element;
        if (file.getName().equals("__init__.py")) {
            return file.getParent();
        }
        return element;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        ArrayList<PsiReference> results = new ArrayList<PsiReference>();
        for (PsiReference reference : super.findReferences(element)) {
            if (!RenamePyFileProcessor.isNotAliasedInImportElement(reference)) continue;
            results.add(reference);
        }
        ArrayList<PsiReference> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/rename/RenamePyFileProcessor", "findReferences"));
        }
        return arrayList;
    }

    @Override
    public void findCollisions(PsiElement element, String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result) {
        final String newFileName = FileUtil.getNameWithoutExtension((String)newName);
        if (!PyNames.isIdentifier(newFileName)) {
            ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>(result);
            for (UsageInfo usageInfo : usages) {
                final PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)usageInfo.getElement(), PyImportStatementBase.class);
                if (importStatement == null) continue;
                result.add((UsageInfo)new UnresolvableCollisionUsageInfo((PsiElement)importStatement, element){

                    @Override
                    public String getDescription() {
                        return "The name '" + newFileName + "' is not a valid Python identifier. Cannot update import statement in '" + importStatement.getContainingFile().getName() + "'";
                    }
                });
            }
        }
    }

    private static boolean isNotAliasedInImportElement(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/python/refactoring/rename/RenamePyFileProcessor", "isNotAliasedInImportElement"));
        }
        boolean include = true;
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results;
            for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                PsiElement resolved = result.getElement();
                if (!(resolved instanceof PyImportElement) || ((PyImportElement)resolved).getAsName() == null) continue;
                include = false;
                break;
            }
        }
        return include;
    }
}

