/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;

public abstract class RenamePyElementProcessor
extends RenamePsiElementProcessor {
    @Override
    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        PyElement container = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class);
        if (container instanceof PyFile) {
            PyTargetExpression conflictingVariable;
            PyFunction conflictingFunction;
            PyFile pyFile = (PyFile)container;
            PyClass conflictingClass = pyFile.findTopLevelClass(newName);
            if (conflictingClass != null) {
                conflicts.putValue((Object)conflictingClass, (Object)("A class named '" + newName + "' is already defined in " + pyFile.getName()));
            }
            if ((conflictingFunction = pyFile.findTopLevelFunction(newName)) != null) {
                conflicts.putValue((Object)conflictingFunction, (Object)("A function named '" + newName + "' is already defined in " + pyFile.getName()));
            }
            if ((conflictingVariable = pyFile.findTopLevelAttribute(newName)) != null) {
                conflicts.putValue((Object)conflictingFunction, (Object)("A variable named '" + newName + "' is already defined in " + pyFile.getName()));
            }
        } else if (container instanceof PyClass) {
            PyTargetExpression conflictingAttribute;
            PyFunction conflictingFunction;
            PyClass pyClass = (PyClass)container;
            PyClass conflictingClass = pyClass.findNestedClass(newName, true);
            if (conflictingClass != null) {
                conflicts.putValue((Object)conflictingClass, (Object)("A class named '" + newName + "' is already defined in class '" + pyClass.getName() + "'"));
            }
            if ((conflictingFunction = pyClass.findMethodByName(newName, true)) != null) {
                conflicts.putValue((Object)conflictingFunction, (Object)("A function named '" + newName + "' is already defined in class '" + pyClass.getName() + "'"));
            }
            if ((conflictingAttribute = pyClass.findClassAttribute(newName, true)) != null) {
                conflicts.putValue((Object)conflictingAttribute, (Object)("An attribute named '" + newName + "' is already defined in class '" + pyClass.getName() + "'"));
            }
        }
    }

    @Override
    public String getHelpID(PsiElement element) {
        return "python.reference.rename";
    }
}

