/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.refactoring.rename.RenamePyElementProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RenamePyClassProcessor
extends RenamePyElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/rename/RenamePyClassProcessor", "canProcessElement"));
        }
        return element instanceof PyClass;
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = enabled;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_CLASS;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_CLASS = enabled;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(final PsiElement element) {
        PyFunction initMethod;
        if (element instanceof PyClass && (initMethod = ((PyClass)element).findMethodByName("__init__", true)) != null) {
            final List<PsiReference> allRefs = Collections.synchronizedList(new ArrayList());
            allRefs.addAll(super.findReferences(element));
            ReferencesSearch.search((PsiElement)initMethod, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject())).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    if (psiReference.getCanonicalText().equals(((PyClass)element).getName())) {
                        allRefs.add(psiReference);
                    }
                    return true;
                }
            });
            List<PsiReference> list = allRefs;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/rename/RenamePyClassProcessor", "findReferences"));
            }
            return list;
        }
        Collection<PsiReference> collection = super.findReferences(element);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/rename/RenamePyClassProcessor", "findReferences"));
        }
        return collection;
    }
}

