/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.actions.CreatePackageAction;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveFileHandler
extends MoveFileHandler {
    private static final Key<PsiNamedElement> REFERENCED_ELEMENT = Key.create((String)"PY_REFERENCED_ELEMENT");
    private static final Key<String> ORIGINAL_FILE_LOCATION = Key.create((String)"PY_ORIGINAL_FILE_LOCATION");

    @Override
    public boolean canProcessElement(PsiFile element) {
        return element.getFileType() == PythonFileType.INSTANCE;
    }

    @Override
    public void prepareMovedFile(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
        if (file != null) {
            PsiDirectory root;
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                PyUtil.deletePycFiles(virtualFile.getPath());
            }
            Collection<VirtualFile> roots = PyUtil.getSourceRoots((PsiElement)file);
            for (root = moveDestination; root != null && !roots.contains(root.getVirtualFile()); root = root.getParentDirectory()) {
            }
            boolean searchForReferences = RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE;
            if (moveDestination != root && root != null && searchForReferences && !PyMoveFileHandler.probablyNamespacePackage(file, moveDestination, root)) {
                CreatePackageAction.createInitPyInHierarchy(moveDestination, root);
            }
            if (file instanceof PyFile) {
                PyMoveFileHandler.updateRelativeImportsInModule((PyFile)file);
            }
        }
    }

    private static void updateRelativeImportsInModule(@NotNull PyFile module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "updateRelativeImportsInModule"));
        }
        String originalLocation = (String)module.getUserData(ORIGINAL_FILE_LOCATION);
        if (originalLocation == null) {
            return;
        }
        module.putUserData(ORIGINAL_FILE_LOCATION, null);
        for (PyFromImportStatement statement : module.getFromImports()) {
            PsiElement replacementEnd;
            PsiFileSystemItem sourceElement;
            if (statement.getRelativeLevel() == 0 || (sourceElement = PyMoveFileHandler.resolveRelativeImportSourceFromModuleLocation(originalLocation, statement)) == null) continue;
            QualifiedName newName = QualifiedNameFinder.findShortestImportableQName(sourceElement);
            PsiElement fromKeyword = statement.getFirstChild();
            PsiElement firstDot = fromKeyword.getNextSibling().getNextSibling();
            assert (firstDot.getNode().getElementType() == PyTokenTypes.DOT);
            PsiWhiteSpace nextWhitespace = (PsiWhiteSpace)PsiTreeUtil.getNextSiblingOfType((PsiElement)firstDot, PsiWhiteSpace.class);
            PsiElement psiElement = replacementEnd = nextWhitespace == null ? statement.getLastChild() : nextWhitespace.getPrevSibling();
            if (replacementEnd != firstDot) {
                statement.deleteChildRange(firstDot.getNextSibling(), replacementEnd);
            }
            PyMoveFileHandler.replaceWithQualifiedExpression(firstDot, newName);
        }
    }

    @Nullable
    private static PsiFileSystemItem resolveRelativeImportSourceFromModuleLocation(@NotNull String moduleLocation, @NotNull PyFromImportStatement statement) {
        if (moduleLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleLocation", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "resolveRelativeImportSourceFromModuleLocation"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "resolveRelativeImportSourceFromModuleLocation"));
        }
        String relativeImportBasePath = VirtualFileManager.extractPath((String)moduleLocation);
        for (int level = 0; level < statement.getRelativeLevel(); ++level) {
            relativeImportBasePath = PathUtil.getParentPath((String)relativeImportBasePath);
        }
        if (!relativeImportBasePath.isEmpty()) {
            String relativePath;
            VirtualFile relativeImportBaseDir;
            String relativeImportBaseUrl = VirtualFileManager.constructUrl((String)VirtualFileManager.extractProtocol((String)moduleLocation), (String)relativeImportBasePath);
            VirtualFile sourceFile = relativeImportBaseDir = VirtualFileManager.getInstance().findFileByUrl(relativeImportBaseUrl);
            if (relativeImportBaseDir != null && relativeImportBaseDir.exists() && statement.getImportSource() != null && (sourceFile = relativeImportBaseDir.findFileByRelativePath(relativePath = statement.getImportSource().getText().replace('.', '/'))) == null) {
                sourceFile = relativeImportBaseDir.findFileByRelativePath(relativePath + ".py");
            }
            if (sourceFile != null) {
                PsiManager psiManager = statement.getManager();
                Object sourceElement = sourceFile.isDirectory() ? psiManager.findDirectory(sourceFile) : psiManager.findFile(sourceFile);
                return sourceElement;
            }
        }
        return null;
    }

    private static boolean probablyNamespacePackage(@NotNull PsiFile anchor, @NotNull PsiDirectory destination, @NotNull PsiDirectory root) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "probablyNamespacePackage"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "probablyNamespacePackage"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "probablyNamespacePackage"));
        }
        if (!LanguageLevel.forElement((PsiElement)anchor).isAtLeast(LanguageLevel.PYTHON33)) {
            return false;
        }
        while (destination != null && destination != root) {
            if (destination.findFile("__init__.py") != null) {
                return false;
            }
            destination = destination.getParent();
        }
        return true;
    }

    @Override
    public List<UsageInfo> findUsages(PsiFile file, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (file != null) {
            file.putUserData(ORIGINAL_FILE_LOCATION, (Object)file.getVirtualFile().getUrl());
            List<UsageInfo> usages = PyRefactoringUtil.findUsages((PsiNamedElement)file, false);
            for (UsageInfo usage : usages) {
                PsiElement element = usage.getElement();
                if (element == null) continue;
                element.putCopyableUserData(REFERENCED_ELEMENT, (Object)file);
            }
            return usages;
        }
        return null;
    }

    @Override
    public void retargetUsages(List<UsageInfo> usages, Map<PsiElement, PsiElement> oldToNewMap) {
        HashSet<PsiFile> updatedFiles = new HashSet<PsiFile>();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            PsiNamedElement newElement = (PsiNamedElement)element.getCopyableUserData(REFERENCED_ELEMENT);
            element.putCopyableUserData(REFERENCED_ELEMENT, null);
            if (newElement == null) continue;
            PsiFile file = element.getContainingFile();
            PyImportStatementBase importStmt = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class);
            if (importStmt != null) {
                updatedFiles.add(file);
                PyClassRefactoringUtil.updateImportOfElement(importStmt, newElement);
                if (importStmt instanceof PyFromImportStatement && PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class) != null) continue;
                QualifiedName newElementName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)newElement, element);
                PyMoveFileHandler.removeLeadingDots(element);
                PyMoveFileHandler.replaceWithQualifiedExpression(element, newElementName);
                continue;
            }
            if (!(element instanceof PyReferenceExpression)) continue;
            updatedFiles.add(file);
            if (((PyReferenceExpression)element).isQualified()) {
                QualifiedName newQualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)newElement, element);
                PyMoveFileHandler.replaceWithQualifiedExpression(element, newQualifiedName);
                continue;
            }
            QualifiedName newName = QualifiedName.fromComponents((String[])new String[]{PyClassRefactoringUtil.getOriginalName(newElement)});
            PsiElement replaced = PyMoveFileHandler.replaceWithQualifiedExpression(element, newName);
            PyClassRefactoringUtil.insertImport(replaced, newElement, null);
        }
        if (!updatedFiles.isEmpty()) {
            PyImportOptimizer optimizer = new PyImportOptimizer();
            for (PsiFile file : updatedFiles) {
                boolean injectedFragment = InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file);
                if (injectedFragment) continue;
                optimizer.processFile(file).run();
            }
        }
    }

    @NotNull
    private static PsiElement replaceWithQualifiedExpression(@NotNull PsiElement oldElement, @Nullable QualifiedName newElementName) {
        PyElementGenerator generator;
        PyExpression newElement;
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "replaceWithQualifiedExpression"));
        }
        if (newElementName != null && PyClassRefactoringUtil.isValidQualifiedName(newElementName) && (newElement = (generator = PyElementGenerator.getInstance(oldElement.getProject())).createExpressionFromText(LanguageLevel.forElement(oldElement), newElementName.toString())) != null) {
            PsiElement psiElement = oldElement.replace((PsiElement)newElement);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "replaceWithQualifiedExpression"));
            }
            return psiElement;
        }
        PsiElement psiElement = oldElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "replaceWithQualifiedExpression"));
        }
        return psiElement;
    }

    private static void removeLeadingDots(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/move/PyMoveFileHandler", "removeLeadingDots"));
        }
        PsiElement lastDot = null;
        PsiElement firstDot = null;
        for (PsiElement prev = element.getPrevSibling(); prev != null && prev.getNode().getElementType() == PyTokenTypes.DOT; prev = prev.getPrevSibling()) {
            if (lastDot == null) {
                lastDot = prev;
            }
            firstDot = prev;
        }
        if (lastDot != null && firstDot != null) {
            element.getParent().deleteChildRange(firstDot, lastDot);
        }
    }

    @Override
    public void updateMovedFile(PsiFile file) throws IncorrectOperationException {
    }
}

