/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class PyMoveClassOrFunctionProcessor
extends BaseRefactoringProcessor {
    public static final String REFACTORING_NAME = PyBundle.message("refactoring.move.class.or.function", new Object[0]);
    private PsiNamedElement[] myElements;
    private String myDestination;

    public PyMoveClassOrFunctionProcessor(Project project, PsiNamedElement[] elements, String destination, boolean previewUsages) {
        super(project);
        assert (elements.length > 0);
        this.myElements = elements;
        this.myDestination = destination;
        this.setPreviewUsages(previewUsages);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiNamedElement[] psiNamedElementArray = PyMoveClassOrFunctionProcessor.this.myElements;
                if (psiNamedElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor$1", "getElements"));
                }
                return psiNamedElementArray;
            }

            public String getProcessedElementsHeader() {
                return REFACTORING_NAME;
            }
        };
        if (usageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "createUsageViewDescriptor"));
        }
        return usageViewDescriptorAdapter;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiNamedElement element : this.myElements) {
            usages.addAll(PyRefactoringUtil.findUsages(element, false));
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected void performRefactoring(final UsageInfo[] usages) {
        CommandProcessor.getInstance().executeCommand(this.myElements[0].getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PyFile destination = PyUtil.getOrCreateFile(PyMoveClassOrFunctionProcessor.this.myDestination, PyMoveClassOrFunctionProcessor.this.myProject);
                        CommonRefactoringUtil.checkReadOnlyStatus((Project)PyMoveClassOrFunctionProcessor.this.myProject, (PsiElement)destination);
                        for (PsiNamedElement e : PyMoveClassOrFunctionProcessor.this.myElements) {
                            CommonRefactoringUtil.checkReadOnlyStatus((Project)PyMoveClassOrFunctionProcessor.this.myProject, (PsiElement)e);
                            assert (e instanceof PyClass || e instanceof PyFunction);
                            if (e instanceof PyClass && destination.findTopLevelClass(e.getName()) != null) {
                                throw new IncorrectOperationException(PyBundle.message("refactoring.move.class.or.function.error.destination.file.contains.class.$0", e.getName()));
                            }
                            if (e instanceof PyFunction && destination.findTopLevelFunction(e.getName()) != null) {
                                throw new IncorrectOperationException(PyBundle.message("refactoring.move.class.or.function.error.destination.file.contains.function.$0", e.getName()));
                            }
                            PyMoveClassOrFunctionProcessor.checkValidImportableFile(destination, e.getContainingFile().getVirtualFile());
                            PyMoveClassOrFunctionProcessor.checkValidImportableFile((PsiElement)e, destination.getVirtualFile());
                        }
                        for (PsiNamedElement oldElement : PyMoveClassOrFunctionProcessor.this.myElements) {
                            PyMoveClassOrFunctionProcessor.moveElement(oldElement, Arrays.asList(usages), destination);
                        }
                    }
                });
            }
        }, REFACTORING_NAME, null);
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = REFACTORING_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "getCommandName"));
        }
        return string;
    }

    private static void moveElement(@NotNull PsiNamedElement element, @NotNull Collection<UsageInfo> usages, @NotNull PyFile destination) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "moveElement"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "moveElement"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "moveElement"));
        }
        PsiFile file = element.getContainingFile();
        PyClassRefactoringUtil.rememberNamedReferences((PsiElement)element, new String[0]);
        PsiNamedElement newElement = PyMoveClassOrFunctionProcessor.addToFile(element, destination, usages);
        for (UsageInfo usage : usages) {
            PsiElement usageElement = usage.getElement();
            if (usageElement == null) continue;
            PyMoveClassOrFunctionProcessor.updateUsage(usageElement, element, newElement);
        }
        PyClassRefactoringUtil.restoreNamedReferences((PsiElement)newElement, (PsiElement)element);
        element.delete();
        if (file != null) {
            PyClassRefactoringUtil.optimizeImports(file);
        }
    }

    private static PsiNamedElement addToFile(@NotNull PsiNamedElement element, final @NotNull PyFile destination, @NotNull Collection<UsageInfo> usages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "addToFile"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "addToFile"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "addToFile"));
        }
        ArrayList<PsiElement> topLevelAtDestination = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            PsiElement topLevel;
            PsiElement e = usage.getElement();
            if (e == null || ScopeUtil.getScopeOwner(e) != destination || PyImportStatementNavigator.getImportStatementByElement(e) != null || (topLevel = PsiTreeUtil.findFirstParent((PsiElement)e, (Condition)new Condition<PsiElement>(){

                public boolean value(PsiElement element) {
                    return element.getParent() == destination;
                }
            })) == null) continue;
            topLevelAtDestination.add(topLevel);
        }
        if (topLevelAtDestination.isEmpty()) {
            return (PsiNamedElement)destination.add((PsiElement)element);
        }
        Collections.sort(topLevelAtDestination, new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement e1, PsiElement e2) {
                return PsiUtilCore.compareElementsByPosition((PsiElement)e1, (PsiElement)e2);
            }
        });
        PsiElement firstUsage = (PsiElement)topLevelAtDestination.get(0);
        return (PsiNamedElement)destination.addBefore((PsiElement)element, firstUsage);
    }

    private static void updateUsage(@NotNull PsiElement usage, @NotNull PsiNamedElement oldElement, @NotNull PsiNamedElement newElement) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "updateUsage"));
        }
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "updateUsage"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "updateUsage"));
        }
        if (usage instanceof PyQualifiedExpression) {
            PyQualifiedExpression expr = (PyQualifiedExpression)usage;
            if (oldElement instanceof PyClass && "__init__".equals(expr.getName())) {
                return;
            }
            if (expr.isQualified()) {
                PyElementGenerator generator = PyElementGenerator.getInstance(expr.getProject());
                PyExpression generated = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expr), expr.getName());
                PsiElement newExpr = expr.replace((PsiElement)generated);
                PyClassRefactoringUtil.insertImport(newExpr, newElement, null, true);
            }
        }
        if (usage instanceof PyStringLiteralExpression) {
            for (PsiReference ref : usage.getReferences()) {
                if (!ref.isReferenceTo((PsiElement)oldElement)) continue;
                ref.bindToElement((PsiElement)newElement);
            }
        } else {
            PsiFile usageFile;
            PyImportStatementBase importStmt = PyImportStatementNavigator.getImportStatementByElement(usage);
            if (importStmt != null) {
                PyClassRefactoringUtil.updateImportOfElement(importStmt, newElement);
            }
            if ((usageFile = usage.getContainingFile()) == oldElement.getContainingFile() && !PsiTreeUtil.isAncestor((PsiElement)oldElement, (PsiElement)usage, (boolean)false)) {
                PyClassRefactoringUtil.insertImport((PsiElement)oldElement, newElement);
            }
            if (PyMoveClassOrFunctionProcessor.resolvesToLocalStarImport(usage)) {
                PyClassRefactoringUtil.insertImport(usage, newElement);
                if (usageFile != null) {
                    PyClassRefactoringUtil.optimizeImports(usageFile);
                }
            }
        }
    }

    private static boolean resolvesToLocalStarImport(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionProcessor", "resolvesToLocalStarImport"));
        }
        PsiReference ref = element.getReference();
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        if (ref instanceof PsiPolyVariantReference) {
            for (ResolveResult result : ((PsiPolyVariantReference)ref).multiResolve(false)) {
                resolvedElements.add(result.getElement());
            }
        } else if (ref != null) {
            resolvedElements.add(ref.resolve());
        }
        if ((containingFile = element.getContainingFile()) != null) {
            for (PsiElement resolved : resolvedElements) {
                if (!(resolved instanceof PyStarImportElement) || resolved.getContainingFile() != containingFile) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkValidImportableFile(PsiElement anchor, VirtualFile file) {
        QualifiedName qName = QualifiedNameFinder.findShortestImportableQName(anchor, file);
        if (!PyClassRefactoringUtil.isValidQualifiedName(qName)) {
            throw new IncorrectOperationException(PyBundle.message("refactoring.move.class.or.function.error.cannot.use.module.name.$0", qName));
        }
    }
}

