/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.refactoring.move.PyMoveClassOrFunctionPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveClassOrFunctionDialog
extends RefactoringDialog {
    private static PyMoveClassOrFunctionDialog ourInstanceToReplace = null;
    private PyMoveClassOrFunctionPanel myPanel;

    public static PyMoveClassOrFunctionDialog getInstance(@NotNull Project project, @NotNull PsiNamedElement[] elements, @Nullable String destination) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionDialog", "getInstance"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionDialog", "getInstance"));
        }
        return ourInstanceToReplace != null ? ourInstanceToReplace : new PyMoveClassOrFunctionDialog(project, elements, destination);
    }

    public static void setInstanceToReplace(@NotNull PyMoveClassOrFunctionDialog instanceToReplace) {
        if (instanceToReplace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceToReplace", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionDialog", "setInstanceToReplace"));
        }
        ourInstanceToReplace = instanceToReplace;
    }

    protected PyMoveClassOrFunctionDialog(@NotNull Project project, @NotNull PsiNamedElement[] elements, @Nullable String destination) {
        PsiNamedElement e;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionDialog", "<init>"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionDialog", "<init>"));
        }
        super(project, true);
        assert (elements.length > 0);
        String moveText = elements.length == 1 ? ((e = elements[0]) instanceof PyClass ? PyBundle.message("refactoring.move.class.$0", ((PyClass)e).getQualifiedName()) : PyBundle.message("refactoring.move.function.$0", e.getName())) : PyBundle.message("refactoring.move.selected.elements", new Object[0]);
        if (destination == null) {
            destination = PyMoveClassOrFunctionDialog.getContainingFileName((PsiElement)elements[0]);
        }
        this.myPanel = new PyMoveClassOrFunctionPanel(moveText, destination);
        this.setTitle(PyBundle.message("refactoring.move.class.or.function.dialog.title", new Object[0]));
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        descriptor.withTreeRootVisible(true);
        this.myPanel.getBrowseTargetFileButton().addBrowseFolderListener(PyBundle.message("refactoring.move.class.or.function.choose.destination.file.title", new Object[0]), null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    protected void doAction() {
        this.close(0);
    }

    protected String getHelpId() {
        return "python.reference.moveClass";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getBrowseTargetFileButton().getTextField();
    }

    public String getTargetPath() {
        return this.myPanel.getBrowseTargetFileButton().getText();
    }

    private static String getContainingFileName(PsiElement element) {
        VirtualFile file = element.getContainingFile().getVirtualFile();
        if (file != null) {
            return FileUtil.toSystemDependentName((String)file.getPath());
        }
        return "";
    }
}

