/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.move.PyMoveClassOrFunctionDialog;
import com.jetbrains.python.refactoring.move.PyMoveClassOrFunctionProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveClassOrFunctionDelegate
extends MoveHandlerDelegate {
    @Override
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        for (PsiElement element : elements) {
            if ((element instanceof PyClass || element instanceof PyFunction) && PyUtil.isTopLevel(element)) continue;
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    @Override
    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        VirtualFile virtualFile;
        PsiNamedElement[] elementsToMove = new PsiNamedElement[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            PsiNamedElement e = PyMoveClassOrFunctionDelegate.getElementToMove(elements[i]);
            if (e == null) {
                return;
            }
            elementsToMove[i] = e;
        }
        String initialDestination = null;
        if (targetContainer instanceof PsiFile && (virtualFile = ((PsiFile)targetContainer).getVirtualFile()) != null) {
            initialDestination = FileUtil.toSystemDependentName((String)virtualFile.getPath());
        }
        PyMoveClassOrFunctionDialog dialog = PyMoveClassOrFunctionDialog.getInstance(project, elementsToMove, initialDestination);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        String destination = dialog.getTargetPath();
        boolean previewUsages = dialog.isPreviewUsages();
        try {
            PyMoveClassOrFunctionProcessor processor = new PyMoveClassOrFunctionProcessor(project, elementsToMove, destination, previewUsages);
            processor.run();
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)project);
        }
    }

    @Override
    public boolean tryToMove(@NotNull PsiElement element, @NotNull Project project, @Nullable DataContext dataContext, @Nullable PsiReference reference, @Nullable Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionDelegate", "tryToMove"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionDelegate", "tryToMove"));
        }
        PsiNamedElement e = PyMoveClassOrFunctionDelegate.getElementToMove(element);
        if (e instanceof PyClass || e instanceof PyFunction) {
            if (PyUtil.isTopLevel((PsiElement)e)) {
                PsiFile targetContainer = null;
                if (editor != null) {
                    Document document = editor.getDocument();
                    targetContainer = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                }
                this.doMove(project, new PsiElement[]{e}, (PsiElement)targetContainer, null);
            } else {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyBundle.message("refactoring.move.class.or.function.error.selection", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), null);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiNamedElement getElementToMove(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/move/PyMoveClassOrFunctionDelegate", "getElementToMove"));
        }
        if (element instanceof PsiNamedElement) {
            return (PsiNamedElement)element;
        }
        return null;
    }
}

