/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.invertBoolean;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.invertBoolean.PyInvertBooleanHandler;
import com.jetbrains.python.refactoring.invertBoolean.PyInvertBooleanUsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyInvertBooleanProcessor
extends BaseRefactoringProcessor {
    private PsiElement myElement;
    private String myNewName;
    private final RenameProcessor myRenameProcessor;
    private final Map<UsageInfo, SmartPsiElementPointer> myToInvert;
    private final SmartPointerManager mySmartPointerManager;

    public PyInvertBooleanProcessor(@NotNull PsiElement namedElement, @NotNull String newName) {
        if (namedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedElement", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "<init>"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "<init>"));
        }
        super(namedElement.getProject());
        this.myToInvert = new HashMap();
        this.myElement = namedElement;
        this.myNewName = newName;
        this.mySmartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myRenameProcessor = new RenameProcessor(this.myProject, namedElement, newName, false, false);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        PyInvertBooleanUsageViewDescriptor pyInvertBooleanUsageViewDescriptor = new PyInvertBooleanUsageViewDescriptor(this.myElement);
        if (pyInvertBooleanUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "createUsageViewDescriptor"));
        }
        return pyInvertBooleanUsageViewDescriptor;
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        if (!this.myNewName.equals(this.myElement instanceof PsiNamedElement ? ((PsiNamedElement)this.myElement).getName() : this.myElement.getText())) {
            if (this.myRenameProcessor.preprocessUsages(refUsages)) {
                this.prepareSuccessful();
                return true;
            }
            return false;
        }
        this.prepareSuccessful();
        return true;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<SmartPsiElementPointer> toInvert = new ArrayList<SmartPsiElementPointer>();
        this.addRefsToInvert(toInvert, this.myElement);
        UsageInfo[] renameUsages = this.myRenameProcessor.findUsages();
        HashMap expressionsToUsages = new HashMap();
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (UsageInfo renameUsage : renameUsages) {
            expressionsToUsages.put(renameUsage.getElement(), renameUsage);
            result.add(renameUsage);
        }
        for (SmartPsiElementPointer pointer : toInvert) {
            PyExpression expression = (PyExpression)pointer.getElement();
            if (!expressionsToUsages.containsKey(expression) && expression != null) {
                UsageInfo usageInfo = new UsageInfo((PsiElement)expression);
                expressionsToUsages.put(expression, usageInfo);
                result.add(usageInfo);
                this.myToInvert.put(usageInfo, pointer);
                continue;
            }
            this.myToInvert.put((UsageInfo)expressionsToUsages.get(expression), pointer);
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    private void addRefsToInvert(@NotNull List<SmartPsiElementPointer> toInvert, @NotNull PsiElement psiElement) {
        PyExpression defaultValue;
        if (toInvert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toInvert", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "addRefsToInvert"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "addRefsToInvert"));
        }
        Collection refs = ReferencesSearch.search((PsiElement)psiElement).findAll();
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            if (element instanceof PyTargetExpression) {
                PyExpression value;
                PyTargetExpression target = (PyTargetExpression)element;
                PyAssignmentStatement parent = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)target, PyAssignmentStatement.class);
                if (parent == null || parent.getTargets().length != 1 || (value = parent.getAssignedValue()) == null) continue;
                toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)value));
                continue;
            }
            if (element.getParent() instanceof PyPrefixExpression) {
                toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer(element.getParent()));
                continue;
            }
            if (!(element instanceof PyReferenceExpression)) continue;
            PyReferenceExpression refExpr = (PyReferenceExpression)element;
            toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)refExpr));
        }
        if (psiElement instanceof PyNamedParameter && (defaultValue = ((PyNamedParameter)psiElement).getDefaultValue()) != null) {
            toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)defaultValue));
        }
    }

    @NotNull
    private static UsageInfo[] extractUsagesForElement(@NotNull PsiElement element, @NotNull UsageInfo[] usages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "extractUsagesForElement"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "extractUsagesForElement"));
        }
        ArrayList<MoveRenameUsageInfo> extractedUsages = new ArrayList<MoveRenameUsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            MoveRenameUsageInfo usageInfo;
            if (!(usage instanceof MoveRenameUsageInfo) || !element.equals((usageInfo = (MoveRenameUsageInfo)usage).getReferencedElement())) continue;
            extractedUsages.add(usageInfo);
        }
        UsageInfo[] usageInfoArray = extractedUsages.toArray(new UsageInfo[extractedUsages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "extractUsagesForElement"));
        }
        return usageInfoArray;
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        for (PsiElement element : this.myRenameProcessor.getElements()) {
            try {
                RenameUtil.doRename(element, this.myRenameProcessor.getNewName(element), PyInvertBooleanProcessor.extractUsagesForElement(element, usages), this.myProject, null);
            }
            catch (IncorrectOperationException e) {
                RenameUtil.showErrorMessage(e, element, this.myProject);
                return;
            }
        }
        for (UsageInfo usage : usages) {
            PsiElement expression;
            SmartPsiElementPointer pointerToInvert = this.myToInvert.get(usage);
            if (pointerToInvert == null || (expression = pointerToInvert.getElement()) == null || PsiTreeUtil.getParentOfType((PsiElement)expression, PyImportStatementBase.class, (boolean)false) != null) continue;
            PyExpression replacement = this.invertExpression(expression);
            expression.replace((PsiElement)replacement);
        }
    }

    @NotNull
    private PyExpression invertExpression(@NotNull PsiElement expression) {
        PyExpression operand;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "invertExpression"));
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(this.myProject);
        if (expression instanceof PyBoolLiteralExpression) {
            String value = ((PyBoolLiteralExpression)expression).getValue() ? "False" : "True";
            PyExpression pyExpression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(expression), value);
            if (pyExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "invertExpression"));
            }
            return pyExpression;
        }
        if (expression instanceof PyReferenceExpression && ("False".equals(expression.getText()) || "True".equals(expression.getText()))) {
            String value = "True".equals(expression.getText()) ? "False" : "True";
            PyExpression pyExpression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(expression), value);
            if (pyExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "invertExpression"));
            }
            return pyExpression;
        }
        if (expression instanceof PyPrefixExpression && ((PyPrefixExpression)expression).getOperator() == PyTokenTypes.NOT_KEYWORD && (operand = ((PyPrefixExpression)expression).getOperand()) != null) {
            PyExpression pyExpression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(expression), operand.getText());
            if (pyExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "invertExpression"));
            }
            return pyExpression;
        }
        PyExpression pyExpression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(expression), "not " + expression.getText());
        if (pyExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanProcessor", "invertExpression"));
        }
        return pyExpression;
    }

    @Override
    protected String getCommandName() {
        return PyInvertBooleanHandler.REFACTORING_NAME;
    }
}

