/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.invertBoolean;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.invertBoolean.PyInvertBooleanHandler;
import org.jetbrains.annotations.NotNull;

public class PyInvertBooleanAction
extends BaseRefactoringAction {
    @Override
    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    @Override
    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanAction", "isEnabledOnElements"));
        }
        if (elements.length == 1) {
            return PyInvertBooleanAction.isApplicable(elements[0], elements[0].getContainingFile());
        }
        return false;
    }

    private static boolean isApplicable(@NotNull PsiElement element, @NotNull PsiFile file) {
        PyExpression defaultValue;
        PyAssignmentStatement assignmentStatement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanAction", "isApplicable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanAction", "isApplicable"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInLibraryClasses(virtualFile)) {
            return false;
        }
        if (element instanceof PyTargetExpression && (assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class)) != null) {
            PyExpression assignedValue = assignmentStatement.getAssignedValue();
            if (assignedValue == null) {
                return false;
            }
            String name = assignedValue.getText();
            return name != null && ("True".equals(name) || "False".equals(name));
        }
        if (element instanceof PyNamedParameter && (defaultValue = ((PyNamedParameter)element).getDefaultValue()) instanceof PyBoolLiteralExpression) {
            return true;
        }
        return element.getParent() instanceof PyBoolLiteralExpression;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanAction", "isAvailableOnElementInEditorAndFile"));
        }
        return PyInvertBooleanAction.isApplicable(element, element.getContainingFile());
    }

    @Override
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanAction", "getHandler"));
        }
        return new PyInvertBooleanHandler();
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return language.isKindOf((Language)PythonLanguage.getInstance());
    }
}

