/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.parameter;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.variable.VariableValidator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntroduceParameterHandler
extends IntroduceHandler {
    public PyIntroduceParameterHandler() {
        super(new VariableValidator(), PyBundle.message("refactoring.introduce.parameter.dialog.title", new Object[0]));
    }

    @Override
    protected String getHelpId() {
        return "python.reference.introduceParameter";
    }

    @Override
    @Nullable
    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/parameter/PyIntroduceParameterHandler", "addDeclaration"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/python/refactoring/introduce/parameter/PyIntroduceParameterHandler", "addDeclaration"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/jetbrains/python/refactoring/introduce/parameter/PyIntroduceParameterHandler", "addDeclaration"));
        }
        return this.doIntroduceParameter(expression, (PyAssignmentStatement)declaration);
    }

    public PsiElement doIntroduceParameter(PsiElement expression, PyAssignmentStatement declaration) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class);
        if (function != null && declaration != null) {
            PyParameterList parameterList = function.getParameterList();
            parameterList.addParameter(PyElementGenerator.getInstance(function.getProject()).createParameter(declaration.getText()));
            CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(function);
            return parameterList.findParameterByName(declaration.getTargets()[0].getText());
        }
        return null;
    }

    @Override
    @Nullable
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
    }

    @Override
    protected boolean isValidIntroduceContext(PsiElement element) {
        if (element != null) {
            if (!PyIntroduceParameterHandler.isValidPlace(element)) {
                return false;
            }
            return PyIntroduceParameterHandler.isNotDeclared(element);
        }
        return false;
    }

    private static boolean isNotDeclared(PsiElement element) {
        final ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(element);
        final boolean[] isValid = new boolean[]{true};
        if (scopeOwner != null) {
            String name;
            String string = name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : element.getText();
            if (name != null && ControlFlowCache.getScope(scopeOwner).containsDeclaration(name)) {
                return false;
            }
            new PyRecursiveElementVisitor(){

                @Override
                public void visitPyReferenceExpression(PyReferenceExpression node) {
                    super.visitPyReferenceExpression(node);
                    String name = node.getName();
                    if (name != null && ControlFlowCache.getScope(scopeOwner).containsDeclaration(name)) {
                        isValid[0] = false;
                    }
                }
            }.visitElement(element);
        }
        return !PyIntroduceParameterHandler.isResolvedToParameter(element) && isValid[0];
    }

    private static boolean isValidPlace(PsiElement element) {
        PyExpression target;
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        PyForPart forPart = (PyForPart)PsiTreeUtil.getParentOfType((PsiElement)element, PyForPart.class);
        if (forPart != null && (target = forPart.getTarget()) instanceof PyTargetExpression && element.getText().equals(target.getName())) {
            return false;
        }
        PyStatement nonlocalStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyNonlocalStatement.class, PyGlobalStatement.class});
        PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatementList.class);
        PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatement.class);
        return nonlocalStatement == null && importStatement == null && statementList != null && function != null;
    }

    private static boolean isResolvedToParameter(PsiElement element) {
        while (element instanceof PyReferenceExpression) {
            PsiReference reference = element.getReference();
            if (reference != null && reference.resolve() instanceof PyNamedParameter) {
                return true;
            }
            element = ((PyReferenceExpression)element).getQualifier();
        }
        return false;
    }

    @Override
    protected void performInplaceIntroduce(IntroduceOperation operation) {
        PsiElement statement = this.performRefactoring(operation);
        if (statement instanceof PyNamedParameter) {
            List<PsiElement> occurrences = operation.getOccurrences();
            PsiElement occurrence = PyIntroduceParameterHandler.findOccurrenceUnderCaret(occurrences, operation.getEditor());
            PsiElement elementForCaret = occurrence != null ? occurrence : statement;
            operation.getEditor().getCaretModel().moveToOffset(elementForCaret.getTextRange().getStartOffset());
            PyInplaceParameterIntroducer introducer = new PyInplaceParameterIntroducer((PyNamedParameter)statement, operation, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.python.introduce.parameter";
    }

    private static class PyInplaceParameterIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyNamedParameter myTarget;

        public PyInplaceParameterIntroducer(PyNamedParameter target, IntroduceOperation operation, List<PsiElement> occurrences) {
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), "Introduce Parameter", occurrences.toArray(new PsiElement[occurrences.size()]), null);
            this.myTarget = target;
        }

        @Override
        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }
    }
}

