/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.field;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.field.IntroduceFieldValidator;
import com.jetbrains.python.refactoring.introduce.field.PyIntroduceFieldPanel;
import com.jetbrains.python.refactoring.introduce.variable.PyIntroduceVariableHandler;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntroduceFieldHandler
extends IntroduceHandler {
    public PyIntroduceFieldHandler() {
        super(new IntroduceFieldValidator(), RefactoringBundle.message((String)"introduce.field.title"));
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler", "invoke"));
        }
        IntroduceOperation operation = new IntroduceOperation(project, editor, file, null);
        operation.addAvailableInitPlace(IntroduceHandler.InitPlace.CONSTRUCTOR);
        if (PyIntroduceFieldHandler.isTestClass(file, editor)) {
            operation.addAvailableInitPlace(IntroduceHandler.InitPlace.SET_UP);
        }
        this.performAction(operation);
    }

    private static boolean isTestClass(PsiFile file, Editor editor) {
        PyClass clazz;
        PsiElement element1 = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
        } else {
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (lineNumber >= 0 && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
            }
        }
        return element1 != null && (clazz = PyUtil.getContainingClassOrSelf(element1)) != null && PythonUnitTestUtil.isTestCaseClass(clazz);
    }

    @Override
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        if (operation.getInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD) {
            return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
        }
        return super.replaceExpression(expression, newExpression, operation);
    }

    @Override
    protected boolean checkEnabled(IntroduceOperation operation) {
        if (PyUtil.getContainingClassOrSelf(operation.getElement()) == null) {
            CommonRefactoringUtil.showErrorHint((Project)operation.getProject(), (Editor)operation.getEditor(), (String)"Cannot introduce field: not in class", (String)this.myDialogTitle, (String)this.getHelpId());
            return false;
        }
        if (PyIntroduceFieldHandler.dependsOnLocalScopeValues(operation.getElement())) {
            operation.removeAvailableInitPlace(IntroduceHandler.InitPlace.CONSTRUCTOR);
            operation.removeAvailableInitPlace(IntroduceHandler.InitPlace.SET_UP);
        }
        return true;
    }

    private static boolean dependsOnLocalScopeValues(PsiElement initializer) {
        ScopeOwner scope = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)initializer, ScopeOwner.class);
        ResolvingVisitor visitor = new ResolvingVisitor(scope);
        initializer.accept((PsiElementVisitor)visitor);
        return visitor.hasLocalScopeDependencies;
    }

    @Override
    @Nullable
    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler", "addDeclaration"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler", "addDeclaration"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler", "addDeclaration"));
        }
        PsiElement expr = expression instanceof PyClass ? expression : expression.getParent();
        PyClass anchor = PyUtil.getContainingClassOrSelf(expr);
        assert (anchor instanceof PyClass);
        PyClass clazz = anchor;
        Project project = anchor.getProject();
        if (operation.getInitPlace() == IntroduceHandler.InitPlace.CONSTRUCTOR && !PyIntroduceFieldHandler.inConstructor(expression)) {
            return AddFieldQuickFix.addFieldToInit(project, clazz, "", new AddFieldDeclaration(declaration));
        }
        if (operation.getInitPlace() == IntroduceHandler.InitPlace.SET_UP) {
            return PyIntroduceFieldHandler.addFieldToSetUp(clazz, new AddFieldDeclaration(declaration));
        }
        return PyIntroduceVariableHandler.doIntroduceVariable(expression, declaration, operation.getOccurrences(), operation.isReplaceAll());
    }

    private static boolean inConstructor(@NotNull PsiElement expression) {
        PyFunction init;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler", "inConstructor"));
        }
        PsiElement expr = expression instanceof PyClass ? expression : expression.getParent();
        PyClass clazz = PyUtil.getContainingClassOrSelf(expr);
        PsiElement current = PyUtil.getConcealingParent(expression);
        return clazz != null && current != null && current instanceof PyFunction && current == (init = clazz.findMethodByName("__init__", false));
    }

    @Nullable
    private static PsiElement addFieldToSetUp(PyClass clazz, Function<String, PyStatement> callback) {
        PyFunction init = clazz.findMethodByName("setUp", false);
        if (init != null) {
            return AddFieldQuickFix.appendToMethod(init, callback);
        }
        PyFunctionBuilder builder = new PyFunctionBuilder("setUp");
        builder.parameter("self");
        PyFunction setUp = builder.buildFunction(clazz.getProject(), LanguageLevel.getDefault());
        PyStatementList statements = clazz.getStatementList();
        PsiElement anchor = statements.getFirstChild();
        setUp = (PyFunction)statements.addBefore(setUp, anchor);
        return AddFieldQuickFix.appendToMethod(setUp, callback);
    }

    @Override
    protected List<PsiElement> getOccurrences(PsiElement element, @NotNull PyExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler", "getOccurrences"));
        }
        if (PyIntroduceFieldHandler.isAssignedLocalVariable(element)) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            Collection references = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)function)).findAll();
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (PsiReference reference : references) {
                PsiElement refElement = reference.getElement();
                if (refElement == element) continue;
                result.add(refElement);
            }
            return result;
        }
        return super.getOccurrences(element, expression);
    }

    @Override
    protected PyExpression createExpression(Project project, String name, PsiElement declaration) {
        String text = declaration.getText();
        String self_name = text.substring(0, text.indexOf(46));
        return PyElementGenerator.getInstance(project).createExpressionFromText(self_name + "." + name);
    }

    @Override
    protected PyAssignmentStatement createDeclaration(Project project, String assignmentText, PsiElement anchor) {
        PyFunction container = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyFunction.class);
        String selfName = PyUtil.getFirstParameterName(container);
        LanguageLevel langLevel = LanguageLevel.forElement(anchor);
        return PyElementGenerator.getInstance(project).createFromText(langLevel, PyAssignmentStatement.class, selfName + "." + assignmentText);
    }

    @Override
    protected void postRefactoring(PsiElement element) {
        if (PyIntroduceFieldHandler.isAssignedLocalVariable(element)) {
            element.getParent().delete();
        }
    }

    private static boolean isAssignedLocalVariable(PsiElement element) {
        PyAssignmentStatement stmt;
        return element instanceof PyTargetExpression && element.getParent() instanceof PyAssignmentStatement && PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class) != null && (stmt = (PyAssignmentStatement)element.getParent()).getTargets().length == 1;
    }

    @Override
    protected String getHelpId() {
        return "python.reference.introduceField";
    }

    @Override
    protected boolean checkIntroduceContext(PsiFile file, Editor editor, PsiElement element) {
        if (element != null && PyIntroduceFieldHandler.isInStaticMethod(element)) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor, (String)"Introduce Field refactoring cannot be used in static methods", (String)RefactoringBundle.message((String)"introduce.field.title"), (String)"refactoring.extractMethod");
            return false;
        }
        return super.checkIntroduceContext(file, editor, element);
    }

    private static boolean isInStaticMethod(PsiElement element) {
        PyFunction containingMethod = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
        if (containingMethod != null) {
            PyFunction.Modifier modifier = containingMethod.getModifier();
            return modifier == PyFunction.Modifier.STATICMETHOD;
        }
        return false;
    }

    @Override
    protected boolean isValidIntroduceContext(PsiElement element) {
        return super.isValidIntroduceContext(element) && PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class}) != null && PsiTreeUtil.getParentOfType((PsiElement)element, PyDecoratorList.class) == null && !PyIntroduceFieldHandler.isInStaticMethod(element);
    }

    @Override
    protected void performInplaceIntroduce(IntroduceOperation operation) {
        PsiElement statement = this.performRefactoring(operation);
        if (statement instanceof PyAssignmentStatement) {
            List<PsiElement> occurrences = operation.getOccurrences();
            PsiElement occurrence = PyIntroduceFieldHandler.findOccurrenceUnderCaret(occurrences, operation.getEditor());
            PyTargetExpression target = (PyTargetExpression)((PyAssignmentStatement)statement).getTargets()[0];
            PyIntroduceFieldHandler.putCaretOnFieldName(operation.getEditor(), (PsiElement)(occurrence != null ? occurrence : target));
            PyInplaceFieldIntroducer introducer = new PyInplaceFieldIntroducer(target, operation, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    private static void putCaretOnFieldName(Editor editor, PsiElement occurrence) {
        ASTNode nameElement;
        PyQualifiedExpression qExpr = (PyQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)occurrence, PyQualifiedExpression.class, (boolean)false);
        if (qExpr != null && !qExpr.isQualified()) {
            qExpr = (PyQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)qExpr, PyQualifiedExpression.class);
        }
        if (qExpr != null && (nameElement = qExpr.getNameElement()) != null) {
            int offset = nameElement.getTextRange().getStartOffset();
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.python.introduce.field";
    }

    private static class PyInplaceFieldIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyTargetExpression myTarget;
        private final IntroduceOperation myOperation;
        private final PyIntroduceFieldPanel myPanel;

        public PyInplaceFieldIntroducer(PyTargetExpression target, IntroduceOperation operation, List<PsiElement> occurrences) {
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), "Introduce Field", occurrences.toArray(new PsiElement[occurrences.size()]), null);
            this.myTarget = target;
            this.myOperation = operation;
            this.myPanel = operation.getAvailableInitPlaces().size() > 1 ? new PyIntroduceFieldPanel(this.myProject, operation.getAvailableInitPlaces()) : null;
        }

        @Override
        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }

        @Override
        protected JComponent getComponent() {
            return this.myPanel == null ? null : this.myPanel.getRootPanel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void moveOffsetAfter(boolean success) {
            if (success && this.myPanel != null && this.myPanel.getInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD || this.myOperation.getInplaceInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD) {
                AccessToken accessToken = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());
                try {
                    IntroduceHandler.InitPlace initPlace;
                    PyAssignmentStatement initializer = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, PyAssignmentStatement.class);
                    assert (initializer != null);
                    Function callback = FunctionUtil.constant((Object)initializer);
                    PyClass pyClass = PyUtil.getContainingClassOrSelf(initializer);
                    IntroduceHandler.InitPlace initPlace2 = initPlace = this.myPanel != null ? this.myPanel.getInitPlace() : this.myOperation.getInplaceInitPlace();
                    if (initPlace == IntroduceHandler.InitPlace.CONSTRUCTOR) {
                        AddFieldQuickFix.addFieldToInit(this.myProject, pyClass, "", (Function<String, PyStatement>)callback);
                    } else if (initPlace == IntroduceHandler.InitPlace.SET_UP) {
                        PyIntroduceFieldHandler.addFieldToSetUp(pyClass, (Function<String, PyStatement>)callback);
                    }
                    if (this.myOperation.getOccurrences().size() > 0) {
                        initializer.delete();
                    } else {
                        PyExpression copy = PyElementGenerator.getInstance(this.myProject).createExpressionFromText(LanguageLevel.forElement((PsiElement)this.myTarget), this.myTarget.getText());
                        initializer.replace((PsiElement)copy);
                    }
                    initializer.delete();
                }
                finally {
                    accessToken.finish();
                }
            }
        }
    }

    private static class AddFieldDeclaration
    implements Function<String, PyStatement> {
        private final PsiElement myDeclaration;

        private AddFieldDeclaration(PsiElement declaration) {
            this.myDeclaration = declaration;
        }

        public PyStatement fun(String self_name) {
            if ("self".equals(self_name)) {
                return (PyStatement)this.myDeclaration;
            }
            String text = this.myDeclaration.getText();
            Project project = this.myDeclaration.getProject();
            return PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyStatement.class, text.replaceFirst("self\\.", self_name + "."));
        }
    }

    private static class ResolvingVisitor
    extends PyRecursiveElementVisitor {
        private boolean hasLocalScopeDependencies = false;
        private final ScopeOwner myScope;

        public ResolvingVisitor(ScopeOwner scope) {
            this.myScope = scope;
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            super.visitPyReferenceExpression(node);
            PsiElement result = node.getReference().resolve();
            if (result != null && PsiTreeUtil.getParentOfType((PsiElement)result, ScopeOwner.class) == this.myScope) {
                PyFunction.Modifier modifier;
                PyFunction function;
                PyParameter[] parameters;
                if (result instanceof PyParameter && this.myScope instanceof PyFunction && (parameters = (function = (PyFunction)this.myScope).getParameterList().getParameters()).length > 0 && result == parameters[0] && (modifier = function.getModifier()) != PyFunction.Modifier.STATICMETHOD) {
                    return;
                }
                this.hasLocalScopeDependencies = true;
            }
        }
    }
}

