/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.constant;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.constant.ConstantValidator;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyIntroduceConstantHandler
extends IntroduceHandler {
    public PyIntroduceConstantHandler() {
        super(new ConstantValidator(), PyBundle.message("refactoring.introduce.constant.dialog.title", new Object[0]));
    }

    @Override
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, ScopeOwner.class) instanceof PyFile) {
            return super.replaceExpression(expression, newExpression, operation);
        }
        return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
    }

    @Override
    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/constant/PyIntroduceConstantHandler", "addDeclaration"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/python/refactoring/introduce/constant/PyIntroduceConstantHandler", "addDeclaration"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/jetbrains/python/refactoring/introduce/constant/PyIntroduceConstantHandler", "addDeclaration"));
        }
        PsiFile anchor = expression.getContainingFile();
        assert (anchor instanceof PyFile);
        return anchor.addBefore(declaration, AddImportHelper.getFileInsertPosition((PyFile)anchor));
    }

    @Override
    protected Collection<String> generateSuggestedNames(@NotNull PyExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/constant/PyIntroduceConstantHandler", "generateSuggestedNames"));
        }
        HashSet names = new HashSet();
        for (String name : super.generateSuggestedNames(expression)) {
            names.add(StringUtil.toUpperCase((String)name));
        }
        return names;
    }

    @Override
    protected boolean isValidIntroduceContext(PsiElement element) {
        return super.isValidIntroduceContext(element) || PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class) != null;
    }

    @Override
    protected String getHelpId() {
        return "python.reference.introduceConstant";
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.python.introduce.constant";
    }
}

