/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.NameSuggesterUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import com.jetbrains.python.refactoring.introduce.PyIntroduceDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceHandler
implements RefactoringActionHandler {
    private final IntroduceValidator myValidator;
    protected final String myDialogTitle;

    protected static PsiElement findAnchor(List<PsiElement> occurrences) {
        PyStatement statement;
        Object anchor = occurrences.get(0);
        Pair data = (Pair)anchor.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (data != null && occurrences.size() == 1) {
            return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)data.getFirst()), PyStatement.class);
        }
        block0: while ((statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyStatement.class)) != null) {
            PsiElement parent = statement.getParent();
            for (PsiElement element : occurrences) {
                if (PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)element, (boolean)true)) continue;
                anchor = statement;
                continue block0;
            }
        }
        return statement;
    }

    protected static void ensureName(IntroduceOperation operation) {
        if (operation.getName() == null) {
            Collection<String> suggestedNames = operation.getSuggestedNames();
            if (suggestedNames.size() > 0) {
                operation.setName(suggestedNames.iterator().next());
            } else {
                operation.setName("x");
            }
        }
    }

    @Nullable
    protected static PsiElement findOccurrenceUnderCaret(List<PsiElement> occurrences, Editor editor) {
        if (occurrences.isEmpty()) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        for (PsiElement occurrence : occurrences) {
            if (occurrence == null || !occurrence.getTextRange().contains(offset)) continue;
            return occurrence;
        }
        int line = editor.getDocument().getLineNumber(offset);
        for (PsiElement occurrence : occurrences) {
            if (!occurrence.isValid() || editor.getDocument().getLineNumber(occurrence.getTextRange().getStartOffset()) != line) continue;
            return occurrence;
        }
        for (PsiElement occurrence : occurrences) {
            if (!occurrence.isValid()) continue;
            return occurrence;
        }
        return null;
    }

    @Nullable
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        PyExpressionStatement statement = (PyExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PyExpressionStatement.class);
        if (statement != null && statement.getExpression() == expression && expression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE) == null) {
            statement.delete();
            return null;
        }
        return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
    }

    protected IntroduceHandler(@NotNull IntroduceValidator validator, @NotNull String dialogTitle) {
        if (validator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "<init>"));
        }
        if (dialogTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialogTitle", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "<init>"));
        }
        this.myValidator = validator;
        this.myDialogTitle = dialogTitle;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "invoke"));
        }
        this.performAction(new IntroduceOperation(project, editor, file, null));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "invoke"));
        }
    }

    public Collection<String> getSuggestedNames(@NotNull PyExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "getSuggestedNames"));
        }
        Collection<String> candidates = this.generateSuggestedNames(expression);
        ArrayList<String> res = new ArrayList<String>();
        for (String name : candidates) {
            if (!this.myValidator.checkPossibleName(name, expression)) continue;
            res.add(name);
        }
        if (res.isEmpty()) {
            for (String name : candidates) {
                int index = 1;
                while (!this.myValidator.checkPossibleName(name + index, expression)) {
                    ++index;
                }
                res.add(name + index);
            }
        }
        return res;
    }

    protected Collection<String> generateSuggestedNames(PyExpression expression) {
        PyNamedParameter namedParameter;
        CallArgumentsMapping result;
        PyArgumentList argList;
        PyKeywordArgument kwArg;
        String typeName;
        TypeEvalContext context;
        PyType type;
        PyExpression callee;
        LinkedHashSet<String> candidates = new LinkedHashSet<String>(){

            @Override
            public boolean add(String s) {
                if (PyNames.isReserved(s)) {
                    return false;
                }
                return super.add(s);
            }
        };
        String text = expression.getText();
        Pair selection = (Pair)expression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (selection != null) {
            text = ((TextRange)selection.getSecond()).substring(((PsiElement)selection.getFirst()).getText());
        }
        if (expression instanceof PyCallExpression && (callee = ((PyCallExpression)expression).getCallee()) != null) {
            text = callee.getText();
        }
        if (text != null) {
            candidates.addAll(NameSuggesterUtil.generateNames(text));
        }
        if ((type = (context = TypeEvalContext.userInitiated(expression.getProject(), expression.getContainingFile())).getType(expression)) != null && type != PyNoneType.INSTANCE && (typeName = type.getName()) != null) {
            if (type.isBuiltin()) {
                typeName = typeName.substring(0, 1);
            }
            candidates.addAll(NameSuggesterUtil.generateNamesByType(typeName));
        }
        if ((kwArg = (PyKeywordArgument)PsiTreeUtil.getParentOfType((PsiElement)expression, PyKeywordArgument.class)) != null && kwArg.getValueExpression() == expression) {
            candidates.add(kwArg.getKeyword());
        }
        if ((argList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)expression, PyArgumentList.class)) != null && (result = argList.analyzeCall(PyResolveContext.noImplicits())).getMarkedCallee() != null && (namedParameter = result.getPlainMappedParams().get(expression)) != null) {
            candidates.add(namedParameter.getName());
        }
        return candidates;
    }

    public void performAction(IntroduceOperation operation) {
        TemplateState templateState;
        PsiFile file = operation.getFile();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return;
        }
        Editor editor = operation.getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled() && (templateState = TemplateManagerImpl.getTemplateState(operation.getEditor())) != null && !templateState.isFinished()) {
            return;
        }
        Object element1 = null;
        PsiElement element2 = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        boolean singleElementSelection = false;
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
            element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                int startOffset = element1.getTextRange().getEndOffset();
                element1 = file.findElementAt(startOffset);
            }
            if (element2 instanceof PsiWhiteSpace) {
                int endOffset = element2.getTextRange().getStartOffset();
                element2 = file.findElementAt(endOffset - 1);
            }
            if (element1 == element2) {
                singleElementSelection = true;
            }
        } else {
            if (this.smartIntroduce(operation)) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (lineNumber >= 0 && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document.getLineEndOffset(lineNumber) - 1);
            }
        }
        Project project = operation.getProject();
        if (element1 == null || element2 == null) {
            this.showCannotPerformError(project, editor);
            return;
        }
        element1 = PyRefactoringUtil.getSelectedExpression(project, file, element1, element2);
        PyComprehensionElement comprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)element1, PyComprehensionElement.class, (boolean)true);
        if (element1 == null || comprehension != null) {
            this.showCannotPerformError(project, editor);
            return;
        }
        if (singleElementSelection && element1 instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression literal = (PyStringLiteralExpression)element1;
            if (literal.getStringNodes().size() > 1) {
                this.showCannotPerformError(project, editor);
                return;
            }
            int offset = element1.getTextOffset();
            TextRange selectionRange = TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
            TextRange elementRange = element1.getTextRange();
            if (!elementRange.equals((Object)selectionRange) && elementRange.contains(selectionRange)) {
                TextRange innerRange = literal.getStringValueTextRange();
                TextRange intersection = selectionRange.shiftRight(-offset).intersection(innerRange);
                TextRange finalRange = intersection != null ? intersection : selectionRange;
                String text = literal.getText();
                if (PyStringFormatParser.getFormatValueExpression(literal) != null && IntroduceHandler.breaksStringFormatting(text, finalRange) || PyStringFormatParser.getNewStyleFormatValueExpression(literal) != null && IntroduceHandler.breaksNewStyleStringFormatting(text, finalRange) || IntroduceHandler.breaksStringEscaping(text, finalRange)) {
                    this.showCannotPerformError(project, editor);
                    return;
                }
                element1.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, (Object)Pair.create((Object)element1, (Object)finalRange));
            }
        }
        if (!this.checkIntroduceContext(file, editor, (PsiElement)element1)) {
            return;
        }
        operation.setElement((PsiElement)element1);
        this.performActionOnElement(operation);
    }

    private static boolean breaksStringFormatting(@NotNull String s, @NotNull TextRange range) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "breaksStringFormatting"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "breaksStringFormatting"));
        }
        return IntroduceHandler.breaksRanges(PyStringFormatParser.substitutionsToRanges(PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(s))), range);
    }

    private static boolean breaksNewStyleStringFormatting(@NotNull String s, @NotNull TextRange range) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "breaksNewStyleStringFormatting"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "breaksNewStyleStringFormatting"));
        }
        return IntroduceHandler.breaksRanges(PyStringFormatParser.substitutionsToRanges(PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parseNewStyleFormat(s))), range);
    }

    private static boolean breaksStringEscaping(@NotNull String s, @NotNull TextRange range) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "breaksStringEscaping"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "breaksStringEscaping"));
        }
        return IntroduceHandler.breaksRanges(PyStringFormatParser.getEscapeRanges(s), range);
    }

    private static boolean breaksRanges(@NotNull List<TextRange> ranges, @NotNull TextRange range) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "breaksRanges"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "breaksRanges"));
        }
        for (TextRange r : ranges) {
            if (range.contains(r) || !range.intersectsStrict(r)) continue;
            return true;
        }
        return false;
    }

    private void showCannotPerformError(Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyBundle.message("refactoring.introduce.selection.error", new Object[0]), (String)this.myDialogTitle, (String)"refactoring.extractMethod");
    }

    private boolean smartIntroduce(final IntroduceOperation operation) {
        int offset;
        PsiElement elementAtCaret;
        Editor editor = operation.getEditor();
        PsiFile file = operation.getFile();
        if (!this.checkIntroduceContext(file, editor, elementAtCaret = file.findElementAt(offset = editor.getCaretModel().getOffset()))) {
            return true;
        }
        ArrayList<PyExpression> expressions = new ArrayList<PyExpression>();
        while (elementAtCaret != null && !(elementAtCaret instanceof PyStatement) && !(elementAtCaret instanceof PyFile)) {
            if (elementAtCaret instanceof PyExpression && IntroduceHandler.isValidIntroduceVariant(elementAtCaret)) {
                expressions.add((PyExpression)elementAtCaret);
            }
            elementAtCaret = elementAtCaret.getParent();
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            operation.setElement((PsiElement)expressions.get(0));
            this.performActionOnElement(operation);
            return true;
        }
        if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PyExpression>(){

                public void pass(PyExpression pyExpression) {
                    operation.setElement((PsiElement)pyExpression);
                    IntroduceHandler.this.performActionOnElement(operation);
                }
            }, new Function<PyExpression, String>(){

                public String fun(PyExpression pyExpression) {
                    return pyExpression.getText();
                }
            });
            return true;
        }
        return false;
    }

    protected boolean checkIntroduceContext(PsiFile file, Editor editor, PsiElement element) {
        if (!this.isValidIntroduceContext(element)) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor, (String)PyBundle.message("refactoring.introduce.selection.error", new Object[0]), (String)this.myDialogTitle, (String)"refactoring.extractMethod");
            return false;
        }
        return true;
    }

    protected boolean isValidIntroduceContext(PsiElement element) {
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)element, PyDecorator.class);
        if (decorator != null && PsiTreeUtil.isAncestor((PsiElement)decorator.getCallee(), (PsiElement)element, (boolean)false)) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class) == null;
    }

    private static boolean isValidIntroduceVariant(PsiElement element) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (call != null && PsiTreeUtil.isAncestor((PsiElement)call.getCallee(), (PsiElement)element, (boolean)false)) {
            return false;
        }
        PyComprehensionElement comprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyComprehensionElement.class, (boolean)true);
        return comprehension == null;
    }

    private void performActionOnElement(IntroduceOperation operation) {
        if (!this.checkEnabled(operation)) {
            return;
        }
        PsiElement element = operation.getElement();
        PsiElement parent = element.getParent();
        PyExpression initializer = parent instanceof PyAssignmentStatement ? ((PyAssignmentStatement)parent).getAssignedValue() : (PyExpression)element;
        operation.setInitializer(initializer);
        if (initializer != null) {
            operation.setOccurrences(this.getOccurrences(element, initializer));
            operation.setSuggestedNames(this.getSuggestedNames(initializer));
        }
        if (operation.getOccurrences().size() == 0) {
            operation.setReplaceAll(false);
        }
        this.performActionOnElementOccurrences(operation);
    }

    protected void performActionOnElementOccurrences(final IntroduceOperation operation) {
        Editor editor = operation.getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled()) {
            IntroduceHandler.ensureName(operation);
            if (operation.isReplaceAll() != null) {
                this.performInplaceIntroduce(operation);
            } else {
                OccurrencesChooser.simpleChooser(editor).showChooser(operation.getElement(), operation.getOccurrences(), new Pass<OccurrencesChooser.ReplaceChoice>(){

                    public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                        operation.setReplaceAll(replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
                        IntroduceHandler.this.performInplaceIntroduce(operation);
                    }
                });
            }
        } else {
            this.performIntroduceWithDialog(operation);
        }
    }

    protected void performInplaceIntroduce(IntroduceOperation operation) {
        PsiElement statement = this.performRefactoring(operation);
        if (statement instanceof PyAssignmentStatement) {
            PyTargetExpression target = (PyTargetExpression)((PyAssignmentStatement)statement).getTargets()[0];
            List<PsiElement> occurrences = operation.getOccurrences();
            PsiElement occurrence = IntroduceHandler.findOccurrenceUnderCaret(occurrences, operation.getEditor());
            Object elementForCaret = occurrence != null ? occurrence : target;
            operation.getEditor().getCaretModel().moveToOffset(elementForCaret.getTextRange().getStartOffset());
            PyInplaceVariableIntroducer introducer = new PyInplaceVariableIntroducer(target, operation, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    protected void performIntroduceWithDialog(IntroduceOperation operation) {
        Project project = operation.getProject();
        if (operation.getName() == null) {
            PyIntroduceDialog dialog = new PyIntroduceDialog(project, this.myDialogTitle, this.myValidator, this.getHelpId(), operation);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            operation.setName(dialog.getName());
            operation.setReplaceAll(dialog.doReplaceAllOccurrences());
            operation.setInitPlace(dialog.getInitPlace());
        }
        PsiElement declaration = this.performRefactoring(operation);
        Editor editor = operation.getEditor();
        editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
        editor.getSelectionModel().removeSelection();
    }

    protected PsiElement performRefactoring(IntroduceOperation operation) {
        PyAssignmentStatement declaration = this.createDeclaration(operation);
        declaration = this.performReplace(declaration, operation);
        declaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(declaration);
        return declaration;
    }

    public PyAssignmentStatement createDeclaration(IntroduceOperation operation) {
        Project project = operation.getProject();
        PyExpression initializer = operation.getInitializer();
        String assignmentText = operation.getName() + " = " + new InitializerTextBuilder(initializer).result();
        PsiElement anchor = operation.isReplaceAll() != false ? IntroduceHandler.findAnchor(operation.getOccurrences()) : PsiTreeUtil.getParentOfType((PsiElement)initializer, PyStatement.class);
        return this.createDeclaration(project, assignmentText, anchor);
    }

    protected abstract String getHelpId();

    protected PyAssignmentStatement createDeclaration(Project project, String assignmentText, PsiElement anchor) {
        LanguageLevel langLevel = ((PyFile)anchor.getContainingFile()).getLanguageLevel();
        return PyElementGenerator.getInstance(project).createFromText(langLevel, PyAssignmentStatement.class, assignmentText);
    }

    protected boolean checkEnabled(IntroduceOperation operation) {
        return true;
    }

    protected List<PsiElement> getOccurrences(PsiElement element, @NotNull PyExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "getOccurrences"));
        }
        return PyRefactoringUtil.getOccurrences((PsiElement)expression, (PsiElement)ScopeUtil.getScopeOwner((PsiElement)expression));
    }

    private PsiElement performReplace(final @NotNull PsiElement declaration, final IntroduceOperation operation) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/python/refactoring/introduce/IntroduceHandler", "performReplace"));
        }
        final PyExpression expression = operation.getInitializer();
        final Project project = operation.getProject();
        return (PsiElement)new WriteCommandAction<PsiElement>(project, new PsiFile[]{expression.getContainingFile()}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void run(@NotNull Result<PsiElement> result) throws Throwable {
                RefactoringEventData afterData;
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/refactoring/introduce/IntroduceHandler$5", "run"));
                }
                try {
                    afterData = new RefactoringEventData();
                    afterData.addElement(declaration);
                    ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(IntroduceHandler.this.getRefactoringId(), afterData);
                    result.setResult((Object)IntroduceHandler.this.addDeclaration(operation, declaration));
                    PyExpression newExpression = IntroduceHandler.this.createExpression(project, operation.getName(), declaration);
                    if (operation.isReplaceAll().booleanValue()) {
                        ArrayList<PsiElement> newOccurrences = new ArrayList<PsiElement>();
                        for (PsiElement occurrence : operation.getOccurrences()) {
                            PsiElement replaced = IntroduceHandler.this.replaceExpression(occurrence, newExpression, operation);
                            if (replaced == null) continue;
                            newOccurrences.add(replaced);
                        }
                        operation.setOccurrences(newOccurrences);
                    } else {
                        PsiElement replaced = IntroduceHandler.this.replaceExpression((PsiElement)expression, newExpression, operation);
                        operation.setOccurrences(Collections.singletonList(replaced));
                    }
                    IntroduceHandler.this.postRefactoring(operation.getElement());
                }
                finally {
                    afterData = new RefactoringEventData();
                    afterData.addElement(declaration);
                    ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceHandler.this.getRefactoringId(), afterData);
                }
            }
        }.execute().getResultObject();
    }

    protected abstract String getRefactoringId();

    @Nullable
    public PsiElement addDeclaration(IntroduceOperation operation, PsiElement declaration) {
        PyExpression expression = operation.getInitializer();
        Pair data = (Pair)expression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (data == null) {
            return this.addDeclaration((PsiElement)expression, declaration, operation);
        }
        return this.addDeclaration((PsiElement)data.first, declaration, operation);
    }

    protected PyExpression createExpression(Project project, String name, PsiElement declaration) {
        return PyElementGenerator.getInstance(project).createExpressionFromText(LanguageLevel.forElement(declaration), name);
    }

    @Nullable
    protected abstract PsiElement addDeclaration(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull IntroduceOperation var3);

    protected void postRefactoring(PsiElement element) {
    }

    private static class PyInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyTargetExpression myTarget;

        public PyInplaceVariableIntroducer(PyTargetExpression target, IntroduceOperation operation, List<PsiElement> occurrences) {
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), "Introduce Variable", occurrences.toArray(new PsiElement[occurrences.size()]), null);
            this.myTarget = target;
        }

        @Override
        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }
    }

    private static class InitializerTextBuilder
    extends PyRecursiveElementVisitor {
        private final StringBuilder myResult;

        public InitializerTextBuilder(@NotNull PyExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/introduce/IntroduceHandler$InitializerTextBuilder", "<init>"));
            }
            this.myResult = new StringBuilder();
            if (PsiTreeUtil.findChildOfType((PsiElement)expression, PsiComment.class) != null) {
                this.myResult.append(expression.getText());
            } else {
                expression.accept(this);
            }
            if (this.needToWrapTopLevelExpressionInParenthesis(expression)) {
                this.myResult.insert(0, "(").append(")");
            }
        }

        public void visitWhiteSpace(PsiWhiteSpace space) {
            this.myResult.append(space.getText().replace('\n', ' ').replace("\\", ""));
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            Pair data = (Pair)node.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
            if (data != null) {
                PsiElement parent = (PsiElement)data.getFirst();
                String text = parent.getText();
                Pair detectedQuotes = PythonStringUtil.getQuotes(text);
                Pair quotes = detectedQuotes != null ? detectedQuotes : Pair.create((Object)"'", (Object)"'");
                TextRange range = (TextRange)data.getSecond();
                String substring = range.substring(text);
                this.myResult.append((String)quotes.getFirst()).append(substring).append((String)quotes.getSecond());
            } else {
                for (ASTNode child = node.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    String text = child.getText();
                    if (child.getElementType() == TokenType.WHITE_SPACE) {
                        if (!text.contains("\n")) continue;
                        if (!text.contains("\\")) {
                            this.myResult.append("\\");
                        }
                        this.myResult.append(text);
                        continue;
                    }
                    this.myResult.append(text);
                }
            }
        }

        @Override
        public void visitElement(PsiElement element) {
            if (element.getChildren().length == 0) {
                this.myResult.append(element.getText());
            } else {
                super.visitElement(element);
            }
        }

        private boolean needToWrapTopLevelExpressionInParenthesis(@NotNull PyExpression node) {
            PsiElement firstChild;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/introduce/IntroduceHandler$InitializerTextBuilder", "needToWrapTopLevelExpressionInParenthesis"));
            }
            return node instanceof PyGeneratorExpression && (firstChild = node.getFirstChild()) != null && firstChild.getNode().getElementType() != PyTokenTypes.LPAR;
        }

        public String result() {
            return this.myResult.toString();
        }
    }

    public static enum InitPlace {
        SAME_METHOD,
        CONSTRUCTOR,
        SET_UP;

    }
}

