/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInlineLocalHandler
extends InlineActionHandler {
    private static final Logger LOG = Logger.getInstance((String)PyInlineLocalHandler.class.getName());
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.variable.title");
    private static final Pair<PyStatement, Boolean> EMPTY_DEF_RESULT = Pair.create(null, (Object)false);
    private static final String HELP_ID = "python.reference.inline";

    public static PyInlineLocalHandler getInstance() {
        return (PyInlineLocalHandler)((Object)Extensions.findExtension((ExtensionPointName)EP_NAME, PyInlineLocalHandler.class));
    }

    public boolean isEnabledForLanguage(Language l) {
        return l instanceof PythonLanguage;
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PyTargetExpression;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiElement refElement;
        if (editor == null) {
            return;
        }
        PsiReference psiReference = TargetElementUtilBase.findReference(editor);
        PyReferenceExpression refExpr = null;
        if (psiReference != null && (refElement = psiReference.getElement()) instanceof PyReferenceExpression) {
            refExpr = (PyReferenceExpression)refElement;
        }
        PyInlineLocalHandler.invoke(project, editor, (PyTargetExpression)element, refExpr);
    }

    private static void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PyTargetExpression local, @Nullable PyReferenceExpression refExpr) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler", "invoke"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler", "invoke"));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        final HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        TextAttributes writeAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        final String localName = local.getName();
        ScopeOwner containerBlock = PyInlineLocalHandler.getContext(local);
        LOG.assertTrue(containerBlock != null);
        Pair<PyStatement, Boolean> defPair = PyInlineLocalHandler.getAssignmentToInline(containerBlock, refExpr, local, project);
        final PyStatement def = (PyStatement)defPair.first;
        if (def == null || PyInlineLocalHandler.getValue(def) == null) {
            String key = (Boolean)defPair.second != false ? "variable.has.no.dominating.definition" : "variable.has.no.initializer";
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        if (def instanceof PyAssignmentStatement && ((PyAssignmentStatement)def).getTargets().length > 1) {
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{def}, writeAttributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)PyBundle.message("refactoring.inline.local.multiassignment", localName));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        final PsiElement[] refsToInline = PyDefUseUtil.getPostRefs(containerBlock, local, PyInlineLocalHandler.getObject(def));
        if (refsToInline.length == 0) {
            String message = RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        final TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            highlightManager.addOccurrenceHighlights(editor, refsToInline, attributes, true, null);
            int occurrencesCount = refsToInline.length;
            String occurrencesString = RefactoringBundle.message((String)"occurrences.string", (Object[])new Object[]{occurrencesCount});
            String question = RefactoringBundle.message((String)"inline.local.variable.prompt", (Object[])new Object[]{localName}) + " " + occurrencesString;
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(REFACTORING_NAME, question, HELP_ID, "OptionPane.questionIcon", true, project);
            dialog.show();
            if (!dialog.isOK()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                return;
            }
        }
        final PsiFile workingFile = local.getContainingFile();
        for (PsiElement ref : refsToInline) {
            PsiFile otherFile = ref.getContainingFile();
            if (otherFile.equals(workingFile)) continue;
            String message = RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        for (PsiElement ref : refsToInline) {
            ArrayList<PsiElement> elems = new ArrayList<PsiElement>();
            List<ReadWriteInstruction> latestDefs = PyDefUseUtil.getLatestDefs(containerBlock, local.getName(), ref, false);
            for (ReadWriteInstruction i : latestDefs) {
                elems.add(i.getElement());
            }
            PsiElement[] defs = elems.toArray(new PsiElement[elems.size()]);
            boolean isSameDefinition = true;
            for (PsiElement otherDef : defs) {
                isSameDefinition &= PyInlineLocalHandler.isSameDefinition(def, otherDef);
            }
            if (isSameDefinition) continue;
            highlightManager.addOccurrenceHighlights(editor, defs, writeAttributes, true, null);
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{ref}, attributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)HELP_ID);
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        RefactoringEventData afterData;
                        try {
                            PsiElement parent;
                            afterData = new RefactoringEventData();
                            afterData.addElement((PsiElement)local);
                            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyInlineLocalHandler.getRefactoringId(), afterData);
                            Object[] exprs = new PsiElement[refsToInline.length];
                            PyExpression value = PyInlineLocalHandler.prepareValue(def, localName, project);
                            PyExpression withParenthesis = PyElementGenerator.getInstance(project).createExpressionFromText("(" + value.getText() + ")");
                            PsiElement lastChild = def.getLastChild();
                            if (lastChild != null && lastChild.getNode().getElementType() == PyTokenTypes.END_OF_LINE_COMMENT && (parent = def.getParent()) != null) {
                                parent.addBefore(lastChild, (PsiElement)def);
                            }
                            for (PsiElement element : refsToInline) {
                                exprs[i] = PyReplaceExpressionUtil.isNeedParenthesis((PyExpression)element, value) ? element.replace((PsiElement)withParenthesis) : element.replace((PsiElement)value);
                            }
                            PsiElement next = def.getNextSibling();
                            if (next instanceof PsiWhiteSpace) {
                                PyPsiUtils.removeElements(next);
                            }
                            PyPsiUtils.removeElements(new PsiElement[]{def});
                            List ranges = ContainerUtil.mapNotNull((Object[])exprs, (Function)new Function<PsiElement, TextRange>(){

                                public TextRange fun(PsiElement element) {
                                    PyStatement parentalStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatement.class, (boolean)false);
                                    return parentalStatement != null ? parentalStatement.getTextRange() : null;
                                }
                            });
                            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                            CodeStyleManager.getInstance((Project)project).reformatText(workingFile, (Collection)ranges);
                            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                                highlightManager.addOccurrenceHighlights(editor, (PsiElement[])exprs, attributes, true, null);
                                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                            }
                        }
                        finally {
                            afterData = new RefactoringEventData();
                            afterData.addElement((PsiElement)local);
                            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyInlineLocalHandler.getRefactoringId(), afterData);
                        }
                    }
                });
            }
        }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{localName}), null);
    }

    private static boolean isSameDefinition(PyStatement def, PsiElement otherDef) {
        if (otherDef instanceof PyTargetExpression) {
            otherDef = otherDef.getParent();
        }
        return otherDef == def;
    }

    private static ScopeOwner getContext(PyTargetExpression local) {
        ScopeOwner context = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)local, PyFunction.class);
        if (context == null) {
            context = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)local, PyClass.class);
        }
        if (context == null) {
            context = (PyFile)local.getContainingFile();
        }
        return context;
    }

    private static Pair<PyStatement, Boolean> getAssignmentToInline(ScopeOwner containerBlock, PyReferenceExpression expr, PyTargetExpression local, Project project) {
        Query query;
        PsiReference first;
        if (expr != null) {
            try {
                List<ReadWriteInstruction> candidates = PyDefUseUtil.getLatestDefs(containerBlock, local.getName(), (PsiElement)expr, true);
                if (candidates.size() == 1) {
                    PyStatement expression = PyInlineLocalHandler.getAssignmentByLeftPart((PyElement)candidates.get(0).getElement());
                    return Pair.create((Object)expression, (Object)false);
                }
                return Pair.create(null, (Object)(candidates.size() > 0 ? 1 : 0));
            }
            catch (PyDefUseUtil.InstructionNotFoundException ignored) {
                // empty catch block
            }
        }
        PyElement lValue = (first = (PsiReference)(query = ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)false)).findFirst()) != null ? (PyElement)first.resolve() : null;
        return lValue != null ? Pair.create((Object)PyInlineLocalHandler.getAssignmentByLeftPart(lValue), (Object)false) : EMPTY_DEF_RESULT;
    }

    @Nullable
    private static PyStatement getAssignmentByLeftPart(PyElement candidate) {
        PsiElement parent = candidate.getParent();
        return parent instanceof PyAssignmentStatement || parent instanceof PyAugAssignmentStatement ? (PyStatement)parent : null;
    }

    @Nullable
    private static PyExpression getValue(@Nullable PyStatement def) {
        if (def == null) {
            return null;
        }
        if (def instanceof PyAssignmentStatement) {
            return ((PyAssignmentStatement)def).getAssignedValue();
        }
        return ((PyAugAssignmentStatement)def).getValue();
    }

    @Nullable
    private static PyExpression getObject(@Nullable PyStatement def) {
        if (def == null) {
            return null;
        }
        if (def instanceof PyAssignmentStatement) {
            return ((PyAssignmentStatement)def).getTargets()[0];
        }
        return ((PyAugAssignmentStatement)def).getTarget();
    }

    @NotNull
    private static PyExpression prepareValue(@NotNull PyStatement def, @NotNull String localName, @NotNull Project project) {
        if (def == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "def", "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler", "prepareValue"));
        }
        if (localName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler", "prepareValue"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler", "prepareValue"));
        }
        PyExpression value = PyInlineLocalHandler.getValue(def);
        assert (value != null);
        if (def instanceof PyAugAssignmentStatementImpl) {
            PyAugAssignmentStatementImpl expression = (PyAugAssignmentStatementImpl)def;
            PsiElement operation = expression.getOperation();
            assert (operation != null);
            String op = operation.getText().replace('=', ' ');
            PyExpression pyExpression = PyElementGenerator.getInstance(project).createExpressionFromText(localName + " " + op + value.getText() + ")");
            if (pyExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler", "prepareValue"));
            }
            return pyExpression;
        }
        PyExpression pyExpression = value;
        if (pyExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler", "prepareValue"));
        }
        return pyExpression;
    }

    public static String getRefactoringId() {
        return "refactoring.python.inline.local";
    }
}

