/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.extractmethod;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractMethodDialog;
import com.intellij.refactoring.extractMethod.AbstractVariableData;
import com.intellij.refactoring.extractMethod.ExtractMethodDecorator;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExtractMethodUtil {
    public static final String NAME = "extract.method.name";

    private PyExtractMethodUtil() {
    }

    public static void extractFromStatements(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PyCodeFragment fragment, final @NotNull PsiElement statement1, final @NotNull PsiElement statement2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "extractFromStatements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "extractFromStatements"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "extractFromStatements"));
        }
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "extractFromStatements"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "extractFromStatements"));
        }
        if (!fragment.getOutputVariables().isEmpty() && fragment.isReturnInstructionInside()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyBundle.message("refactoring.extract.method.error.cannot.perform.refactoring.with.local", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)statement1, PyFunction.class);
        final PyUtil.MethodFlags flags = function == null ? null : PyUtil.MethodFlags.of(function);
        final boolean isClassMethod = flags != null && flags.isClassMethod();
        final boolean isStaticMethod = flags != null && flags.isStaticMethod();
        final List<PsiElement> elementsRange = PyPsiUtils.collectElements(statement1, statement2);
        if (elementsRange.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform refactoring from empty code fragment", (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
            return;
        }
        Pair<String, AbstractVariableData[]> data = PyExtractMethodUtil.getNameAndVariableData(project, fragment, statement1, isClassMethod, isStaticMethod);
        if (data.first == null || data.second == null) {
            return;
        }
        final String methodName = (String)data.first;
        final AbstractVariableData[] variableData = (AbstractVariableData[])data.second;
        final SimpleDuplicatesFinder finder = new SimpleDuplicatesFinder(statement1, statement2, variableData, fragment.getOutputVariables());
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        boolean hasOutputVariables;
                        RefactoringEventData beforeData = new RefactoringEventData();
                        beforeData.addElements(new PsiElement[]{statement1, statement2});
                        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyExtractMethodUtil.getRefactoringId(), beforeData);
                        StringBuilder builder = new StringBuilder();
                        ArrayList<PsiElement> newMethodElements = new ArrayList<PsiElement>(elementsRange);
                        boolean bl = hasOutputVariables = !fragment.getOutputVariables().isEmpty();
                        if (hasOutputVariables) {
                            for (String s : fragment.getOutputVariables()) {
                                if (builder.length() != 0) {
                                    builder.append(", ");
                                }
                                builder.append(s);
                            }
                            PsiElement returnStatement = (PsiElement)PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement(statement1), PyElement.class, "return " + builder.toString());
                            newMethodElements.add(returnStatement);
                        }
                        PyFunction generatedMethod = PyExtractMethodUtil.generateMethodFromElements(project, methodName, variableData, newMethodElements, flags);
                        generatedMethod = PyExtractMethodUtil.insertGeneratedMethod(statement1, generatedMethod);
                        PsiElement firstElement = (PsiElement)elementsRange.get(0);
                        boolean isMethod = PyPsiUtils.isMethodContext(firstElement);
                        PyExtractMethodUtil.processParameters(project, generatedMethod, variableData, isMethod, isClassMethod, isStaticMethod);
                        PyExtractMethodUtil.processGlobalWrites(generatedMethod, fragment);
                        PyExtractMethodUtil.processNonlocalWrites(generatedMethod, fragment);
                        if (hasOutputVariables) {
                            builder.append(" = ");
                        } else if (fragment.isReturnInstructionInside()) {
                            builder.append("return ");
                        }
                        if (fragment.isYieldInside()) {
                            builder.append("yield from ");
                        }
                        if (isMethod) {
                            PyExtractMethodUtil.appendSelf(firstElement, builder, isStaticMethod);
                        }
                        builder.append(methodName).append("(");
                        builder.append(PyExtractMethodUtil.createCallArgsString(variableData)).append(")");
                        PsiElement callElement = (PsiElement)PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement(statement1), PyElement.class, builder.toString());
                        callElement = PyExtractMethodUtil.replaceElements(elementsRange, callElement);
                        callElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(callElement);
                        if (callElement != null) {
                            PyExtractMethodUtil.processDuplicates(callElement, generatedMethod, finder, editor);
                        }
                        PyExtractMethodUtil.setSelectionAndCaret(editor, callElement);
                        RefactoringEventData afterData = new RefactoringEventData();
                        afterData.addElement((PsiElement)generatedMethod);
                        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyExtractMethodUtil.getRefactoringId(), afterData);
                    }
                });
            }
        }, "Extract method", null);
    }

    private static void processDuplicates(@NotNull PsiElement callElement, @NotNull PyFunction generatedMethod, @NotNull SimpleDuplicatesFinder finder, @NotNull Editor editor) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "processDuplicates"));
        }
        if (generatedMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedMethod", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "processDuplicates"));
        }
        if (finder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finder", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "processDuplicates"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "processDuplicates"));
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner(callElement);
        if (owner instanceof PsiFile) {
            return;
        }
        ArrayList<PsiElement> scope = new ArrayList<PsiElement>();
        if (owner instanceof PyFunction) {
            scope.add((PsiElement)owner);
            PyClass containingClass = ((PyFunction)owner).getContainingClass();
            if (containingClass != null) {
                for (PyFunction function : containingClass.getMethods(false)) {
                    if (function.equals(owner) || function.equals(generatedMethod)) continue;
                    scope.add(function);
                }
            }
        }
        ExtractMethodHelper.processDuplicates(callElement, generatedMethod, scope, finder, editor, new Consumer<Pair<SimpleMatch, PsiElement>>(){

            public void consume(Pair<SimpleMatch, PsiElement> pair) {
                PyExtractMethodUtil.replaceElements((SimpleMatch)pair.first, ((PsiElement)pair.second).copy());
            }
        });
    }

    private static void processGlobalWrites(@NotNull PyFunction function, @NotNull PyCodeFragment fragment) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "processGlobalWrites"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "processGlobalWrites"));
        }
        Set<String> globalWrites = fragment.getGlobalWrites();
        LinkedHashSet<String> newGlobalNames = new LinkedHashSet<String>();
        Scope scope = ControlFlowCache.getScope(function);
        for (String name : globalWrites) {
            if (scope.isGlobal(name)) continue;
            newGlobalNames.add(name);
        }
        if (!newGlobalNames.isEmpty()) {
            PyElementGenerator generator = PyElementGenerator.getInstance(function.getProject());
            PyGlobalStatement globalStatement = generator.createFromText(LanguageLevel.forElement(function), PyGlobalStatement.class, "global " + StringUtil.join(newGlobalNames, (String)", "));
            PyStatementList statementList = function.getStatementList();
            if (statementList != null) {
                statementList.addBefore(globalStatement, statementList.getFirstChild());
            }
        }
    }

    private static void processNonlocalWrites(@NotNull PyFunction function, @NotNull PyCodeFragment fragment) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "processNonlocalWrites"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "processNonlocalWrites"));
        }
        Set<String> nonlocalWrites = fragment.getNonlocalWrites();
        LinkedHashSet<String> newNonlocalNames = new LinkedHashSet<String>();
        Scope scope = ControlFlowCache.getScope(function);
        for (String name : nonlocalWrites) {
            if (scope.isNonlocal(name)) continue;
            newNonlocalNames.add(name);
        }
        if (!newNonlocalNames.isEmpty()) {
            PyElementGenerator generator = PyElementGenerator.getInstance(function.getProject());
            PyNonlocalStatement nonlocalStatement = generator.createFromText(LanguageLevel.forElement(function), PyNonlocalStatement.class, "nonlocal " + StringUtil.join(newNonlocalNames, (String)", "));
            PyStatementList statementList = function.getStatementList();
            if (statementList != null) {
                statementList.addBefore((PsiElement)nonlocalStatement, statementList.getFirstChild());
            }
        }
    }

    private static void appendSelf(PsiElement firstElement, StringBuilder builder, boolean staticMethod) {
        if (staticMethod) {
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)firstElement, PyClass.class);
            assert (containingClass != null);
            builder.append(containingClass.getName());
        } else {
            builder.append(PyUtil.getFirstParameterName((PyFunction)PsiTreeUtil.getParentOfType((PsiElement)firstElement, PyFunction.class)));
        }
        builder.append(".");
    }

    public static void extractFromExpression(final @NotNull Project project, final Editor editor, final PyCodeFragment fragment, final @NotNull PsiElement expression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "extractFromExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "extractFromExpression"));
        }
        if (!fragment.getOutputVariables().isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform refactoring from expression with local variables modifications inside code fragment", (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        if (fragment.isReturnInstructionInside()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot extract method with return instructions inside code fragment", (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class);
        final PyUtil.MethodFlags flags = function == null ? null : PyUtil.MethodFlags.of(function);
        final boolean isClassMethod = flags != null && flags.isClassMethod();
        final boolean isStaticMethod = flags != null && flags.isClassMethod();
        Pair<String, AbstractVariableData[]> data = PyExtractMethodUtil.getNameAndVariableData(project, fragment, expression, isClassMethod, isStaticMethod);
        if (data.first == null || data.second == null) {
            return;
        }
        final String methodName = (String)data.first;
        final AbstractVariableData[] variableData = (AbstractVariableData[])data.second;
        final SimpleDuplicatesFinder finder = new SimpleDuplicatesFinder(expression, expression, variableData, fragment.getOutputVariables());
        if (fragment.getOutputVariables().isEmpty()) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            PyFunction generatedMethod = PyExtractMethodUtil.generateMethodFromExpression(project, methodName, variableData, expression, flags);
                            generatedMethod = PyExtractMethodUtil.insertGeneratedMethod(expression, generatedMethod);
                            boolean isMethod = PyPsiUtils.isMethodContext(expression);
                            PyExtractMethodUtil.processParameters(project, generatedMethod, variableData, isMethod, isClassMethod, isStaticMethod);
                            StringBuilder builder = new StringBuilder();
                            if (fragment.isYieldInside()) {
                                builder.append("yield from ");
                            } else {
                                builder.append("return ");
                            }
                            if (isMethod) {
                                PyExtractMethodUtil.appendSelf(expression, builder, isStaticMethod);
                            }
                            builder.append(methodName);
                            builder.append("(").append(PyExtractMethodUtil.createCallArgsString(variableData)).append(")");
                            PyElementGenerator generator = PyElementGenerator.getInstance(project);
                            PyElement generated = generator.createFromText(LanguageLevel.forElement(expression), PyElement.class, builder.toString());
                            PyExpression callElement = null;
                            if (generated instanceof PyReturnStatement) {
                                callElement = ((PyReturnStatement)generated).getExpression();
                            } else if (generated instanceof PyExpressionStatement) {
                                callElement = ((PyExpressionStatement)generated).getExpression();
                            }
                            if (callElement != null) {
                                callElement = PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)callElement);
                            }
                            if (callElement != null) {
                                PyExtractMethodUtil.processDuplicates((PsiElement)callElement, generatedMethod, finder, editor);
                            }
                            PyExtractMethodUtil.setSelectionAndCaret(editor, (PsiElement)callElement);
                        }
                    });
                }
            }, "Extract method", null);
        }
    }

    private static void setSelectionAndCaret(Editor editor, @Nullable PsiElement callElement) {
        editor.getSelectionModel().removeSelection();
        if (callElement != null) {
            int offset = callElement.getTextOffset();
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    private static PsiElement replaceElements(List<PsiElement> elementsRange, @NotNull PsiElement callElement) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "replaceElements"));
        }
        callElement = elementsRange.get(0).replace(callElement);
        if (elementsRange.size() > 1) {
            callElement.getParent().deleteChildRange(elementsRange.get(1), elementsRange.get(elementsRange.size() - 1));
        }
        return callElement;
    }

    private static PsiElement replaceElements(@NotNull SimpleMatch match, @NotNull PsiElement element) {
        if (match == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "match", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "replaceElements"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil", "replaceElements"));
        }
        List<PsiElement> elementsRange = PyPsiUtils.collectElements(match.getStartElement(), match.getEndElement());
        Map<String, String> changedParameters = match.getChangedParameters();
        Object callElement = element;
        PyElementGenerator generator = PyElementGenerator.getInstance(callElement.getProject());
        if (element instanceof PyAssignmentStatement) {
            PyExpression[] targets;
            PyExpression value = ((PyAssignmentStatement)element).getAssignedValue();
            if (value != null) {
                callElement = value;
            }
            if ((targets = ((PyAssignmentStatement)element).getTargets()).length == 1) {
                String output = match.getChangedOutput();
                PyExpression text = generator.createFromText(LanguageLevel.forElement(callElement), PyAssignmentStatement.class, output + " = 1").getTargets()[0];
                targets[0].replace((PsiElement)text);
            }
        }
        if (element instanceof PyExpressionStatement) {
            callElement = ((PyExpressionStatement)element).getExpression();
        }
        if (callElement instanceof PyCallExpression) {
            Set<String> keys = changedParameters.keySet();
            PyArgumentList argumentList = ((PyCallExpression)callElement).getArgumentList();
            if (argumentList != null) {
                for (PyExpression arg : argumentList.getArguments()) {
                    String argText = arg.getText();
                    if (argText == null || !keys.contains(argText)) continue;
                    arg.replace((PsiElement)generator.createExpressionFromText(LanguageLevel.forElement(callElement), changedParameters.get(argText)));
                }
            }
        }
        return PyExtractMethodUtil.replaceElements(elementsRange, element);
    }

    private static String createCallArgsString(AbstractVariableData[] variableDatas) {
        StringBuilder builder = new StringBuilder();
        for (AbstractVariableData data : variableDatas) {
            if (!data.isPassAsParameter()) continue;
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(data.getOriginalName());
        }
        return builder.toString();
    }

    private static void processParameters(Project project, PyFunction generatedMethod, AbstractVariableData[] variableData, boolean isMethod, boolean isClassMethod, boolean isStaticMethod) {
        Map<String, String> map = PyExtractMethodUtil.createMap(variableData);
        for (PyParameter parameter : generatedMethod.getParameterList().getParameters()) {
            String name = parameter.getName();
            String newName = map.get(name);
            if (name == null || newName == null || name.equals(newName)) continue;
            HashMap<PyParameter, String> allRenames = new HashMap<PyParameter, String>();
            allRenames.put(parameter, newName);
            UsageInfo[] usages = RenameUtil.findUsages((PsiElement)parameter, newName, false, false, allRenames);
            try {
                RenameUtil.doRename((PsiElement)parameter, newName, usages, project, (RefactoringElementListener)new RefactoringElementListenerComposite());
            }
            catch (IncorrectOperationException e) {
                RenameUtil.showErrorMessage(e, (PsiElement)parameter, project);
                return;
            }
        }
        PyFunctionBuilder builder = new PyFunctionBuilder("foo");
        if (isClassMethod) {
            builder.parameter("cls");
        } else if (isMethod && !isStaticMethod) {
            builder.parameter("self");
        }
        for (AbstractVariableData data : variableData) {
            if (!data.isPassAsParameter()) continue;
            builder.parameter(data.getName());
        }
        PyParameterList pyParameterList = builder.buildFunction(project, LanguageLevel.forElement(generatedMethod)).getParameterList();
        generatedMethod.getParameterList().replace((PsiElement)pyParameterList);
    }

    private static Map<String, String> createMap(AbstractVariableData[] variableData) {
        com.intellij.util.containers.hash.HashMap map = new com.intellij.util.containers.hash.HashMap();
        for (AbstractVariableData data : variableData) {
            map.put(data.getOriginalName(), data.getName());
        }
        return map;
    }

    private static PyFunction insertGeneratedMethod(PsiElement anchor, PyFunction generatedMethod) {
        PsiElement result;
        PsiNamedElement parent;
        Pair data = (Pair)anchor.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (data != null) {
            anchor = (PsiElement)data.first;
        }
        if ((parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{PyFile.class, PyClass.class, PyFunction.class})) instanceof PyFile || parent instanceof PyClass) {
            PsiNamedElement target = parent instanceof PyClass ? ((PyClass)parent).getStatementList() : parent;
            PsiElement anchorStatement = PyPsiUtils.getStatement((PsiElement)target, anchor);
            result = target.addBefore((PsiElement)generatedMethod, anchorStatement);
        } else {
            result = parent.getParent().addBefore((PsiElement)generatedMethod, (PsiElement)parent);
        }
        result.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                CodeEditUtil.setNodeGenerated(element.getNode(), true);
            }
        });
        return (PyFunction)result;
    }

    private static PyFunction generateMethodFromExpression(Project project, String methodName, AbstractVariableData[] variableData, PsiElement expression, @Nullable PyUtil.MethodFlags flags) {
        PyFunctionBuilder builder = new PyFunctionBuilder(methodName);
        PyExtractMethodUtil.addDecorators(builder, flags);
        PyExtractMethodUtil.addFakeParameters(builder, variableData);
        String text = expression instanceof PyYieldExpression ? String.format("(%s)", expression.getText()) : expression.getText();
        builder.statement("return " + text);
        return builder.buildFunction(project, LanguageLevel.forElement(expression));
    }

    private static PyFunction generateMethodFromElements(Project project, String methodName, AbstractVariableData[] variableData, List<PsiElement> elementsRange, @Nullable PyUtil.MethodFlags flags) {
        assert (!elementsRange.isEmpty()) : "Empty statements list was selected!";
        PyFunctionBuilder builder = new PyFunctionBuilder(methodName);
        PyExtractMethodUtil.addDecorators(builder, flags);
        PyExtractMethodUtil.addFakeParameters(builder, variableData);
        PyFunction method = builder.buildFunction(project, LanguageLevel.forElement(elementsRange.get(0)));
        PyStatementList statementList = method.getStatementList();
        assert (statementList != null);
        for (PsiElement element : elementsRange) {
            if (element instanceof PsiWhiteSpace) continue;
            statementList.add(element);
        }
        PsiElement child = statementList.getFirstChild();
        if (child != null) {
            child.delete();
        }
        PyStatementList last = statementList;
        while (last != null) {
            if (!((last = last.getLastChild()) instanceof PsiWhiteSpace)) continue;
            last.delete();
        }
        return method;
    }

    private static void addDecorators(PyFunctionBuilder builder, PyUtil.MethodFlags flags) {
        if (flags != null) {
            if (flags.isClassMethod()) {
                builder.decorate("classmethod");
            } else if (flags.isStaticMethod()) {
                builder.decorate("staticmethod");
            }
        }
    }

    private static void addFakeParameters(PyFunctionBuilder builder, AbstractVariableData[] variableData) {
        for (AbstractVariableData data : variableData) {
            builder.parameter(data.getOriginalName());
        }
    }

    private static Pair<String, AbstractVariableData[]> getNameAndVariableData(Project project, CodeFragment fragment, PsiElement element, final boolean isClassMethod, final boolean isStaticMethod) {
        PyExtractMethodValidator validator = new PyExtractMethodValidator(element, project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String error;
            String name = System.getProperty(NAME);
            if (name == null) {
                name = "foo";
            }
            if ((error = validator.check(name)) != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(error);
                }
                if (Messages.showOkCancelDialog((String)(error + ". " + RefactoringBundle.message((String)"do.you.wish.to.continue")), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon()) != 0) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(error);
                }
            }
            ArrayList<AbstractVariableData> data = new ArrayList<AbstractVariableData>();
            for (String in : fragment.getInputVariables()) {
                AbstractVariableData d = new AbstractVariableData();
                d.name = in + "_new";
                d.originalName = in;
                d.passAsParameter = true;
                data.add(d);
            }
            return Pair.create((Object)name, (Object)data.toArray(new AbstractVariableData[data.size()]));
        }
        final boolean isMethod = PyPsiUtils.isMethodContext(element);
        ExtractMethodDecorator decorator = new ExtractMethodDecorator(){

            @Override
            public String createMethodPreview(String methodName, AbstractVariableData[] variableDatas) {
                StringBuilder builder = new StringBuilder();
                if (isClassMethod) {
                    builder.append("cls");
                } else if (isMethod && !isStaticMethod) {
                    builder.append("self");
                }
                for (AbstractVariableData variableData : variableDatas) {
                    if (!variableData.passAsParameter) continue;
                    if (builder.length() != 0) {
                        builder.append(", ");
                    }
                    builder.append(variableData.name);
                }
                builder.insert(0, "(");
                builder.insert(0, methodName);
                builder.insert(0, "def ");
                builder.append(")");
                return builder.toString();
            }
        };
        AbstractExtractMethodDialog dialog = new AbstractExtractMethodDialog(project, "method_name", fragment, validator, decorator, (FileType)PythonFileType.INSTANCE){

            @Override
            protected String getHelpId() {
                return "python.reference.extractMethod";
            }
        };
        dialog.show();
        if (!dialog.isOK()) {
            return Pair.create(null, null);
        }
        return Pair.create((Object)dialog.getMethodName(), (Object)dialog.getVariableData());
    }

    public static String getRefactoringId() {
        return "refactoring.python.extract.method";
    }

    private static class PyExtractMethodValidator
    implements ExtractMethodValidator {
        private final PsiElement myElement;
        private final Project myProject;
        private final Function<String, Boolean> myFunction;

        public PyExtractMethodValidator(PsiElement element, Project project) {
            this.myElement = element;
            this.myProject = project;
            final ScopeOwner parent = ScopeUtil.getScopeOwner(this.myElement);
            this.myFunction = new Function<String, Boolean>(){

                public Boolean fun(String s) {
                    ScopeOwner owner = parent;
                    while (owner != null) {
                        if (owner instanceof PyClass && ((PyClass)owner).findMethodByName(s, true) != null) {
                            return false;
                        }
                        Scope scope = ControlFlowCache.getScope(owner);
                        if (scope.containsDeclaration(s)) {
                            return false;
                        }
                        owner = ScopeUtil.getScopeOwner((PsiElement)owner);
                    }
                    return true;
                }
            };
        }

        @Override
        public String check(String name) {
            if (this.myFunction != null && !((Boolean)this.myFunction.fun((Object)name)).booleanValue()) {
                return PyBundle.message("refactoring.extract.method.error.name.clash", new Object[0]);
            }
            return null;
        }

        @Override
        public boolean isValidName(String name) {
            NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)PythonLanguage.getInstance());
            assert (validator != null);
            return validator.isIdentifier(name, this.myProject);
        }
    }
}

